/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.refined.Filter;
import org.eclipse.mat.query.refined.RefinedTable;
import org.eclipse.mat.query.refined.RefinedTree;
import org.eclipse.mat.report.IOutputter;
import org.eclipse.mat.report.Renderer;

@Renderer(target="csv", result={IResultTree.class, IResultTable.class})
public class CSVOutputter
implements IOutputter {
    private static final char SEPARATOR = (char)(new DecimalFormatSymbols().getDecimalSeparator() == ',' ? 59 : 44);

    public void process(IOutputter.Context context, IResult result, Writer writer) throws IOException {
        this.embedd(context, result, writer);
    }

    public void embedd(IOutputter.Context context, IResult result, Writer writer) throws IOException {
        block12: {
            Filter.ValueConverter[] filter;
            Column[] columns;
            block11: {
                columns = result instanceof RefinedTable ? ((RefinedTable)result).getColumns() : ((RefinedTree)result).getColumns();
                filter = new Filter.ValueConverter[columns.length];
                int columnIndex = 0;
                while (columnIndex < columns.length) {
                    filter[columnIndex] = (Filter.ValueConverter)columns[columnIndex].getData(Filter.ValueConverter.class);
                    if (context.isColumnVisible(columnIndex)) {
                        if (columns[columnIndex].getLabel() != null) {
                            writer.append(columns[columnIndex].getLabel());
                        }
                        writer.append(SEPARATOR);
                    }
                    ++columnIndex;
                }
                writer.append("\n");
                if (!(result instanceof RefinedTable)) break block11;
                RefinedTable table = (RefinedTable)result;
                int limit = context.hasLimit() ? Math.min(table.getRowCount(), context.getLimit()) : table.getRowCount();
                int i = 0;
                while (i < limit) {
                    int columnIndex2 = 0;
                    while (columnIndex2 < columns.length) {
                        if (context.isColumnVisible(columnIndex2)) {
                            Object columnValue = table.getColumnValue(table.getRow(i), columnIndex2);
                            if (columnValue != null) {
                                writer.append(this.getStringValue(columnValue, filter[columnIndex2]));
                            }
                            writer.append(SEPARATOR);
                        }
                        ++columnIndex2;
                    }
                    writer.append("\n");
                    ++i;
                }
                break block12;
            }
            if (!(result instanceof RefinedTree)) break block12;
            RefinedTree tree = (RefinedTree)result;
            List<?> elements = tree.getElements();
            int limit = context.hasLimit() ? Math.min(elements.size(), context.getLimit()) : elements.size();
            int i = 0;
            while (i < limit) {
                int columnIndex = 0;
                while (columnIndex < columns.length) {
                    if (context.isColumnVisible(columnIndex)) {
                        Object columnValue = tree.getColumnValue(elements.get(i), columnIndex);
                        if (columnValue != null) {
                            writer.append(this.getStringValue(columnValue, filter[columnIndex]));
                        }
                        writer.append(SEPARATOR);
                    }
                    ++columnIndex;
                }
                writer.append("\n");
                ++i;
            }
        }
    }

    private String getStringValue(Object columnValue, Filter.ValueConverter converter) {
        if (columnValue == null) {
            return "";
        }
        DecimalFormat fmt = null;
        if (columnValue instanceof Long || columnValue instanceof Integer) {
            fmt = new DecimalFormat("0");
        } else if (columnValue instanceof Double || columnValue instanceof Float) {
            fmt = new DecimalFormat("0.#####");
        }
        if (converter != null) {
            columnValue = converter.convert(((Number)columnValue).doubleValue());
        }
        if (fmt != null) {
            return fmt.format(columnValue);
        }
        return columnValue.toString();
    }
}

