/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.mat.query.registry.CategoryDescriptor;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.actions.ExecuteQueryAction;
import org.eclipse.mat.ui.internal.browser.QueryBrowserPopup;
import org.eclipse.mat.ui.internal.browser.QueryHistory;
import org.eclipse.mat.ui.util.EasyToolBarDropDown;
import org.eclipse.mat.ui.util.PopupMenu;

public class QueryDropDownMenuAction
extends EasyToolBarDropDown {
    private MultiPaneEditor editor;
    private Action queryBrowser;

    public QueryDropDownMenuAction(MultiPaneEditor editor) {
        super("Open Query Browser", MemoryAnalyserPlugin.getImageDescriptor("icons/query_browser.gif"), editor);
        this.editor = editor;
        this.makeActions();
    }

    private void makeActions() {
        this.queryBrowser = new Action("Search Queries..."){

            public void run() {
                new QueryBrowserPopup(QueryDropDownMenuAction.this.editor).open();
            }
        };
        this.queryBrowser.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/query_browser.gif"));
        this.queryBrowser.setToolTipText("Search queries by name and description.");
        this.queryBrowser.setActionDefinitionId("org.eclipse.mat.ui.query.browser.QueryBrowser");
    }

    public void contribute(PopupMenu menu) {
        this.addCategorySubMenu(menu, QueryRegistry.instance().getRootCategory());
        menu.addSeparator();
        menu.add(this.queryBrowser);
        this.addHistory(menu);
    }

    private void addCategorySubMenu(PopupMenu menu, CategoryDescriptor category) {
        for (Object item : category.getChildren()) {
            QueryDescriptor query;
            if (item instanceof CategoryDescriptor) {
                CategoryDescriptor subCategory = (CategoryDescriptor)item;
                PopupMenu categoryItem = new PopupMenu(subCategory.getName());
                menu.add(categoryItem);
                this.addCategorySubMenu(categoryItem, subCategory);
                continue;
            }
            if (!(item instanceof QueryDescriptor) || !(query = (QueryDescriptor)item).accept(this.editor.getQueryContext())) continue;
            menu.add(new ExecuteQueryAction(this.editor, query));
        }
    }

    private void addHistory(PopupMenu menu) {
        List<String> history = QueryHistory.getHistoryEntries();
        if (!history.isEmpty()) {
            menu.addSeparator();
            PopupMenu historyMenu = new PopupMenu("History");
            historyMenu.setActionDefinitionId("org.eclipse.mat.ui.query.browser.QueryHistory");
            menu.add(historyMenu);
            int count = 0;
            for (String cmd : history) {
                historyMenu.add(new ExecuteQueryAction(this.editor, cmd));
                if (++count == 10) break;
            }
            Action action = new Action("All..."){

                public void run() {
                    new QueryBrowserPopup(QueryDropDownMenuAction.this.editor, true).open();
                }
            };
            historyMenu.add(action);
        }
    }
}

