/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.action.Action;
import org.eclipse.mat.report.SpecFactory;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.actions.ImportReportAction;
import org.eclipse.mat.ui.actions.RunExternalReportAction;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.actions.ExecuteQueryAction;
import org.eclipse.mat.ui.util.EasyToolBarDropDown;
import org.eclipse.mat.ui.util.PopupMenu;

public class RunReportsDropDownAction
extends EasyToolBarDropDown {
    private MultiPaneEditor editor;
    private Action importReportAction;
    private Action runExternalReportAction;

    public RunReportsDropDownAction(MultiPaneEditor editor) {
        super("Run Expert System Test", MemoryAnalyserPlugin.getImageDescriptor("icons/expert.gif"), editor);
        this.editor = editor;
        this.importReportAction = new ImportReportAction(editor);
        this.runExternalReportAction = new RunExternalReportAction(editor);
    }

    public void contribute(PopupMenu menu) {
        ArrayList<ExecuteQueryAction> reportActions = new ArrayList<ExecuteQueryAction>();
        for (SpecFactory.Report report : SpecFactory.instance().delegates()) {
            ExecuteQueryAction action = new ExecuteQueryAction(this.editor, "default_report " + report.getExtensionIdentifier());
            action.setText(report.getName());
            reportActions.add(action);
        }
        Collections.sort(reportActions, new Comparator<Action>(){

            @Override
            public int compare(Action o1, Action o2) {
                return o1.getText().compareTo(o2.getText());
            }
        });
        for (Action action : reportActions) {
            menu.add(action);
        }
        menu.addSeparator();
        menu.add(this.importReportAction);
        menu.add(this.runExternalReportAction);
    }
}

