/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.browser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.registry.CategoryDescriptor;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.browser.QueryBrowserItem;
import org.eclipse.mat.ui.internal.browser.QueryBrowserProvider;
import org.eclipse.mat.ui.internal.browser.QueryContextHelp;
import org.eclipse.mat.ui.internal.browser.QueryHistoryProvider;
import org.eclipse.mat.ui.internal.browser.QueryRegistryProvider;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBrowserPopup
extends PopupDialog {
    private static final int INITIAL_COUNT_PER_PROVIDER = 5;
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private List<QueryBrowserProvider> providers;
    private MultiPaneEditor editor;
    private Text filterText;
    private QueryContextHelp helpText;
    private Table table;
    private TextLayout textLayout;
    private boolean resized = false;

    public QueryBrowserPopup(MultiPaneEditor editor) {
        this(editor, false);
    }

    public QueryBrowserPopup(MultiPaneEditor editor, boolean onlyHistory) {
        super(editor.getEditorSite().getShell(), 16, true, true, true, true, null, "Start typing to find matches");
        this.editor = editor;
        this.providers = new ArrayList<QueryBrowserProvider>();
        this.providers.add(new QueryHistoryProvider());
        if (!onlyHistory) {
            this.addCategories(QueryRegistry.instance().getRootCategory());
        }
        this.create();
    }

    private void addCategories(CategoryDescriptor category) {
        for (CategoryDescriptor c : category.getSubCategories()) {
            this.providers.add(new QueryRegistryProvider(this.editor.getQueryContext(), c));
            this.addCategories(c);
        }
    }

    protected Control createTitleControl(Composite parent) {
        this.filterText = new Text(parent, 0);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(-1, Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1)).applyTo((Control)this.filterText);
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    if (e.stateMask != 0) {
                        QueryBrowserPopup.this.handleSelection(true);
                    } else if (QueryBrowserPopup.this.filterText.getText().length() == 0) {
                        QueryBrowserPopup.this.handleSelection(false);
                    } else {
                        QueryBrowserPopup.this.executeFilterText();
                    }
                    return;
                }
                if (e.keyCode == 0x1000002) {
                    int index = QueryBrowserPopup.this.table.getSelectionIndex();
                    if (index != -1 && QueryBrowserPopup.this.table.getItemCount() > index + 1) {
                        QueryBrowserPopup.this.table.setSelection(index + 1);
                        QueryBrowserPopup.this.updateHelp();
                    }
                    QueryBrowserPopup.this.table.setFocus();
                } else if (e.keyCode == 0x1000001) {
                    int index = QueryBrowserPopup.this.table.getSelectionIndex();
                    if (index != -1 && index >= 1) {
                        QueryBrowserPopup.this.table.setSelection(index - 1);
                        QueryBrowserPopup.this.updateHelp();
                        QueryBrowserPopup.this.table.setFocus();
                    }
                } else if (e.character == '\u001b') {
                    QueryBrowserPopup.this.close();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText().toLowerCase();
                QueryBrowserPopup.this.refresh(text);
            }
        });
        return this.filterText;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        boolean isWin32 = "win32".equals(SWT.getPlatform());
        GridLayoutFactory.fillDefaults().extendedMargins(isWin32 ? 0 : 3, 3, 2, 2).applyTo(composite);
        Composite tableComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.table = new Table(tableComposite, 65540);
        this.textLayout = new TextLayout((Device)this.table.getDisplay());
        this.textLayout.setOrientation(QueryBrowserPopup.getDefaultOrientation());
        Font boldFont = this.resourceManager.createFont(FontDescriptor.createFrom((Font)this.table.getFont()).setStyle(1));
        this.textLayout.setFont(this.table.getFont());
        this.textLayout.setText("Categories");
        this.textLayout.setFont(boldFont);
        tableColumnLayout.setColumnData((Widget)new TableColumn(this.table, 0), (ColumnLayoutData)new ColumnWeightData(100, 100));
        this.table.getShell().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!QueryBrowserPopup.this.resized) {
                    QueryBrowserPopup.this.resized = true;
                    e.display.timerExec(100, new Runnable(){

                        public void run() {
                            if (QueryBrowserPopup.this.getShell() != null && !QueryBrowserPopup.this.getShell().isDisposed()) {
                                QueryBrowserPopup.this.refresh(QueryBrowserPopup.this.filterText.getText().toLowerCase());
                            }
                            QueryBrowserPopup.this.resized = false;
                        }
                    });
                }
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 && QueryBrowserPopup.this.table.getSelectionIndex() == 0) {
                    QueryBrowserPopup.this.filterText.setFocus();
                } else if (e.character == '\u001b') {
                    QueryBrowserPopup.this.close();
                } else if (e.keyCode == 13 && e.stateMask != 0) {
                    QueryBrowserPopup.this.handleSelection(true);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (QueryBrowserPopup.this.table.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1 && e.button != 3) {
                    return;
                }
                if (QueryBrowserPopup.this.table.equals(e.getSource())) {
                    TableItem o = QueryBrowserPopup.this.table.getItem(new Point(e.x, e.y));
                    TableItem selection = QueryBrowserPopup.this.table.getSelection()[0];
                    if (selection.equals(o)) {
                        if (e.button == 1) {
                            QueryBrowserPopup.this.handleSelection(false);
                        } else {
                            QueryBrowserPopup.this.handleSelection(true);
                        }
                    }
                }
            }
        });
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                QueryBrowserPopup.this.updateHelp();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                QueryBrowserPopup.this.handleSelection(false);
            }
        });
        final TextStyle boldStyle = new TextStyle(boldFont, null, null);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                QueryBrowserItem entry = (QueryBrowserItem)event.item.getData();
                if (entry != null) {
                    switch (event.type) {
                        case 41: {
                            entry.measure(event, QueryBrowserPopup.this.textLayout, (ResourceManager)QueryBrowserPopup.this.resourceManager, boldStyle);
                            break;
                        }
                        case 42: {
                            entry.paint(event, QueryBrowserPopup.this.textLayout, (ResourceManager)QueryBrowserPopup.this.resourceManager, boldStyle);
                            break;
                        }
                        case 40: {
                            entry.erase(event);
                        }
                    }
                } else {
                    switch (event.type) {
                        case 41: {
                            event.height = Math.max(event.height, 18);
                            event.width = 16;
                            break;
                        }
                        case 42: {
                            break;
                        }
                    }
                }
            }
        };
        this.table.addListener(41, listener);
        this.table.addListener(40, listener);
        this.table.addListener(42, listener);
        new TableItem(this.table, 0);
        return composite;
    }

    private int computeNumberOfItems() {
        int height = this.table.getClientArea().height;
        int lineWidth = this.table.getLinesVisible() ? this.table.getGridLineWidth() : 0;
        return (height - lineWidth) / (this.table.getItemHeight() + lineWidth);
    }

    private void refresh(String filter) {
        int numItems = this.computeNumberOfItems();
        List<QueryBrowserItem> entries = this.computeMatchingEntries(filter, numItems);
        this.refreshTable(entries);
        if (this.table.getItemCount() > 0) {
            this.table.setSelection(0);
            this.updateHelp();
        }
        if (filter.length() == 0) {
            this.setInfoText("Start typing to find matches");
        } else {
            this.setInfoText("Press Strg-Enter to copy query into input field");
        }
    }

    protected Control getFocusControl() {
        return this.filterText;
    }

    public boolean close() {
        if (this.textLayout != null && !this.textLayout.isDisposed()) {
            this.textLayout.dispose();
        }
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
        return super.close();
    }

    protected Point getInitialSize() {
        if (!this.getPersistBounds()) {
            return new Point(450, 400);
        }
        return super.getInitialSize();
    }

    protected Point getInitialLocation(Point initialSize) {
        if (!this.getPersistBounds()) {
            Point size = new Point(400, 400);
            Rectangle parentBounds = this.getParentShell().getBounds();
            int x = parentBounds.x + parentBounds.width / 2 - size.x / 2;
            int y = parentBounds.y + parentBounds.height / 2 - size.y / 2;
            return new Point(x, y);
        }
        return super.getInitialLocation(initialSize);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings workbenchDialogSettings = MemoryAnalyserPlugin.getDefault().getDialogSettings();
        IDialogSettings result = workbenchDialogSettings.getSection(QueryBrowserPopup.class.getName());
        if (result == null) {
            result = workbenchDialogSettings.addNewSection(QueryBrowserPopup.class.getName());
        }
        return result;
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        dialogMenu.add((IAction)new Action("Close"){

            public void run() {
                QueryBrowserPopup.this.close();
            }
        });
        dialogMenu.add((IContributionItem)new Separator());
        super.fillDialogMenu(dialogMenu);
    }

    private void executeFilterText() {
        try {
            String cmdLine = this.filterText.getText();
            this.close();
            QueryExecution.executeCommandLine(this.editor, null, cmdLine);
        }
        catch (SnapshotException e) {
            ErrorHelper.showErrorMessage(e);
        }
    }

    private void handleSelection(boolean doUpdateFilterText) {
        if (this.table.getSelectionCount() != 1) {
            this.close();
            return;
        }
        Element selectedElement = ((QueryBrowserItem)this.table.getItem((int)this.table.getSelectionIndex()).getData()).element;
        if (selectedElement == null) {
            return;
        }
        if (doUpdateFilterText) {
            this.filterText.setText(selectedElement.getUsage());
            this.filterText.setSelection(0);
            this.filterText.setFocus();
        } else {
            this.close();
            if (!this.editor.isDisposed()) {
                try {
                    selectedElement.execute(this.editor);
                }
                catch (SnapshotException e) {
                    ErrorHelper.showErrorMessage(e);
                }
            }
        }
    }

    private void updateHelp() {
        if (this.table.getSelectionCount() > 0) {
            QueryDescriptor query;
            Element selectedElement = ((QueryBrowserItem)this.table.getItem((int)this.table.getSelectionIndex()).getData()).element;
            QueryDescriptor queryDescriptor = query = selectedElement != null ? selectedElement.getQuery() : null;
            if (query != null && query.getHelp() != null) {
                if (this.helpText == null || this.helpText.getQuery() != query) {
                    if (this.helpText != null) {
                        this.helpText.close();
                    }
                    Rectangle myBounds = this.getShell().getBounds();
                    Rectangle helpBounds = new Rectangle(myBounds.x, myBounds.y + myBounds.height, myBounds.width, -1);
                    this.helpText = new QueryContextHelp(this.getShell(), query, helpBounds);
                    this.helpText.open();
                }
            } else if (this.helpText != null) {
                this.helpText.close();
            }
        } else if (this.helpText != null) {
            this.helpText.close();
        }
    }

    private void refreshTable(List<QueryBrowserItem> entries) {
        if (this.table.getItemCount() > entries.size() && this.table.getItemCount() - entries.size() > 20) {
            this.table.removeAll();
        }
        TableItem[] items = this.table.getItems();
        int index = 0;
        for (QueryBrowserItem entry : entries) {
            TableItem item;
            if (index < items.length) {
                item = items[index];
                this.table.clear(index);
            } else {
                item = new TableItem(this.table, 0);
            }
            item.setData((Object)entry);
            if (entry.element != null) {
                item.setText(0, entry.element.getLabel());
            } else {
                item.setText(0, entry.provider.getName());
            }
            ++index;
        }
        if (index < items.length) {
            this.table.remove(index, items.length - 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<QueryBrowserItem> computeMatchingEntries(String filter, int maxCount) {
        ArrayList entries = new ArrayList(this.providers.size());
        int[] indexPerCategory = new int[this.providers.size()];
        int countPerCategory = Math.min(maxCount / 4, 5);
        int countTotal = 0;
        boolean done = false;
        while (countTotal < maxCount && !done) {
            done = true;
            int ii = 0;
            while (ii < this.providers.size() && countTotal < maxCount) {
                Object var9_11 = null;
                if (ii == entries.size()) {
                    ArrayList arrayList = new ArrayList();
                    entries.add(arrayList);
                    ++countTotal;
                } else {
                    List list = (List)entries.get(ii);
                }
                int count = 0;
                QueryBrowserProvider provider = this.providers.get(ii);
                Element[] elements = provider.getElementsSorted();
                int j = indexPerCategory[ii];
                while (j < elements.length && count < countPerCategory && countTotal < maxCount) {
                    Element element = elements[j];
                    QueryBrowserItem entry = null;
                    if (filter.length() == 0) {
                        entry = new QueryBrowserItem(element, provider, 0, 0);
                    } else {
                        String sortLabel = element.getLabel();
                        int index = sortLabel.toLowerCase().indexOf(filter);
                        if (index != -1) {
                            entry = new QueryBrowserItem(element, provider, index, index + filter.length() - 1);
                        } else {
                            String help;
                            index = provider.getName().toLowerCase().indexOf(filter);
                            if (index == -1 && element.getQuery() != null && (help = element.getQuery().getHelp()) != null) {
                                index = help.toLowerCase().indexOf(filter);
                            }
                            if (index != -1) {
                                entry = new QueryBrowserItem(element, provider, 0, 0);
                            }
                        }
                    }
                    if (entry != null) {
                        void var9_10;
                        var9_10.add(entry);
                        ++count;
                        ++countTotal;
                    }
                    ++j;
                }
                indexPerCategory[ii] = j;
                if (j < elements.length) {
                    done = false;
                }
                ++ii;
            }
            countPerCategory = 1;
        }
        ArrayList<QueryBrowserItem> answer = new ArrayList<QueryBrowserItem>();
        for (List list : entries) {
            if (list.isEmpty()) continue;
            QueryBrowserItem firstElement = (QueryBrowserItem)list.get(0);
            answer.add(new QueryBrowserItem(null, firstElement.provider, 0, 0));
            answer.addAll(list);
            ((QueryBrowserItem)answer.get((int)(answer.size() - 1))).lastInCategory = true;
        }
        return answer;
    }

    public static interface Element {
        public String getLabel();

        public String getUsage();

        public QueryDescriptor getQuery();

        public ImageDescriptor getImageDescriptor();

        public void execute(MultiPaneEditor var1) throws SnapshotException;
    }
}

