/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.browser;

import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.browser.QueryBrowserPopup;
import org.eclipse.mat.ui.internal.browser.QueryBrowserProvider;
import org.eclipse.mat.ui.internal.browser.QueryHistory;

public class QueryHistoryProvider
extends QueryBrowserProvider {
    public QueryBrowserPopup.Element[] getElements() {
        List<String> history = QueryHistory.getHistoryEntries();
        QueryBrowserPopup.Element[] elements = new QueryBrowserPopup.Element[history.size()];
        int index = 0;
        for (String entry : history) {
            elements[index++] = new HQQElement(entry);
        }
        return elements;
    }

    public String getName() {
        return "History";
    }

    public QueryBrowserPopup.Element[] getElementsSorted() {
        if (this.sortedElements == null) {
            this.sortedElements = this.getElements();
        }
        return this.sortedElements;
    }

    static class HQQElement
    implements QueryBrowserPopup.Element {
        QueryDescriptor query;
        String commandLine;

        public HQQElement(String commandLine) {
            this.commandLine = commandLine;
            int p = commandLine.indexOf(32);
            String name = p < 0 ? commandLine : commandLine.substring(0, p);
            this.query = QueryRegistry.instance().getQuery(name);
        }

        public String getLabel() {
            return this.commandLine;
        }

        public String getUsage() {
            return this.commandLine;
        }

        public QueryDescriptor getQuery() {
            return this.query;
        }

        public void execute(MultiPaneEditor editor) throws SnapshotException {
            QueryExecution.executeCommandLine(editor, null, this.commandLine);
        }

        public ImageDescriptor getImageDescriptor() {
            if (this.query != null && this.query.getIcon() != null) {
                return MemoryAnalyserPlugin.getDefault().getImageDescriptor(this.query);
            }
            return null;
        }
    }
}

