/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.internal.browser.QueryContextHelp;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentsWizardPage;
import org.eclipse.swt.graphics.Rectangle;

public class ArgumentsWizard
extends Wizard {
    private IQueryContext context;
    private ArgumentSet argumentSet;

    public IDialogSettings getDialogSettings() {
        IDialogSettings workbenchDialogSettings = MemoryAnalyserPlugin.getDefault().getDialogSettings();
        IDialogSettings result = workbenchDialogSettings.getSection(ArgumentsWizard.class.getName());
        if (result == null) {
            result = workbenchDialogSettings.addNewSection(ArgumentsWizard.class.getName());
        }
        return result;
    }

    public ArgumentsWizard(IQueryContext context, ArgumentSet argumentSet) {
        this.context = context;
        this.argumentSet = argumentSet;
        this.setWindowTitle(argumentSet.getQueryDescriptor().getName());
        this.setForcePreviousAndNextButtons(false);
        this.setDefaultPageImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/fill_arguments_wiz.gif"));
    }

    public void addPages() {
        this.addPage((IWizardPage)new ArgumentsWizardPage(this.context, this.argumentSet));
        if (this.argumentSet.getQueryDescriptor().getHelp() != null) {
            this.getShell().getDisplay().timerExec(100, new Runnable(){

                public void run() {
                    if (ArgumentsWizard.this.getShell() != null && !ArgumentsWizard.this.getShell().isDisposed()) {
                        Rectangle myBounds = ArgumentsWizard.this.getShell().getBounds();
                        Rectangle helpBounds = new Rectangle(myBounds.x, myBounds.y + myBounds.height, myBounds.width, -1);
                        new QueryContextHelp(ArgumentsWizard.this.getShell(), ArgumentsWizard.this.argumentSet.getQueryDescriptor(), helpBounds).open();
                    }
                }
            });
        }
    }

    public boolean performFinish() {
        return true;
    }
}

