/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentsTable;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentsWizard;
import org.eclipse.mat.ui.internal.query.arguments.LinkEditor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ArgumentsWizardPage
extends WizardPage
implements ArgumentsTable.ITableListener {
    private IQueryContext context;
    private ArgumentSet argumentSet;
    private ArgumentsTable table;

    public ArgumentsWizardPage(IQueryContext context, ArgumentSet argumentSet) {
        super("Query Arguments", argumentSet.getQueryDescriptor().getName(), null);
        this.setDescription(argumentSet.getQueryDescriptor().getShortDescription());
        this.context = context;
        this.argumentSet = argumentSet;
    }

    public void createControl(Composite parent) {
        ScrolledComposite composite = new ScrolledComposite(parent, 2816);
        composite.setLayout((Layout)new GridLayout());
        composite.setExpandHorizontal(true);
        composite.setExpandVertical(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Composite tableComposite = new Composite((Composite)composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).indent(0, 0).applyTo((Control)tableComposite);
        LinkEditor.Mode mode = LinkEditor.Mode.SIMPLE_MODE;
        if (this.getDialogSettings().get(ArgumentsWizard.class.getName()) != null && LinkEditor.Mode.ADVANCED_MODE.getModeType().equals(this.getDialogSettings().get(ArgumentsWizard.class.getName()))) {
            mode = LinkEditor.Mode.ADVANCED_MODE;
        }
        this.table = new ArgumentsTable(tableComposite, 65540, this.context, this.argumentSet, mode);
        this.table.addListener(this);
        tableComposite.layout();
        tableComposite.pack();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.mat.ui.help.query_arguments");
        composite.setContent((Control)tableComposite);
        this.setControl((Control)composite);
    }

    public boolean isPageComplete() {
        return this.argumentSet.isExecutable() && this.getErrorMessage() == null;
    }

    public void onInputChanged() {
        this.getContainer().updateButtons();
    }

    public void onError(String message) {
        this.setErrorMessage(message);
        this.onFocus(null);
    }

    public void onFocus(String message) {
        if (this.getErrorMessage() != null) {
            this.setMessage(this.getErrorMessage(), 3);
        } else if (message != null) {
            this.setMessage(message, 1);
        } else {
            this.setMessage(this.argumentSet.getQueryDescriptor().getShortDescription());
        }
        this.getContainer().updateButtons();
    }

    public void onModeChange(LinkEditor.Mode mode) {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(ArgumentsWizard.class.getName(), mode.getModeType());
    }
}

