/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

public class BooleanComboEditor
extends ArgumentEditor {
    private static final String BOOLEAN_TRUE = Boolean.TRUE.toString();
    private static final String BOOLEAN_FALSE = Boolean.FALSE.toString();
    private CCombo combo;
    private Boolean value;

    public BooleanComboEditor(Composite parent, IQueryContext context, ArgumentDescriptor descriptor, TableItem item) {
        super(parent, context, descriptor, item);
        this.setBackground(parent.getBackground());
        this.setLayout((Layout)new FillLayout());
        this.createContents(parent);
    }

    private void createContents(Composite parent) {
        this.combo = new CCombo((Composite)this, 72);
        this.combo.setBackground(parent.getBackground());
        this.combo.add(BOOLEAN_TRUE, 0);
        this.combo.add(BOOLEAN_FALSE, 1);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BooleanComboEditor.this.editingDone();
            }
        });
    }

    protected void editingDone() {
        try {
            this.value = (Boolean)this.context.convertToValue(this.descriptor.getType(), this.descriptor.getAdvice(), this.combo.getText());
            this.fireValueChangedEvent(this.value, this);
        }
        catch (SnapshotException snapshotException) {}
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) throws SnapshotException {
        this.value = (Boolean)value;
        this.combo.select(this.value != false ? 0 : 1);
    }

    public boolean setFocus() {
        return this.combo.setFocus();
    }
}

