/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

public class CheckBoxEditor
extends ArgumentEditor {
    private Button checkBox;
    private Boolean value = false;
    private Type type;

    public CheckBoxEditor(Composite parent, IQueryContext context, ArgumentDescriptor descriptor, TableItem item, Type type) {
        super(parent, context, descriptor, item);
        this.type = type;
        this.setBackground(parent.getBackground());
        this.setLayout((Layout)new FillLayout());
        this.createContents(parent);
    }

    private void createContents(Composite parent) {
        this.checkBox = new Button((Composite)this, 32);
        this.checkBox.setBackground(parent.getBackground());
        this.checkBox.setText(this.type.getLabel());
        this.checkBox.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CheckBoxEditor.this.fireFocusEvent(CheckBoxEditor.this.type.getHelpText());
            }

            public void focusLost(FocusEvent e) {
                CheckBoxEditor.this.fireFocusEvent(null);
            }
        });
        this.checkBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CheckBoxEditor.this.editingDone();
            }
        });
        this.checkBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    CheckBoxEditor.this.editingDone();
                }
            }
        });
    }

    protected void editingDone() {
        this.value = this.checkBox.getSelection();
        this.fireValueChangedEvent(this.value, this);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) throws SnapshotException {
        this.value = (Boolean)value;
        this.checkBox.setSelection(this.value.booleanValue());
    }

    public boolean setFocus() {
        return this.checkBox.setFocus();
    }

    public Type getType() {
        return this.type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INCLUDE_CLASS_INSTANCE("include class instance (if defined by a pattern)", null),
        INCLUDE_SUBCLASSES("include subclasses (if object is a class)", "If specified together with <pattern> the subclasses of the classes matching the pattern will also be included"),
        INTEPRET_AS_CLASSLOADER("include loaded objects (if specified object is a classloader)", "If specified together with <object address> the address will be interpet as address of a classloader"),
        RETAINED("as retained set", "Specifies that the retained set of the described object set should be taken, and not the object set itself"),
        VERBOSE("verbose", "Prints information about added classes to the error log");

        private String label;
        private String helpText;

        private Type(String label, String helpText) {
            this.label = label;
            this.helpText = helpText;
        }

        public String getLabel() {
            return this.label;
        }

        public String getHelpText() {
            return this.helpText;
        }
    }
}

