/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TableItem;

public class LinkEditor
extends ArgumentEditor {
    private Composite parent;
    private Mode mode;

    public LinkEditor(Composite parent, IQueryContext context, ArgumentDescriptor descriptor, TableItem item, Mode mode) {
        super(parent, context, descriptor, item);
        this.parent = parent;
        this.mode = mode;
        this.createContents();
    }

    private void createContents() {
        this.setBackground(this.parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.marginLeft = 20;
        layout.marginRight = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Link link = new Link((Composite)this, 64);
        link.setLayoutData((Object)new GridData(64));
        link.setText("<a>" + this.mode.getModeType() + "</a>");
        link.setBackground(this.parent.getBackground());
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.changeMode();
                LinkEditor.this.editingDone();
                LinkEditor.this.fireModeChangeEvent(LinkEditor.this.mode);
            }

            private void changeMode() {
                if (LinkEditor.this.mode.equals((Object)Mode.ADVANCED_MODE)) {
                    LinkEditor.this.mode = Mode.SIMPLE_MODE;
                } else {
                    LinkEditor.this.mode = Mode.ADVANCED_MODE;
                }
            }
        });
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object value) throws SnapshotException {
    }

    private void editingDone() {
        this.fireValueChangedEvent(null, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        ADVANCED_MODE("simple mode..."),
        SIMPLE_MODE("more options...");

        private String modeType;

        private Mode(String modeType) {
            this.modeType = modeType;
        }

        public String getModeType() {
            return this.modeType;
        }
    }
}

