/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.CompositeHeapEditorPane;
import org.eclipse.mat.ui.editor.EditorPaneRegistry;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.util.Copy;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.NavigatorState;
import org.eclipse.mat.ui.util.PaneState;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class NavigatorViewPage
extends Page
implements ISelectionProvider,
IDoubleClickListener,
NavigatorState.IStateChangeListener {
    private TreeViewer treeViewer;
    private MultiPaneEditor editor;
    private Font font;
    private Color greyColor;
    private Action showPaneAction;
    private Action removeWithChildrenAction;
    private Action closePaneAction;
    private Action closeWithChildrenAction;

    public NavigatorViewPage(MultiPaneEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent);
        this.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.setContentProvider((IContentProvider)new NavigatorContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new NavigatorLabelProvider());
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.editor.getNavigatorState().addChangeStateListener(this);
        this.initializeFont();
        this.treeViewer.setInput(this.editor.getNavigatorState().getElements());
        this.treeViewer.expandAll();
        this.makeActions();
    }

    private void makeActions() {
        this.showPaneAction = new Action(){

            public void run() {
                NavigatorViewPage.this.bringToTop((IStructuredSelection)NavigatorViewPage.this.treeViewer.getSelection());
            }
        };
        this.showPaneAction.setText("Activate");
        this.showPaneAction.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/show_pane.gif"));
        this.removeWithChildrenAction = new Action(){

            public void run() {
                NavigatorViewPage.this.close(true, true);
            }
        };
        this.removeWithChildrenAction.setText("Remove from List");
        this.removeWithChildrenAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.closePaneAction = new Action(){

            public void run() {
                NavigatorViewPage.this.close(false, false);
            }
        };
        this.closePaneAction.setText("Close");
        this.closePaneAction.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/close_pane.gif"));
        this.closeWithChildrenAction = new Action(){

            public void run() {
                NavigatorViewPage.this.close(false, true);
            }
        };
        this.closeWithChildrenAction.setText("Close Branch");
        this.closeWithChildrenAction.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/close_branch.gif"));
        Action copyAction = new Action(){

            public void run() {
                Copy.copyToClipboard((Control)NavigatorViewPage.this.treeViewer.getTree());
            }
        };
        this.getSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)copyAction);
        this.getSite().getActionBars().updateActionBars();
    }

    private void close(boolean remove, boolean recursive) {
        TreeItem[] selection = this.treeViewer.getTree().getSelection();
        ArrayList<PaneState> selectedStates = new ArrayList<PaneState>(selection.length);
        TreeItem[] treeItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (!treeItem.isDisposed()) {
                PaneState state = (PaneState)treeItem.getData();
                selectedStates.add(state);
            }
            ++n2;
        }
        for (PaneState paneState : selectedStates) {
            this.closePane(paneState, remove, recursive);
        }
    }

    private void closePane(PaneState state, boolean remove, boolean recursive) {
        if (state.getType() == PaneState.PaneType.COMPOSITE_CHILD) {
            CompositeHeapEditorPane composite = (CompositeHeapEditorPane)this.editor.getEditor(state.getParentPaneState());
            if (composite != null) {
                composite.closePage(state);
            }
        } else {
            this.editor.closePage(state);
        }
        if (remove) {
            this.editor.getNavigatorState().removeEntry(state);
        }
        if (recursive) {
            ArrayList<PaneState> children = new ArrayList<PaneState>(state.getChildren());
            for (PaneState child : children) {
                this.closePane(child, remove, true);
            }
        }
        if (state.getType() == PaneState.PaneType.COMPOSITE_CHILD && !state.getParentPaneState().hasActiveChildren()) {
            this.closePane(state.getParentPaneState(), remove && !state.getParentPaneState().hasChildren(), false);
        }
    }

    private void initializeFont() {
        Font defaultFont = JFaceResources.getDefaultFont();
        FontData[] data = defaultFont.getFontData();
        int i = 0;
        while (i < data.length) {
            data[i].setStyle(2);
            ++i;
        }
        this.font = new Font((Device)this.treeViewer.getTree().getDisplay(), data);
        this.greyColor = this.treeViewer.getTree().getDisplay().getSystemColor(16);
    }

    private void createContextMenu(Control control) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                IStructuredSelection selection = (IStructuredSelection)NavigatorViewPage.this.treeViewer.getSelection();
                if (selection.size() != 0) {
                    NavigatorViewPage.this.editorContextMenuAboutToShow(menu, selection);
                }
            }
        });
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    private void editorContextMenuAboutToShow(IMenuManager menu, IStructuredSelection selection) {
        menu.add((IAction)this.showPaneAction);
        menu.add((IAction)this.closePaneAction);
        menu.add((IAction)this.closeWithChildrenAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.removeWithChildrenAction);
        if (selection.size() > 1) {
            boolean enabled = false;
            for (PaneState state : selection) {
                if (!state.isActive()) continue;
                enabled = true;
                break;
            }
            this.closePaneAction.setEnabled(enabled);
            this.showPaneAction.setEnabled(false);
            this.closeWithChildrenAction.setEnabled(false);
        } else {
            PaneState state = (PaneState)selection.getFirstElement();
            this.showPaneAction.setEnabled(state.isReproducable() || state.isActive());
            this.closePaneAction.setEnabled(state.isActive());
            this.closeWithChildrenAction.setEnabled(state.isActive());
        }
    }

    public Control getControl() {
        if (this.treeViewer == null) {
            return null;
        }
        return this.treeViewer.getControl();
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void update() {
        Control control;
        if (this.treeViewer != null && (control = this.treeViewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            this.treeViewer.setInput(this.editor.getNavigatorState().getElements());
            this.treeViewer.expandAll();
            control.setRedraw(true);
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection elements;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (elements = (IStructuredSelection)selection).size() == 1) {
            this.bringToTop(elements);
        }
    }

    private void bringToTop(IStructuredSelection selection) {
        PaneState state = (PaneState)selection.getFirstElement();
        if (state.isActive()) {
            if (state.getType() == PaneState.PaneType.COMPOSITE_CHILD) {
                state = state.getParentPaneState();
            }
            this.editor.bringPageToTop(state);
        } else if (state.isReproducable()) {
            try {
                PaneState.PaneType type = state.getType();
                switch (type) {
                    case EDITOR: {
                        AbstractEditorPane pane = EditorPaneRegistry.instance().createNewPane(state.getIdentifier());
                        pane.setPaneState(state);
                        this.editor.addNewPage(pane, null, null, null);
                        break;
                    }
                    case QUERY: {
                        QueryExecution.executeAgain(this.editor, state);
                        break;
                    }
                    case COMPOSITE_CHILD: {
                        AbstractEditorPane parent = this.editor.getEditor(state.getParentPaneState());
                        if (parent == null) {
                            parent = EditorPaneRegistry.instance().createNewPane(state.getParentPaneState().getIdentifier());
                            parent.setPaneState(state.getParentPaneState());
                            this.editor.addNewPage(parent, null, null, null);
                        }
                        parent.initWithArgument(state);
                    }
                }
            }
            catch (Exception e) {
                ErrorHelper.logThrowableAndShowMessage(e);
            }
        }
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public void onStateChanged(PaneState state) {
        if (state == null) {
            this.update();
        } else {
            Control control = this.treeViewer.getControl();
            if (control != null && !control.isDisposed()) {
                control.setRedraw(false);
                this.treeViewer.refresh((Object)state);
                this.treeViewer.expandToLevel((Object)state, -1);
                control.setRedraw(true);
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.treeViewer.setSelection(selection);
    }

    public void dispose() {
        this.editor.getNavigatorState().removeChangeStateListener(this);
        if (this.font != null) {
            this.font.dispose();
        }
        if (this.greyColor != null) {
            this.greyColor.dispose();
        }
        super.dispose();
    }

    private class NavigatorContentProvider
    implements ITreeContentProvider {
        private List<PaneState> elements;

        private NavigatorContentProvider() {
        }

        public Object[] getChildren(Object element) {
            return ((PaneState)element).getChildren().toArray();
        }

        public Object[] getElements(Object element) {
            return this.elements.toArray();
        }

        public boolean hasChildren(Object element) {
            return ((PaneState)element).hasChildren();
        }

        public Object getParent(Object element) {
            return ((PaneState)element).getParentPaneState();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.elements = (List)newInput;
        }
    }

    private class NavigatorLabelProvider
    extends LabelProvider
    implements IFontProvider,
    IColorProvider {
        private NavigatorLabelProvider() {
        }

        public Image getImage(Object element) {
            return ((PaneState)element).getImage();
        }

        public String getText(Object element) {
            return ((PaneState)element).getIdentifier();
        }

        public Font getFont(Object element) {
            if (((PaneState)element).isReproducable()) {
                return null;
            }
            return NavigatorViewPage.this.font;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (((PaneState)element).isActive()) {
                return null;
            }
            return NavigatorViewPage.this.greyColor;
        }
    }
}

