/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.views;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.DefaultHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.ui.util.QueryContextMenu;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotesView
extends ViewPart
implements IPartListener,
Observer {
    private static final int UNDO_LEVEL = 10;
    private File resource;
    private DisposeListener disposeListener;
    private Action undo;
    private Action redo;
    private Menu menu;
    private Font font;
    private Color hyperlinkColor;
    private MultiPaneEditor editor;
    private TextViewer textViewer;
    private TextViewerUndoManager undoManager;
    private Map<String, NotesViewAction> actions = new HashMap<String, NotesViewAction>();

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (NotesView.this.undoManager.undoable()) {
                    NotesView.this.saveNotes();
                }
            }
        };
        parent.addDisposeListener(this.disposeListener);
        this.textViewer = new TextViewer(parent, 17154);
        this.textViewer.setDocument((IDocument)new Document());
        this.textViewer.getControl().setEnabled(false);
        this.textViewer.getTextWidget().setWordWrap(false);
        this.font = new Font((Device)parent.getDisplay(), "Courier New", 8, 0);
        this.textViewer.getControl().setFont(this.font);
        this.hyperlinkColor = new Color(null, new RGB(0, 0, 255));
        this.getSite().getPage().addPartListener((IPartListener)this);
        this.undoManager = new TextViewerUndoManager(10);
        this.undoManager.connect((ITextViewer)this.textViewer);
        this.textViewer.setUndoManager((IUndoManager)this.undoManager);
        this.textViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NotesView.this.updateActions();
            }
        });
        this.textViewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 122 && (event.stateMask & SWT.MOD1) != 0) {
                    NotesView.this.undo.run();
                }
                if (event.keyCode == 121 && (event.stateMask & SWT.MOD1) != 0) {
                    NotesView.this.redo.run();
                }
            }
        });
        this.textViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                NotesView.this.searchForHyperlinks(NotesView.this.textViewer.getDocument().get(), 0);
            }
        });
        this.textViewer.setHyperlinkPresenter((IHyperlinkPresenter)new DefaultHyperlinkPresenter(this.hyperlinkColor));
        this.textViewer.setHyperlinkDetectors(new IHyperlinkDetector[]{new ObjectAddressHyperlinkDetector()}, SWT.MOD1);
        this.makeActions();
        this.hookContextMenu();
        this.showBootstrapPart();
        this.updateActions();
    }

    private void updateActions() {
        Iterator<NotesViewAction> iterator = this.actions.values().iterator();
        while (iterator.hasNext()) {
            ((IUpdate)iterator.next()).update();
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NotesView.this.textEditorContextMenuAboutToShow(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.textViewer.getControl());
        this.textViewer.getControl().setMenu(menu);
    }

    private void textEditorContextMenuAboutToShow(IMenuManager manager) {
        if (this.textViewer != null) {
            this.undo.setEnabled(this.undoManager.undoable());
            this.redo.setEnabled(this.undoManager.redoable());
            manager.add((IAction)this.undo);
            manager.add((IAction)this.redo);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.getAction(ActionFactory.CUT.getId()));
            manager.add((IAction)this.getAction(ActionFactory.COPY.getId()));
            manager.add((IAction)this.getAction(ActionFactory.PASTE.getId()));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.getAction(ActionFactory.DELETE.getId()));
            manager.add((IAction)this.getAction(ActionFactory.SELECT_ALL.getId()));
        }
    }

    private NotesViewAction getAction(String actionID) {
        return this.actions.get(actionID);
    }

    private Action addAction(ActionFactory actionFactory, int textOperation, String actionDefinitionId) {
        IWorkbenchWindow window = this.getViewSite().getWorkbenchWindow();
        ActionFactory.IWorkbenchAction globalAction = actionFactory.create(window);
        NotesViewAction action = new NotesViewAction(textOperation, actionDefinitionId);
        this.actions.put(actionFactory.getId(), action);
        action.setText(globalAction.getText());
        action.setToolTipText(globalAction.getToolTipText());
        action.setDescription(globalAction.getDescription());
        action.setImageDescriptor(globalAction.getImageDescriptor());
        action.setDisabledImageDescriptor(globalAction.getDisabledImageDescriptor());
        action.setAccelerator(globalAction.getAccelerator());
        action.update();
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(actionFactory.getId(), (IAction)action);
        return action;
    }

    public void setFocus() {
        this.textViewer.getControl().setFocus();
    }

    public void partActivated(IWorkbenchPart part) {
        if (!this.supportsNotes(part)) {
            return;
        }
        this.textViewer.getControl().setEnabled(true);
        this.editor = (MultiPaneEditor)part;
        File path = this.editor.getResourceFile();
        if (path != null && !path.equals(this.resource)) {
            this.resource = path;
            this.updateTextViewer();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        if (this.resource != null && this.undoManager.undoable()) {
            this.saveNotes();
        }
        this.partActivated(part);
    }

    public void partClosed(IWorkbenchPart part) {
        if (!this.supportsNotes(part)) {
            return;
        }
        MultiPaneEditor editor = (MultiPaneEditor)part;
        File resource = editor.getResourceFile();
        if (resource.equals(this.resource)) {
            if (this.undoManager.undoable()) {
                this.saveNotes();
            }
            this.resource = null;
            this.editor = null;
            this.updateTextViewer();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    private void showBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            this.partActivated((IWorkbenchPart)page.getActiveEditor());
        }
    }

    private void makeActions() {
        this.addAction(ActionFactory.CUT, 3, "org.eclipse.ui.edit.cut");
        this.addAction(ActionFactory.COPY, 4, "org.eclipse.ui.edit.copy");
        this.addAction(ActionFactory.PASTE, 5, "org.eclipse.ui.edit.paste");
        this.addAction(ActionFactory.DELETE, 6, "org.eclipse.ui.edit.delete");
        this.addAction(ActionFactory.SELECT_ALL, 7, "org.eclipse.ui.edit.selectAll");
        this.undo = this.addAction(ActionFactory.UNDO, 1, "org.eclipse.ui.edit.undo");
        this.redo = this.addAction(ActionFactory.REDO, 2, "org.eclipse.ui.edit.redo");
    }

    @Override
    public void update(Observable o, Object arg) {
        String path = (String)arg;
        if (path == null || path.equals(this.resource)) {
            this.updateTextViewer();
        }
    }

    private void updateTextViewer() {
        if (this.resource != null) {
            String buffer = NotesView.readNotes(this.resource);
            if (buffer != null) {
                Document document = new Document(buffer);
                this.textViewer.setDocument((IDocument)document);
                this.revealEndOfDocument();
            } else {
                this.textViewer.setDocument((IDocument)new Document(""));
            }
        } else {
            this.textViewer.setDocument((IDocument)new Document(""));
            this.textViewer.getControl().setEnabled(false);
        }
    }

    private void searchForHyperlinks(String allText, int offset) {
        if (this.resource == null) {
            return;
        }
        Pattern addressPattern = Pattern.compile("0x\\p{XDigit}+");
        String[] fields = allText.split("\\W", 0);
        ArrayList<IdHyperlink> hyperlinks = new ArrayList<IdHyperlink>();
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            if (addressPattern.matcher(field).matches()) {
                Region idRegion = new Region(offset, field.length());
                IdHyperlink hyperlink = new IdHyperlink(field, this.editor, (IRegion)idRegion);
                hyperlinks.add(hyperlink);
            }
            offset = offset + field.length() + 1;
            ++n2;
        }
        if (!hyperlinks.isEmpty()) {
            this.highlightHyperlinks(hyperlinks);
        }
    }

    private void highlightHyperlinks(List<IdHyperlink> hyperlinks) {
        TextPresentation style = new TextPresentation();
        for (IHyperlink iHyperlink : hyperlinks) {
            int startIndex = iHyperlink.getHyperlinkRegion().getOffset();
            int length = iHyperlink.getHyperlinkRegion().getLength();
            StyleRange styleRange = new StyleRange(startIndex, length, this.hyperlinkColor, null, 2);
            styleRange.underline = true;
            style.addStyleRange(styleRange);
        }
        this.textViewer.changeTextPresentation(style, true);
    }

    private void saveNotes() {
        if (this.resource != null) {
            String text = this.textViewer.getDocument().get();
            if (text != null && text.trim() != "") {
                NotesView.saveNotes(this.resource, text);
            }
            this.resetUndoManager();
        }
    }

    public void dispose() {
        this.undoManager.disconnect();
        this.getSite().getPage().removePartListener((IPartListener)this);
        this.getSite().getShell().removeDisposeListener(this.disposeListener);
        if (this.font != null) {
            this.font.dispose();
        }
        if (this.hyperlinkColor != null) {
            this.hyperlinkColor.dispose();
        }
        if (this.menu != null) {
            this.menu.dispose();
        }
        super.dispose();
    }

    private boolean supportsNotes(IWorkbenchPart part) {
        if (part instanceof MultiPaneEditor) {
            this.textViewer.getControl().setEnabled(true);
            return true;
        }
        return false;
    }

    protected void revealEndOfDocument() {
        IDocument doc = this.textViewer.getDocument();
        int docLength = doc.getLength();
        if (docLength > 0) {
            this.textViewer.revealRange(docLength - 1, 1);
            StyledText widget = this.textViewer.getTextWidget();
            widget.setCaretOffset(docLength);
        }
    }

    public void resetUndoManager() {
        this.undoManager.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readNotes(File resourcePath) {
        String string;
        File notesFile;
        if (resourcePath == null || !(notesFile = NotesView.getDefaultNotesFile(resourcePath)).exists()) return null;
        FileReader fileReader = new FileReader(NotesView.getDefaultNotesFile(resourcePath));
        BufferedReader myInput = new BufferedReader(fileReader);
        try {
            String s;
            StringBuffer b = new StringBuffer();
            while ((s = myInput.readLine()) != null) {
                b.append(s);
                b.append("\n");
            }
            string = b.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    myInput.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            myInput.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
    }

    private static void saveNotes(File resource, String notes) {
        OutputStream fout = null;
        try {
            try {
                File notesFile = NotesView.getDefaultNotesFile(resource);
                fout = new FileOutputStream(notesFile);
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fout), "UTF8");
                out.write(notes);
                out.flush();
                out.close();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (fout != null) {
                fout.close();
            }
        }
        catch (IOException iOException) {}
    }

    private static File getDefaultNotesFile(File resource) {
        String filename = resource.getAbsolutePath();
        int p = filename.lastIndexOf(46);
        return new File(String.valueOf(filename.substring(0, p + 1)) + "notes.txt");
    }

    private final class IdHyperlink
    implements IHyperlink {
        String id;
        MultiPaneEditor editor;
        IRegion region;

        public IdHyperlink(String id, MultiPaneEditor editor, IRegion region) {
            this.id = id;
            this.editor = editor;
            this.region = region;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getHyperlinkText() {
            return null;
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            try {
                int objectId = this.editor.getQueryContext().mapToObjectId(this.id);
                if (objectId < 0) {
                    return;
                }
                QueryContextMenu contextMenu = new QueryContextMenu(this.editor, new ContextProvider(null){

                    public IContextObject getContext(final Object row) {
                        return new IContextObject(){

                            public int getObjectId() {
                                return (Integer)row;
                            }
                        };
                    }
                });
                PopupMenu popupMenu = new PopupMenu();
                contextMenu.addContextActions(popupMenu, (IStructuredSelection)new StructuredSelection((Object)objectId));
                if (NotesView.this.menu != null && !NotesView.this.menu.isDisposed()) {
                    NotesView.this.menu.dispose();
                }
                NotesView.this.menu = popupMenu.createMenu(this.editor.getEditorSite().getActionBars().getStatusLineManager(), (Control)PlatformUI.getWorkbench().getDisplay().getActiveShell());
                NotesView.this.menu.setVisible(true);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (SnapshotException snapshotException) {}
        }
    }

    private class NotesViewAction
    extends Action
    implements IUpdate {
        private int actionId;

        NotesViewAction(int actionId, String actionDefinitionId) {
            this.actionId = actionId;
            this.setActionDefinitionId(actionDefinitionId);
        }

        public boolean isEnabled() {
            return NotesView.this.textViewer.canDoOperation(this.actionId);
        }

        public void run() {
            NotesView.this.textViewer.doOperation(this.actionId);
        }

        public void update() {
            if (super.isEnabled() != this.isEnabled()) {
                this.setEnabled(this.isEnabled());
            }
        }
    }

    private class ObjectAddressHyperlinkDetector
    extends AbstractHyperlinkDetector {
        private ObjectAddressHyperlinkDetector() {
        }

        public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
            char ch;
            String text;
            IRegion lineInfo;
            if (region == null || textViewer == null) {
                return null;
            }
            IDocument document = textViewer.getDocument();
            int offset = region.getOffset();
            if (document == null) {
                return null;
            }
            try {
                lineInfo = document.getLineInformationOfOffset(offset);
                text = document.get(lineInfo.getOffset(), lineInfo.getLength());
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
            int index = offset - lineInfo.getOffset();
            do {
                ch = ' ';
                if (--index <= -1) continue;
                ch = text.charAt(index);
            } while (Character.isLetterOrDigit(ch));
            int startIndex = index + 1;
            index = offset - lineInfo.getOffset() - 1;
            while (++index < text.length() && Character.isLetterOrDigit(ch = text.charAt(index))) {
            }
            Pattern addressPattern = Pattern.compile("0x\\p{XDigit}+");
            String address = text.substring(startIndex, index);
            if (address != null && addressPattern.matcher(address).matches()) {
                Region idRegion = new Region(startIndex, address.length());
                return new IHyperlink[]{new IdHyperlink(address, NotesView.this.editor, (IRegion)idRegion)};
            }
            return null;
        }
    }
}

