/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.views;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.SnapshotHistoryService;
import org.eclipse.mat.ui.editor.PathEditorInput;
import org.eclipse.mat.ui.snapshot.views.SnapshotOutlinePage;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotHistoryView
extends ViewPart
implements SnapshotHistoryService.IChangeListener {
    private Table table;
    private Action actionOpen;
    private Action actionRemoveFromList;
    private Action actionDelete;
    private Action actionOpenFileInFileSystem;
    private Action actionDeleteIndeces;

    public void createPartControl(Composite parent) {
        this.table = new Table(parent, 66306);
        TableColumn tableColumn = new TableColumn(this.table, 16384);
        tableColumn.setText("Recently Used Files");
        tableColumn.setWidth(400);
        this.table.setHeaderVisible(true);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                TableItem[] selection = SnapshotHistoryView.this.table.getSelection();
                SnapshotHistoryView.this.openFile(selection);
            }
        });
        this.fillTable();
        this.makeActions();
        this.hookContextMenu();
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    SnapshotHistoryView.this.actionRemoveFromList.run();
                }
            }
        });
        SnapshotHistoryService.getInstance().addChangeListener(this);
    }

    private void fillTable() {
        List<SnapshotHistoryService.Entry> lastFiles = SnapshotHistoryService.getInstance().getVisitedEntries();
        for (SnapshotHistoryService.Entry entry : lastFiles) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(entry.getFilePath());
            tableItem.setData((Object)entry);
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            tableItem.setImage(MemoryAnalyserPlugin.getDefault().getImage(registry.getImageDescriptor(entry.getFilePath())));
        }
    }

    private void makeActions() {
        this.actionOpen = new Action(){

            public void run() {
                TableItem[] selection = SnapshotHistoryView.this.table.getSelection();
                SnapshotHistoryView.this.openFile(selection);
            }
        };
        this.actionOpen.setText("Open");
        this.actionOpen.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/open_snapshot.gif"));
        this.actionRemoveFromList = new Action(){

            public void run() {
                TableItem[] selection = SnapshotHistoryView.this.table.getSelection();
                ArrayList<Path> toDelete = new ArrayList<Path>(selection.length);
                TableItem[] tableItemArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    toDelete.add(new Path(((SnapshotHistoryService.Entry)item.getData()).getFilePath()));
                    ++n2;
                }
                for (Path path : toDelete) {
                    SnapshotHistoryService.getInstance().removePath((IPath)path);
                }
            }
        };
        this.actionRemoveFromList.setText("Remove from List");
        this.actionRemoveFromList.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.actionDelete = new Action(){

            public void run() {
                TableItem[] selection = SnapshotHistoryView.this.table.getSelection();
                if (selection.length == 0) {
                    return;
                }
                ArrayList<File> toDelete = new ArrayList<File>(selection.length);
                TableItem[] tableItemArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    toDelete.add(new File(((SnapshotHistoryService.Entry)item.getData()).getFilePath()));
                    ++n2;
                }
                String dialogTitle = toDelete.size() > 1 ? MessageFormat.format("Are you sure you want to delete these {0,number} file?", toDelete.size()) : MessageFormat.format("Are you sure you want to delete ''{0}''?", ((File)toDelete.get(0)).getAbsolutePath());
                DeleteSnapshotDialog deleteSnapshotDialog = new DeleteSnapshotDialog(SnapshotHistoryView.this.table.getShell(), dialogTitle);
                int response = deleteSnapshotDialog.open();
                if (response != 0) {
                    return;
                }
                for (File path : toDelete) {
                    SnapshotHistoryService.getInstance().removePath((IPath)new Path(path.getAbsolutePath()));
                }
                if (deleteSnapshotDialog.getDeleteInFileSystem()) {
                    for (File path : toDelete) {
                        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)new PathEditorInput((IPath)new Path(path.getAbsolutePath())));
                        if (editor != null) {
                            SnapshotHistoryView.this.getSite().getPage().closeEditor(editor, true);
                        }
                        path.delete();
                        SnapshotHistoryView.this.deleteIndexes(path, null);
                    }
                }
            }
        };
        this.actionDelete.setText("Delete File");
        this.actionDelete.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.actionOpenFileInFileSystem = new Action(){

            public void run() {
                TableItem[] selection = SnapshotHistoryView.this.table.getSelection();
                String filename = ((SnapshotHistoryService.Entry)selection[0].getData()).getFilePath();
                Path path = new Path(filename);
                File file = path.toFile();
                if (file.exists()) {
                    String osPath = path.toOSString();
                    String osName = System.getProperty("os.name").toLowerCase();
                    if (osName.indexOf("windows") != -1) {
                        String command = "explorer.exe /SELECT,\"" + osPath + "\"";
                        try {
                            Runtime.getRuntime().exec(command);
                        }
                        catch (IOException ex) {
                            ErrorHelper.showErrorMessage(ex);
                        }
                    } else if (osName.indexOf("mac") != -1) {
                        this.execute("open", osPath, file);
                    } else if (osName.indexOf("linux") != -1) {
                        String desktop = System.getProperty("sun.desktop");
                        String string = desktop = desktop == null ? "" : desktop.toLowerCase();
                        if (desktop.indexOf("gnome") != -1) {
                            this.execute("gnome-open", osPath, file);
                        } else if (desktop.indexOf("konqueror") != -1 || desktop.indexOf("kde") != -1) {
                            this.execute("konqueror", osPath, file);
                        } else {
                            this.displayMessage(MessageFormat.format("I do not know how to open the file manager for your Linux desktop ''{0}''. I will try to use gnome", desktop));
                            this.execute("gnome-open", osPath, file);
                        }
                    } else {
                        this.displayMessage(MessageFormat.format("Sorry, operation not implementation for OS: {0}", osName));
                    }
                } else {
                    this.displayMessage(MessageFormat.format("File {0} does not exist (anymore).", file.getAbsolutePath()));
                }
            }

            private void execute(String baseCommand, String osPath, File file) {
                try {
                    String forceDirectoryPath = osPath;
                    if (file.isFile()) {
                        forceDirectoryPath = file.getParentFile().getCanonicalPath();
                    }
                    Runtime.getRuntime().exec(new String[]{baseCommand, forceDirectoryPath});
                }
                catch (IOException ex) {
                    MemoryAnalyserPlugin.log(ex);
                }
            }

            private void displayMessage(String message) {
                MessageDialog.openInformation((Shell)SnapshotHistoryView.this.table.getParent().getShell(), (String)"Explore File System", (String)message);
            }
        };
        this.actionOpenFileInFileSystem.setText("Explore in File System");
        this.actionOpenFileInFileSystem.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/explore.gif"));
        this.actionDeleteIndeces = new Action("Delete Index Files"){

            public void run() {
                ArrayList problems = new ArrayList();
                TableItem[] tableItemArray = SnapshotHistoryView.this.table.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    File snapshot = new File(((SnapshotHistoryService.Entry)item.getData()).getFilePath());
                    SnapshotHistoryView.this.deleteIndexes(snapshot, problems);
                    ++n2;
                }
                if (!problems.isEmpty()) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Error deleting the following files:");
                    for (File f : problems) {
                        msg.append("\n\t").append(f.getAbsolutePath());
                    }
                    MessageBox box = new MessageBox(SnapshotHistoryView.this.table.getShell(), 33);
                    box.setMessage(msg.toString());
                    box.open();
                }
            }
        };
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SnapshotHistoryView.this.editorContextMenuAboutToShow(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.table);
        this.table.setMenu(menu);
    }

    private void editorContextMenuAboutToShow(IMenuManager manager) {
        TableItem[] selection = this.table.getSelection();
        if (selection.length == 0) {
            return;
        }
        this.actionOpen.setEnabled(selection.length == 1);
        manager.add((IAction)this.actionOpen);
        this.actionOpenFileInFileSystem.setEnabled(selection.length == 1);
        manager.add((IAction)this.actionOpenFileInFileSystem);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionDeleteIndeces);
    }

    public void dispose() {
        super.dispose();
        SnapshotHistoryService.getInstance().removeChangeListener(this);
    }

    public void setFocus() {
        this.table.setFocus();
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            return new Outline();
        }
        return super.getAdapter(required);
    }

    @Override
    public void onFileHistoryChange(final List<SnapshotHistoryService.Entry> visited) {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.getDisplay().syncExec(new Runnable(){

            public void run() {
                SnapshotHistoryView.this.table.removeAll();
                for (SnapshotHistoryService.Entry entry : visited) {
                    TableItem item = new TableItem(SnapshotHistoryView.this.table, 0);
                    item.setText(entry.getFilePath());
                    item.setData((Object)entry);
                    IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                    item.setImage(MemoryAnalyserPlugin.getDefault().getImage(registry.getImageDescriptor(entry.getFilePath())));
                }
            }
        });
    }

    private void openFile(TableItem[] selection) {
        if (selection.length == 1) {
            SnapshotHistoryService.Entry entry = (SnapshotHistoryService.Entry)selection[0].getData();
            Path path = new Path(entry.getFilePath());
            if (path.toFile().exists()) {
                try {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)new PathEditorInput((IPath)path), (String)entry.getEditorId(), (boolean)true);
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
            } else {
                MessageDialog.openError((Shell)this.table.getParent().getShell(), (String)"File does not exist anymore", (String)MessageFormat.format("The selected file does not exist anymore. It will be deleted from the history list.\n\nSelected File:\n{0}", path.toOSString()));
                SnapshotHistoryService.getInstance().removePath((IPath)path);
            }
        }
    }

    private void deleteIndexes(File snapshot, List<File> problems) {
        String[] indexFiles;
        File directory = snapshot.getParentFile();
        String name = snapshot.getName();
        int lastDot = name.lastIndexOf(46);
        final String prefix = lastDot >= 0 ? name.substring(0, lastDot) : name;
        final Pattern pattern = Pattern.compile("\\.(.*\\.)?index$");
        String[] stringArray = indexFiles = directory.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(prefix) && pattern.matcher(name.substring(prefix.length())).matches();
            }
        });
        int n = indexFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String indexFile = stringArray[n2];
            File f = new File(directory, indexFile);
            if (f.exists() && !f.delete() && problems != null) {
                problems.add(f);
            }
            ++n2;
        }
    }

    private static class DeleteSnapshotDialog
    extends MessageDialog {
        private boolean deleteInFileSystem = false;
        private Button deleteRadio;
        private SelectionListener selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    DeleteSnapshotDialog.this.deleteInFileSystem = button == DeleteSnapshotDialog.this.deleteRadio;
                }
            }
        };

        public DeleteSnapshotDialog(Shell parentShell, String dialogTitle) {
            super(parentShell, "Confirm Deletion", null, dialogTitle, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.deleteRadio = new Button(composite, 16);
            this.deleteRadio.addSelectionListener(this.selectionListener);
            this.deleteRadio.setText("Also delete in file system (including index files)");
            this.deleteRadio.setFont(parent.getFont());
            Button radio = new Button(composite, 16);
            radio.addSelectionListener(this.selectionListener);
            radio.setText("Delete only from history");
            radio.setFont(parent.getFont());
            this.deleteRadio.setSelection(this.deleteInFileSystem);
            radio.setSelection(!this.deleteInFileSystem);
            return composite;
        }

        boolean getDeleteInFileSystem() {
            return this.deleteInFileSystem;
        }
    }

    private class Outline
    extends SnapshotOutlinePage
    implements SelectionListener {
        SnapshotHistoryService.Entry current;

        public Outline() {
            SnapshotHistoryView.this.table.addSelectionListener((SelectionListener)this);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            SnapshotHistoryService.Entry newEntry = (SnapshotHistoryService.Entry)((TableItem)e.item).getData();
            if (newEntry != null) {
                if (!newEntry.equals(this.current)) {
                    this.current = newEntry;
                }
                this.updateSnapshotInput();
            } else {
                this.current = null;
                this.updateSnapshotInput();
            }
        }

        protected SnapshotInfo getBaseline() {
            return null;
        }

        protected SnapshotInfo getSnapshot() {
            return this.current != null && this.current.getInfo() instanceof SnapshotInfo ? (SnapshotInfo)this.current.getInfo() : null;
        }

        protected IPath getSnapshotPath() {
            return this.current != null ? new Path(this.current.getFilePath()) : null;
        }

        public void dispose() {
            SnapshotHistoryView.this.table.removeSelectionListener((SelectionListener)this);
            super.dispose();
        }
    }
}

