/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.actions;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.snapshot.editor.HeapEditor;
import org.eclipse.mat.ui.snapshot.editor.ISnapshotEditorInput;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OpenObjectByIdAction
extends Action {
    public OpenObjectByIdAction() {
        super("Find object by address", MemoryAnalyserPlugin.getImageDescriptor("icons/find.gif"));
    }

    public void run() {
        IEditorPart part;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = part = page == null ? null : page.getActiveEditor();
        if (part instanceof HeapEditor) {
            HeapEditor editor = (HeapEditor)part;
            String value = this.askForAddress();
            if (value != null) {
                this.retrieveObjectAndOpenPane(editor, value);
            }
        }
    }

    private void retrieveObjectAndOpenPane(HeapEditor editor, String value) {
        String errorMessage = null;
        try {
            long objectAddress = new BigInteger(value.substring(2), 16).longValue();
            ISnapshot snapshot = ((ISnapshotEditorInput)editor.getPaneEditorInput()).getSnapshot();
            if (snapshot == null) {
                errorMessage = "Error getting heap dump. Not yet loaded?";
            } else {
                int objectId = snapshot.mapAddressToId(objectAddress);
                if (objectId < 0) {
                    errorMessage = MessageFormat.format("No object with address {0} found.", value);
                } else {
                    QueryExecution.executeCommandLine(editor, null, "list_objects " + value);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            errorMessage = "Address is not a hexadecimal number.";
        }
        catch (SnapshotException e) {
            errorMessage = MessageFormat.format("Error reading object: {0}", e.getMessage());
        }
        if (errorMessage != null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Error opening object", (String)errorMessage);
        }
    }

    private String askForAddress() {
        final Pattern pattern = Pattern.compile("^0x\\p{XDigit}+$");
        InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), "Find object by address", "Object address:", "0x", new IInputValidator(){

            public String isValid(String newText) {
                return !pattern.matcher(newText).matches() ? "Address must be a hex number, e.g. 0x6b93d8" : null;
            }
        });
        int result = dialog.open();
        String value = dialog.getValue();
        if (result == 1) {
            return null;
        }
        return value;
    }
}

