/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.actions;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.ILiveHelpAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.editor.PathEditorInput;
import org.eclipse.mat.ui.snapshot.editor.HeapEditor;
import org.eclipse.mat.ui.snapshot.editor.ISnapshotEditorInput;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;

public class OpenSampleHeapDumpAction
extends Action
implements ICheatSheetAction,
ILiveHelpAction {
    private String heapDumpLocation;

    public void run(String[] params, ICheatSheetManager manager) {
        try {
            String absolutePath = this.getSnapshotPath(params[0]);
            String query = params[1];
            if (query != null && query.equals("oql")) {
                query = String.valueOf(query) + " \"" + params[2] + "\"";
            }
            OpenSampleHeapDumpAction.openEditor(absolutePath, query, params[2]);
        }
        catch (PartInitException e) {
            ErrorHelper.logThrowableAndShowMessage(e);
        }
        catch (IOException e) {
            ErrorHelper.logThrowableAndShowMessage(e);
        }
    }

    private String getSnapshotPath(String snapshotPath) throws IOException {
        int p = snapshotPath.indexOf(47);
        String pluginId = snapshotPath.substring(0, p);
        String path = snapshotPath.substring(p + 1);
        Bundle bundle = Platform.getBundle((String)pluginId);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        String absolutePath = new File(FileLocator.resolve((URL)url).getFile()).getAbsolutePath();
        return absolutePath;
    }

    public static final void openEditor(String snapshotPath, final String editorId, final Object arguments) throws PartInitException {
        IEditorPart editorPart = OpenSampleHeapDumpAction.doOpenEditor(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), snapshotPath);
        if (editorId != null && editorPart instanceof HeapEditor) {
            IEditorInput editorInput = ((HeapEditor)editorPart).getPaneEditorInput();
            if (editorInput instanceof ISnapshotEditorInput && !((ISnapshotEditorInput)editorInput).hasSnapshot()) {
                final ISnapshotEditorInput snapshotInput = (ISnapshotEditorInput)editorInput;
                final MultiPaneEditor finalEditorPart = (MultiPaneEditor)editorPart;
                snapshotInput.addChangeListener(new ISnapshotEditorInput.IChangeListener(){

                    public void onBaselineLoaded(ISnapshot snapshot) {
                    }

                    public void onSnapshotLoaded(ISnapshot snapshot) {
                        finalEditorPart.addNewPage(editorId, arguments);
                        snapshotInput.removeChangeListener(this);
                    }
                });
            } else {
                try {
                    HeapEditor heapEditor = (HeapEditor)editorPart;
                    QueryExecution.executeCommandLine(heapEditor, null, editorId);
                }
                catch (SnapshotException exp) {
                    ErrorHelper.logThrowableAndShowMessage(exp);
                }
            }
        }
    }

    public void run() {
        IWorkbenchWindow window;
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow iWorkbenchWindow = window = wb.getActiveWorkbenchWindow() == null ? wb.getWorkbenchWindows()[0] : wb.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        Display display = window.getShell().getDisplay();
        if (display == null) {
            return;
        }
        display.syncExec(new Runnable(){

            public void run() {
                Shell shell = window.getShell();
                shell.setMinimized(false);
                shell.forceActive();
                try {
                    String absolutePath = OpenSampleHeapDumpAction.this.getSnapshotPath(OpenSampleHeapDumpAction.this.heapDumpLocation);
                    OpenSampleHeapDumpAction.doOpenEditor(window, absolutePath);
                }
                catch (IOException e) {
                    ErrorHelper.logThrowableAndShowMessage(e);
                }
                catch (PartInitException e) {
                    ErrorHelper.logThrowableAndShowMessage(e);
                }
            }
        });
    }

    public void setInitializationString(String data) {
        this.heapDumpLocation = data;
    }

    private static IEditorPart doOpenEditor(IWorkbenchWindow window, String absolutePath) throws PartInitException {
        Path path = new Path(absolutePath);
        IFile[] heapFile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
        if (heapFile != null && heapFile.length > 0) {
            return IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)heapFile[0], (boolean)true);
        }
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(absolutePath);
        if (descriptor != null) {
            return IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IEditorInput)new PathEditorInput((IPath)path), (String)descriptor.getId(), (boolean)true);
        }
        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error opening editor", (String)MessageFormat.format("No editor available to open {0}", absolutePath));
        return null;
    }
}

