/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.actions;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.ui.snapshot.actions.ExportInfo;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

@Name(value="10|Save Value To File")
@Category(value="101|Copy")
@Help(value="Save the value of char[], String, StringBuffer or StringBuilder into a text file.")
@Icon(value="/icons/copy.gif")
public class SaveValueAsQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument
    public List<IContextObject> objects;
    @Argument
    public File file;

    public IResult execute(IProgressListener listener) throws Exception {
        this.checkIfFileExists();
        if (this.objects.size() > 1) {
            this.writeStringData();
        } else if (this.objects.size() == 1) {
            this.writeRawData();
        }
        throw new IProgressListener.OperationCanceledException();
    }

    private void checkIfFileExists() {
        if (this.file.exists()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            final boolean[] goAhead = new boolean[1];
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageBox box = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 192);
                    box.setText("Overwrite?");
                    box.setMessage(MessageFormat.format("File {0} exists. Do you want to overwrite?", SaveValueAsQuery.this.file.getAbsolutePath()));
                    int retValue = box.open();
                    goAhead[0] = retValue == 64;
                }
            });
            if (!goAhead[0]) {
                throw new IProgressListener.OperationCanceledException();
            }
        }
    }

    private void writeStringData() throws Exception {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.file);
            PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)out, System.getProperty("file.encoding"))));
            boolean isFirst = true;
            for (IContextObject object : this.objects) {
                IObject subject;
                ExportInfo info;
                if (object.getObjectId() < 0) continue;
                if (!isFirst) {
                    writer.append('\n');
                }
                if ((info = ExportInfo.of(subject = this.snapshot.getObject(object.getObjectId()))) == null) {
                    String name = subject.getClassSpecificName();
                    writer.append(name != null ? name : subject.getTechnicalName());
                } else {
                    IPrimitiveArray charArray = info.getCharArray();
                    int length = charArray.getLength();
                    int end = info.getOffset() + info.getCount();
                    int offset = info.getOffset();
                    while (offset < end) {
                        int read = Math.min(4092, length - offset);
                        char[] array = (char[])charArray.getValueArray(offset, read);
                        writer.append(new String(array));
                        offset += read;
                    }
                }
                isFirst = false;
            }
            writer.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void writeRawData() throws Exception {
        IContextObject obj = this.objects.get(0);
        if (obj.getObjectId() < 0) {
            return;
        }
        IObject object = this.snapshot.getObject(obj.getObjectId());
        if (!(object instanceof IPrimitiveArray)) {
            this.writeStringData();
            return;
        }
        IPrimitiveArray array = (IPrimitiveArray)object;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.file);
            DataOutputStream writer = new DataOutputStream(new BufferedOutputStream(out));
            int size = array.getLength();
            int offset = 0;
            while (offset < size) {
                int read = Math.min(4092, size - offset);
                Object valueArray = array.getValueArray(offset, read);
                switch (array.getType()) {
                    case 4: {
                        Object[] a = (boolean[])valueArray;
                        int ii = 0;
                        while (ii < a.length) {
                            writer.writeBoolean(a[ii]);
                            ++ii;
                        }
                        break;
                    }
                    case 8: {
                        Object[] a = (byte[])valueArray;
                        writer.write((byte[])a);
                        break;
                    }
                    case 5: {
                        Object[] a = (char[])valueArray;
                        int ii = 0;
                        while (ii < a.length) {
                            writer.writeChar(a[ii]);
                            ++ii;
                        }
                        break;
                    }
                    case 7: {
                        Object[] a = (double[])valueArray;
                        int ii = 0;
                        while (ii < a.length) {
                            writer.writeDouble((double)a[ii]);
                            ++ii;
                        }
                        break;
                    }
                    case 6: {
                        Object[] a = (float[])valueArray;
                        int ii = 0;
                        while (ii < a.length) {
                            writer.writeFloat((float)a[ii]);
                            ++ii;
                        }
                        break;
                    }
                    case 10: {
                        Object[] a = (int[])valueArray;
                        int ii = 0;
                        while (ii < a.length) {
                            writer.writeInt(a[ii]);
                            ++ii;
                        }
                        break;
                    }
                    case 11: {
                        Object[] a = (long[])valueArray;
                        int ii = 0;
                        while (ii < a.length) {
                            writer.writeLong(a[ii]);
                            ++ii;
                        }
                        break;
                    }
                    case 9: {
                        Object[] a = (short[])valueArray;
                        int ii = 0;
                        while (ii < a.length) {
                            writer.writeShort(a[ii]);
                            ++ii;
                        }
                        break;
                    }
                    default: {
                        throw new SnapshotException(MessageFormat.format("Unrecognized primitive array type: {0}", array.getType()));
                    }
                }
                offset += read;
            }
            writer.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

