/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.inspections.DominatorQuery;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.editor.AbstractPaneJob;
import org.eclipse.mat.ui.internal.panes.QueryResultPane;
import org.eclipse.mat.ui.internal.viewer.RefinedResultViewer;
import org.eclipse.mat.ui.util.EasyToolBarDropDown;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

public class DominatorPane
extends QueryResultPane {
    private DominatorQuery.Grouping groupedBy;
    private int[] roots;

    public void initWithArgument(Object argument) {
        try {
            if (argument == null) {
                ISnapshot snapshot = (ISnapshot)this.getQueryContext().get(ISnapshot.class, null);
                DominatorQuery.Tree tree = DominatorQuery.Factory.create((ISnapshot)snapshot, (int[])new int[]{-1}, (IProgressListener)new VoidProgressListener());
                QueryDescriptor query = QueryRegistry.instance().getQuery(DominatorQuery.class);
                argument = new QueryResult(query, query.getName(), (IResult)tree);
                this.groupedBy = tree.getGroupedBy();
                this.roots = tree.getRoots();
            } else {
                QueryResult queryResult = (QueryResult)argument;
                DominatorQuery.Tree tree = (DominatorQuery.Tree)queryResult.getSubject();
                this.groupedBy = tree.getGroupedBy();
                this.roots = tree.getRoots();
            }
            super.initWithArgument(argument);
        }
        catch (SnapshotException e) {
            ErrorHelper.logThrowableAndShowMessage(e);
        }
    }

    public void contributeToToolBar(IToolBarManager manager) {
        this.addGroupingOptions(manager);
        super.contributeToToolBar(manager);
    }

    private void addGroupingOptions(IToolBarManager manager) {
        EasyToolBarDropDown groupingAction = new EasyToolBarDropDown("Group result by...", MemoryAnalyserPlugin.getImageDescriptor("icons/grouping.gif"), this){

            public void contribute(PopupMenu menu) {
                DominatorQuery.Grouping[] groupingArray = DominatorQuery.Grouping.values();
                int n = groupingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DominatorQuery.Grouping group = groupingArray[n2];
                    GroupingAction action = new GroupingAction(group);
                    action.setText(group.toString());
                    action.setImageDescriptor(MemoryAnalyserPlugin.getDefault().getImageDescriptor(group.getIcon()));
                    if (DominatorPane.this.groupedBy == group) {
                        action.setEnabled(false);
                        action.setChecked(true);
                    }
                    menu.add(action);
                    ++n2;
                }
            }
        };
        manager.add((IAction)groupingAction);
    }

    private class GroupingAction
    extends Action {
        private DominatorQuery.Grouping target;

        public GroupingAction(DominatorQuery.Grouping group) {
            super("Group", 2);
            this.target = group;
        }

        public void run() {
            if (!this.isChecked()) {
                return;
            }
            if (DominatorPane.this.viewer.getResult().hasActiveFilter()) {
                StringBuilder buf = new StringBuilder();
                buf.append("The original table is filtered. The WHOLE tree will be grouped.");
                MessageBox msg = new MessageBox(DominatorPane.this.viewer.getControl().getShell(), 288);
                msg.setText("Info");
                msg.setMessage(buf.toString());
                if (msg.open() != 32) {
                    return;
                }
            }
            AbstractPaneJob job = new AbstractPaneJob(this.getText(), DominatorPane.this){

                protected IStatus doRun(IProgressMonitor monitor) {
                    try {
                        DominatorQuery.Tree tree = null;
                        ProgressMonitorWrapper listener = new ProgressMonitorWrapper(monitor);
                        ISnapshot snapshot = (ISnapshot)DominatorPane.this.getQueryContext().get(ISnapshot.class, null);
                        switch (GroupingAction.this.target) {
                            case NONE: {
                                tree = DominatorQuery.Factory.create((ISnapshot)snapshot, (int[])DominatorPane.this.roots, (IProgressListener)listener);
                                break;
                            }
                            case BY_CLASS: {
                                tree = DominatorQuery.Factory.groupByClass((ISnapshot)snapshot, (int[])DominatorPane.this.roots, (IProgressListener)listener);
                                break;
                            }
                            case BY_CLASSLOADER: {
                                tree = DominatorQuery.Factory.groupByClassLoader((ISnapshot)snapshot, (int[])DominatorPane.this.roots, (IProgressListener)listener);
                                break;
                            }
                            case BY_PACKAGE: {
                                tree = DominatorQuery.Factory.groupByPackage((ISnapshot)snapshot, (int[])DominatorPane.this.roots, (IProgressListener)listener);
                            }
                        }
                        final QueryResult queryResult = new QueryResult(null, "dominator_tree -groupBy " + GroupingAction.this.target.name(), (IResult)tree);
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                DominatorPane.this.deactivateViewer();
                                DominatorPane.this.groupedBy = GroupingAction.this.target;
                                RefinedResultViewer v = DominatorPane.this.createViewer(queryResult);
                                DominatorPane.this.activateViewer(v);
                            }
                        });
                        return Status.OK_STATUS;
                    }
                    catch (SnapshotException e) {
                        return ErrorHelper.createErrorStatus(e);
                    }
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }
}

