/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.snapshot.query.HistogramResult;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.editor.MultiPaneEditorSite;
import org.eclipse.mat.ui.internal.panes.QueryResultPane;
import org.eclipse.mat.ui.internal.viewer.RefinedResultViewer;
import org.eclipse.mat.ui.snapshot.ParseHeapDumpJob;
import org.eclipse.mat.ui.snapshot.editor.ISnapshotEditorInput;
import org.eclipse.mat.ui.util.EasyToolBarDropDown;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.ide.ResourceUtil;

public class HistogramPane
extends QueryResultPane {
    private Histogram histogram;
    private Grouping groupedBy;
    private Action deltaAction;

    public String getTitle() {
        if (this.histogram != null && this.histogram.getLabel() != null) {
            return this.histogram.getLabel();
        }
        return super.getTitle();
    }

    protected void makeActions() {
        super.makeActions();
        this.deltaAction = new DeltaAction();
    }

    public void initWithArgument(Object argument) {
        if (argument == null) {
            try {
                QueryDescriptor histogram = QueryRegistry.instance().getQuery("histogram");
                argument = histogram.createNewArgumentSet(this.getEditor().getQueryContext()).execute((IProgressListener)new VoidProgressListener());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (argument instanceof QueryResult && ((QueryResult)argument).getSubject() instanceof HistogramResult) {
            QueryResult previous = (QueryResult)argument;
            argument = new QueryResult(previous.getQuery(), previous.getCommand(), (IResult)((HistogramResult)previous.getSubject()).getHistogram());
        }
        super.initWithArgument(argument);
        IResult subject = ((QueryResult)argument).getSubject();
        if (subject instanceof Histogram) {
            this.groupedBy = Grouping.BY_CLASS;
        } else if (subject instanceof Histogram.ClassLoaderTree) {
            this.groupedBy = Grouping.BY_CLASSLOADER;
        } else if (subject instanceof Histogram.PackageTree) {
            this.groupedBy = Grouping.BY_PACKAGE;
        }
        this.histogram = this.unwrapHistogram(subject);
        this.firePropertyChange(1);
        if (this.histogram.isDefaultHistogram()) {
            this.viewer.showDerivedDataColumn(this.viewer.getQueryResult().getDefaultContextProvider(), RetainedSizeDerivedData.APPROXIMATE);
        }
    }

    private Histogram unwrapHistogram(IResult subject) {
        if (subject instanceof Histogram) {
            return (Histogram)subject;
        }
        if (subject instanceof Histogram.ClassLoaderTree) {
            return ((Histogram.ClassLoaderTree)subject).getHistogram();
        }
        if (subject instanceof Histogram.PackageTree) {
            return ((Histogram.PackageTree)subject).getHistogram();
        }
        throw new RuntimeException(MessageFormat.format("Illegal type for HistogramPane: {0}", subject.getClass().getName()));
    }

    public void contributeToToolBar(IToolBarManager manager) {
        this.addGroupingOptions(manager);
        super.contributeToToolBar(manager);
        manager.add((IContributionItem)new Separator());
        if (this.histogram.isDefaultHistogram()) {
            manager.add((IAction)this.deltaAction);
        }
    }

    private void addGroupingOptions(IToolBarManager manager) {
        EasyToolBarDropDown groupingAction = new EasyToolBarDropDown("Group result by...", MemoryAnalyserPlugin.getImageDescriptor("icons/grouping.gif"), this){

            public void contribute(PopupMenu menu) {
                Grouping[] groupingArray = Grouping.values();
                int n = groupingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Grouping g = groupingArray[n2];
                    GroupingAction action = new GroupingAction(g);
                    action.setEnabled(g != HistogramPane.this.groupedBy);
                    action.setChecked(g == HistogramPane.this.groupedBy);
                    menu.add(action);
                    ++n2;
                }
            }
        };
        manager.add((IAction)groupingAction);
    }

    private void updateDeltaHistogram() {
        Job job = new Job("Calculating intersecting histograms"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Histogram baseline = ((ISnapshotEditorInput)HistogramPane.this.getEditorInput()).getBaseline().getHistogram((IProgressListener)new ProgressMonitorWrapper(monitor));
                    if (baseline == null) {
                        HistogramPane.this.deltaAction.setChecked(false);
                        return Status.CANCEL_STATUS;
                    }
                    final Histogram delta = HistogramPane.this.histogram.diffWithBaseline(baseline);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            QueryResult qr;
                            HistogramPane.this.deactivateViewer();
                            switch (HistogramPane.this.groupedBy) {
                                case BY_CLASS: {
                                    qr = new QueryResult(null, "[diff]", (IResult)delta);
                                    break;
                                }
                                case BY_CLASSLOADER: {
                                    qr = new QueryResult(null, "[diff]", (IResult)delta.groupByClassLoader());
                                    break;
                                }
                                case BY_PACKAGE: {
                                    qr = new QueryResult(null, "[diff]", (IResult)delta.groupByPackage());
                                    break;
                                }
                                default: {
                                    throw new RuntimeException(MessageFormat.format("Illegal type for HistogramPane: {0}", new Object[]{HistogramPane.this.groupedBy}));
                                }
                            }
                            RefinedResultViewer v = HistogramPane.this.createViewer(qr);
                            HistogramPane.this.activateViewer(v);
                        }
                    });
                }
                catch (SnapshotException e) {
                    HistogramPane.this.deltaAction.setChecked(false);
                    return ErrorHelper.createErrorStatus(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private class DeltaAction
    extends Action {
        private DeltaAction() {
            super("Compare to another Heap Dump", 2);
            this.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/compare.gif"));
        }

        public void run() {
            if (this.isChecked()) {
                ISnapshotEditorInput snapshotInput = (ISnapshotEditorInput)HistogramPane.this.getEditorInput();
                if (!snapshotInput.hasBaseline()) {
                    this.selectBaseline();
                } else {
                    ISnapshot baseline = snapshotInput.getBaseline();
                    MessageBox box = new MessageBox(HistogramPane.this.getSite().getShell(), 288);
                    box.setText("Select Baseline");
                    box.setMessage(MessageFormat.format("Compare against ''{0}''?", baseline.getSnapshotInfo().getPath()));
                    if (box.open() == 32) {
                        HistogramPane.this.updateDeltaHistogram();
                    } else {
                        this.selectBaseline();
                    }
                }
            } else {
                Histogram result;
                HistogramPane.this.deactivateViewer();
                switch (HistogramPane.this.groupedBy) {
                    case BY_CLASS: {
                        result = HistogramPane.this.histogram;
                        break;
                    }
                    case BY_CLASSLOADER: {
                        result = HistogramPane.this.histogram.groupByClassLoader();
                        break;
                    }
                    case BY_PACKAGE: {
                        result = HistogramPane.this.histogram.groupByPackage();
                        break;
                    }
                    default: {
                        throw new RuntimeException(MessageFormat.format("Illegal type for HistogramPane: {0}", new Object[]{HistogramPane.this.groupedBy}));
                    }
                }
                QueryResult qr = new QueryResult(QueryRegistry.instance().getQuery("histogram"), "histogram -groupBy " + HistogramPane.this.groupedBy.name(), (IResult)result);
                HistogramPane.this.activateViewer(HistogramPane.this.createViewer(qr));
            }
        }

        private void selectBaseline() {
            IPath selected = this.askForFilename();
            if (selected != null) {
                new ParseHeapDumpJob(selected){

                    protected void finished(ISnapshot snapshot) {
                        ISnapshot previous;
                        ISnapshotEditorInput snapshotInput = (ISnapshotEditorInput)HistogramPane.this.getEditorInput();
                        if (snapshotInput.hasBaseline() && (previous = snapshotInput.getBaseline()) != snapshot) {
                            SnapshotFactory.dispose((ISnapshot)previous);
                        }
                        snapshotInput.setBaseline(snapshot);
                        HistogramPane.this.updateDeltaHistogram();
                    }
                }.schedule();
            } else {
                this.setChecked(false);
            }
        }

        IPath askForFilename() {
            ArrayList<IPath> resources = new ArrayList<IPath>();
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                IWorkbenchWindow window = windows[i];
                IWorkbenchPage[] pages = window.getPages();
                int j = 0;
                while (j < pages.length) {
                    IWorkbenchPage page = pages[j];
                    IEditorReference[] editors = page.getEditorReferences();
                    int k = 0;
                    while (k < editors.length) {
                        try {
                            IEditorInput input;
                            IEditorReference editor = editors[k];
                            IEditorPart e = editor.getEditor(true);
                            if (e instanceof MultiPaneEditor && e != ((MultiPaneEditorSite)HistogramPane.this.getSite()).getMultiPageEditor() && (input = editor.getEditorInput()) != null) {
                                IFile file = ResourceUtil.getFile((IEditorInput)input);
                                if (file != null) {
                                    resources.add(file.getLocation());
                                } else if (input instanceof IPathEditorInput) {
                                    resources.add(((IPathEditorInput)input).getPath());
                                }
                            }
                        }
                        catch (PartInitException partInitException) {}
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            if (resources.isEmpty()) {
                MessageDialog.openInformation((Shell)HistogramPane.this.getSite().getShell(), (String)"Select baseline", (String)"No other heap dump opened in editor.");
                return null;
            }
            ListDialog dialog = new ListDialog(HistogramPane.this.getSite().getShell());
            dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    return MemoryAnalyserPlugin.getImage("icons/heapobjects/heapdump16.gif");
                }

                public String getText(Object element) {
                    IPath path = (IPath)element;
                    return String.valueOf(path.lastSegment()) + " (" + path.toOSString() + ")";
                }
            });
            dialog.setContentProvider(new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return ((List)inputElement).toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            dialog.setInput(resources);
            dialog.setTitle("Select baseline");
            dialog.setMessage("Select a heap dump from the open editors as baseline");
            dialog.open();
            Object[] result = dialog.getResult();
            return result == null ? null : (IPath)result[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Grouping {
        BY_CLASS("Group by class", Icons.CLASS),
        BY_CLASSLOADER("Group by class loader", Icons.CLASSLOADER_INSTANCE),
        BY_PACKAGE("Group by package", Icons.PACKAGE);

        String label;
        URL icon;

        private Grouping(String label, URL icon) {
            this.label = label;
            this.icon = icon;
        }

        public URL getIcon() {
            return this.icon;
        }

        public String toString() {
            return this.label;
        }
    }

    private class GroupingAction
    extends Action {
        private Grouping groupBy;

        public GroupingAction(Grouping groupBy) {
            super(groupBy.toString(), 2);
            this.groupBy = groupBy;
            this.setImageDescriptor(MemoryAnalyserPlugin.getDefault().getImageDescriptor(groupBy.getIcon()));
        }

        public void run() {
            if (!this.isChecked()) {
                return;
            }
            if (HistogramPane.this.viewer.getResult().hasActiveFilter()) {
                StringBuilder buf = new StringBuilder();
                buf.append("The original table is filtered. The WHOLE tree will be grouped.");
                MessageBox msg = new MessageBox(HistogramPane.this.viewer.getControl().getShell(), 288);
                msg.setText("Info");
                msg.setMessage(buf.toString());
                if (msg.open() != 32) {
                    return;
                }
            }
            final Histogram current = HistogramPane.this.unwrapHistogram((IResult)HistogramPane.this.viewer.getResult().unwrap());
            new Job(this.getText()){

                protected IStatus run(IProgressMonitor monitor) {
                    Histogram result;
                    switch (GroupingAction.this.groupBy) {
                        case BY_CLASS: {
                            result = current;
                            break;
                        }
                        case BY_CLASSLOADER: {
                            result = current.groupByClassLoader();
                            break;
                        }
                        case BY_PACKAGE: {
                            result = current.groupByPackage();
                            break;
                        }
                        default: {
                            throw new RuntimeException(MessageFormat.format("Illegal type for HistogramPane: {0}", new Object[]{GroupingAction.this.groupBy}));
                        }
                    }
                    final boolean isDeltaHistogram = current != HistogramPane.this.histogram;
                    final QueryResult queryResult = isDeltaHistogram ? new QueryResult(null, "[diff]", (IResult)result) : new QueryResult(QueryRegistry.instance().getQuery("histogram"), "histogram -groupBy " + GroupingAction.this.groupBy.name(), (IResult)result);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            HistogramPane.this.deactivateViewer();
                            HistogramPane.this.groupedBy = GroupingAction.this.groupBy;
                            RefinedResultViewer v = HistogramPane.this.createViewer(queryResult);
                            HistogramPane.this.activateViewer(v);
                            if (!isDeltaHistogram && HistogramPane.this.histogram.isDefaultHistogram()) {
                                v.showDerivedDataColumn(v.getQueryResult().getDefaultContextProvider(), RetainedSizeDerivedData.APPROXIMATE);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }
}

