/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.inspections.Path2GCRootsQuery;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.AbstractPaneJob;
import org.eclipse.mat.ui.internal.panes.QueryResultPane;
import org.eclipse.mat.ui.internal.viewer.RefinedTreeViewer;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class Path2GCRootsPane
extends QueryResultPane {
    private Button nextPathButton;
    private Label statusLabel;

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 128);
        GridLayout ly = new GridLayout(3, false);
        ly.verticalSpacing = 0;
        ly.marginWidth = 0;
        ly.marginHeight = 0;
        composite.setLayout((Layout)ly);
        Label label = new Label(composite, 0);
        label.setText("Status:");
        GridDataFactory.fillDefaults().grab(false, false).indent(5, 3).applyTo((Control)label);
        this.statusLabel = new Label(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).indent(5, 3).applyTo((Control)this.statusLabel);
        this.nextPathButton = new Button(composite, 0);
        this.nextPathButton.setText("Fetch Next Paths");
        this.nextPathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (Path2GCRootsPane.this.viewer == null || Path2GCRootsPane.this.viewer.getControl().isDisposed()) {
                    return;
                }
                Path2GCRootsQuery.Tree tree = (Path2GCRootsQuery.Tree)Path2GCRootsPane.this.viewer.getResult().unwrap();
                new ReadNextPathJob(Path2GCRootsPane.this, tree, 30).schedule();
            }
        });
        Composite viewerArea = new Composite(composite, 128);
        viewerArea.setLayout((Layout)new FillLayout());
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).minSize(100, 100).applyTo((Control)viewerArea);
        super.createPartControl(viewerArea);
    }

    public void initWithArgument(Object argument) {
        super.initWithArgument(argument);
        this.updateStatusLabel();
    }

    private void updateStatusLabel() {
        Path2GCRootsQuery.Tree tree = (Path2GCRootsQuery.Tree)this.viewer.getResult().unwrap();
        String message = tree.morePathsAvailable() ? "Found {0} paths so far." : "Found {0} paths. No more paths left.";
        String formatted = MessageFormat.format(message, tree.getNumberOfPaths());
        this.statusLabel.setText(formatted);
    }

    private class ReadNextPathJob
    extends AbstractPaneJob
    implements ISchedulingRule {
        private Path2GCRootsQuery.Tree tree;
        private int noToFetch;

        public ReadNextPathJob(AbstractEditorPane pane, Path2GCRootsQuery.Tree root, int noToFetch) {
            super("Reading Next Paths", pane);
            this.tree = root;
            this.noToFetch = noToFetch;
            this.setUser(true);
            this.setRule(this);
        }

        protected IStatus doRun(IProgressMonitor monitor) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Path2GCRootsPane.this.nextPathButton.setEnabled(false);
                }
            });
            monitor.beginTask("Fetching next paths...", this.noToFetch);
            try {
                try {
                    int count = 0;
                    while (count < this.noToFetch && this.tree.morePathsAvailable()) {
                        final List ancestors = this.tree.addNextPath();
                        if (ancestors != null) {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    ((RefinedTreeViewer)Path2GCRootsPane.this.viewer).refresh(ancestors);
                                    Path2GCRootsPane.this.updateStatusLabel();
                                    Path2GCRootsPane.this.viewer.getControl().setFocus();
                                }
                            });
                        }
                        if (!monitor.isCanceled()) {
                            ++count;
                            continue;
                        }
                        break;
                    }
                }
                catch (SnapshotException e) {
                    IStatus iStatus = ErrorHelper.createErrorStatus(e);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (ReadNextPathJob.this.tree.morePathsAvailable()) {
                                Path2GCRootsPane.this.nextPathButton.setEnabled(true);
                            }
                        }
                    });
                    return iStatus;
                }
            }
            catch (Throwable throwable) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
            return Status.OK_STATUS;
        }

        public boolean contains(ISchedulingRule rule) {
            return this.isConflicting(rule);
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof ReadNextPathJob && ((ReadNextPathJob)rule).belongsTo(this.getPane());
        }
    }
}

