/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.views.inspector;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mat.ui.snapshot.views.inspector.LazyFields;

public class FieldsContentProvider
implements IStructuredContentProvider,
IDoubleClickListener {
    private Viewer viewer;
    private int limit;
    private LazyFields<?> fields;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fields = (LazyFields)newInput;
        this.limit = 25;
        this.viewer = viewer;
        if (this.viewer instanceof StructuredViewer) {
            ((StructuredViewer)this.viewer).addDoubleClickListener((IDoubleClickListener)this);
        }
    }

    public Object[] getElements(Object inputElement) {
        boolean isAll = this.fields.getSize() <= this.limit;
        Object[] result = new Object[(isAll ? 0 : 1) + Math.min(this.fields.getSize(), this.limit)];
        List<?> elements = this.fields.getElements(this.limit);
        int index = 0;
        while (index < result.length && index < elements.size()) {
            result[index] = elements.get(index);
            ++index;
        }
        if (!isAll) {
            result[result.length - 1] = new MoreNode(this.limit, this.fields.getSize());
        }
        return result;
    }

    public void dispose() {
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!(selection.getFirstElement() instanceof MoreNode)) {
            return;
        }
        this.limit += 25;
        this.viewer.refresh();
    }

    static class MoreNode {
        int size;
        int limit;

        MoreNode(int limit, int size) {
            this.size = size;
            this.limit = limit;
        }

        public String toString() {
            return MessageFormat.format("{0} out of {1} displayed", this.limit, this.size);
        }
    }
}

