/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.views.inspector;

import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.snapshot.views.inspector.FieldNode;
import org.eclipse.mat.ui.snapshot.views.inspector.FieldsContentProvider;
import org.eclipse.mat.ui.snapshot.views.inspector.InspectorView;
import org.eclipse.mat.ui.snapshot.views.inspector.NamedReferenceNode;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

class FieldsLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableFontProvider {
    private final InspectorView inspectorView;
    private Font italicFont;

    public FieldsLabelProvider(InspectorView inspectorView, Font defaultFont) {
        FontData[] fontData;
        this.inspectorView = inspectorView;
        FontData[] fontDataArray = fontData = defaultFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setStyle(2);
            ++n2;
        }
        this.italicFont = new Font(null, fontData);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 2) {
            return null;
        }
        if (element instanceof FieldsContentProvider.MoreNode) {
            return MemoryAnalyserPlugin.getImage("icons/plus.gif");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof FieldsContentProvider.MoreNode) {
            switch (columnIndex) {
                case 2: {
                    return ((FieldsContentProvider.MoreNode)element).toString();
                }
            }
        } else if (element instanceof FieldNode) {
            Field field = ((FieldNode)element).getField();
            switch (columnIndex) {
                case 0: {
                    return field.getVerboseSignature();
                }
                case 1: {
                    return field.getName();
                }
                case 2: {
                    return String.valueOf(field.getValue());
                }
            }
        } else if (element instanceof NamedReferenceNode) {
            NamedReferenceNode node = (NamedReferenceNode)element;
            switch (columnIndex) {
                case 0: {
                    return "ref";
                }
                case 1: {
                    return node.getName();
                }
                case 2: {
                    return this.getObjectLabel(node.getObjectAddress());
                }
            }
        }
        return null;
    }

    private String getObjectLabel(long objectAddress) {
        try {
            IObject object = this.inspectorView.snapshot.getObject(this.inspectorView.snapshot.mapAddressToId(objectAddress));
            String text = object.getClassSpecificName();
            if (text == null) {
                text = object.getTechnicalName();
            }
            return text;
        }
        catch (SnapshotException snapshotException) {
            return "0x" + Long.toHexString(objectAddress);
        }
    }

    public Font getFont(Object element, int columnIndex) {
        if (element instanceof NamedReferenceNode && ((NamedReferenceNode)element).isStatic() || element instanceof FieldNode && ((FieldNode)element).isStatic()) {
            return this.italicFont;
        }
        return null;
    }

    public void dispose() {
        this.italicFont.dispose();
    }
}

