/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.views.inspector;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.snapshot.ImageHelper;
import org.eclipse.mat.ui.snapshot.editor.HeapEditor;
import org.eclipse.mat.ui.snapshot.editor.ISnapshotEditorInput;
import org.eclipse.mat.ui.snapshot.views.inspector.FieldsContentProvider;
import org.eclipse.mat.ui.snapshot.views.inspector.FieldsLabelProvider;
import org.eclipse.mat.ui.snapshot.views.inspector.InspectorContextProvider;
import org.eclipse.mat.ui.snapshot.views.inspector.LazyFields;
import org.eclipse.mat.ui.util.Copy;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.ui.util.QueryContextMenu;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class InspectorView
extends ViewPart
implements IPartListener,
ISelectionChangedListener {
    private HeapEditor editor;
    ISnapshot snapshot;
    private Composite top;
    private TableViewer topTableViewer;
    private CTabFolder tabFolder;
    private TableViewer attributesTable;
    private TableViewer staticsTable;
    private TreeViewer classHierarchyTree;
    private boolean pinSelection = false;
    private Font font;
    private List<Menu> contextMenus = new ArrayList<Menu>();
    boolean keepInSync = true;

    public void createPartControl(Composite parent) {
        FontData[] data;
        this.top = new Composite(parent, 128);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(1, 1).applyTo(this.top);
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.createSyncAction());
        FontData[] fontDataArray = data = JFaceResources.getDefaultFont().getFontData();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            fontData.setStyle(1);
            ++n2;
        }
        this.font = new Font((Device)this.top.getDisplay(), data);
        this.createTopTable(this.top);
        this.createTabFolder(this.top);
        this.getSite().getPage().addPartListener((IPartListener)this);
        this.hookContextMenu();
        this.showBootstrapPart();
    }

    private Action createSyncAction() {
        Action syncAction = new Action(null, 2){

            public void run() {
                if (!InspectorView.this.keepInSync) {
                    InspectorView.this.showBootstrapPart();
                    if (InspectorView.this.editor != null) {
                        InspectorView.this.updateOnSelection(InspectorView.this.editor.getSelection());
                    }
                    InspectorView.this.keepInSync = true;
                } else {
                    InspectorView.this.keepInSync = false;
                }
                this.setChecked(!InspectorView.this.keepInSync);
            }
        };
        syncAction.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/synced.gif"));
        syncAction.setToolTipText("Link with Snapshot");
        return syncAction;
    }

    private void createTopTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.topTableViewer = new TableViewer(composite, 65536);
        Table table = this.topTableViewer.getTable();
        TableColumnLayout columnLayout = new TableColumnLayout();
        composite.setLayout((Layout)columnLayout);
        TableColumn column = new TableColumn(table, 16384);
        columnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(100, 10));
        int itemHeight = table.getItemHeight() + 1;
        if (itemHeight < 17) {
            itemHeight = 17;
        }
        int scrollbarHeight = 2;
        if (!"win32".equals(Platform.getOS())) {
            scrollbarHeight = table.getHorizontalBar().getSize().y;
        }
        int detailsHeight = 9 * itemHeight + scrollbarHeight;
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        this.topTableViewer.setLabelProvider((IBaseLabelProvider)new TopTableLabelProvider());
        this.topTableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        GridDataFactory.fillDefaults().hint(-1, detailsHeight).grab(true, false).applyTo((Control)composite);
    }

    private void createTabFolder(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 0x800080);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.tabFolder);
        ToolBar toolBar = new ToolBar((Composite)this.tabFolder, 0x800100);
        this.tabFolder.setTopRight((Control)toolBar);
        this.tabFolder.setTabHeight(Math.max(toolBar.computeSize((int)-1, (int)-1).y, this.tabFolder.getTabHeight()));
        final ToolItem pinItem = new ToolItem(toolBar, 32);
        pinItem.setImage(MemoryAnalyserPlugin.getImage("icons/pinned.gif"));
        pinItem.setToolTipText("Pin Tab");
        pinItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InspectorView.this.pinSelection = !InspectorView.this.pinSelection;
                pinItem.setSelection(InspectorView.this.pinSelection);
            }
        });
        toolBar.pack();
        CTabItem staticsTab = new CTabItem(this.tabFolder, 0);
        staticsTab.setText("Statics");
        this.staticsTable = this.createTable((Composite)this.tabFolder);
        staticsTab.setControl((Control)this.staticsTable.getTable().getParent());
        CTabItem instancesTab = new CTabItem(this.tabFolder, 0);
        instancesTab.setText("Attributes");
        this.attributesTable = this.createTable((Composite)this.tabFolder);
        instancesTab.setControl((Control)this.attributesTable.getTable().getParent());
        CTabItem classHierarchyTab = new CTabItem(this.tabFolder, 0);
        classHierarchyTab.setText("Class Hierarchy");
        this.classHierarchyTree = this.createHierarchyTree(this.tabFolder);
        classHierarchyTab.setControl((Control)this.classHierarchyTree.getTree().getParent());
        this.tabFolder.setSelection(0);
    }

    private TreeViewer createHierarchyTree(CTabFolder parent) {
        Composite composite = new Composite((Composite)parent, 0);
        TreeViewer classHierarchyTree = new TreeViewer(composite, 65536);
        classHierarchyTree.setContentProvider((IContentProvider)new HierarchyTreeContentProvider());
        classHierarchyTree.setLabelProvider((IBaseLabelProvider)new HierarchyLabelProvider(-1));
        Tree tree = classHierarchyTree.getTree();
        TreeColumnLayout columnLayout = new TreeColumnLayout();
        composite.setLayout((Layout)columnLayout);
        TreeColumn column = new TreeColumn(tree, 16384);
        columnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(100, 10));
        return classHierarchyTree;
    }

    private TableViewer createTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        TableColumnLayout columnLayout = new TableColumnLayout();
        composite.setLayout((Layout)columnLayout);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
        final TableViewer viewer = new TableViewer(composite, 66304);
        Table table = viewer.getTable();
        viewer.setContentProvider((IContentProvider)new FieldsContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new FieldsLabelProvider(this, table.getFont()));
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action(){

            public void run() {
                Copy.copyToClipboard(viewer.getControl());
            }
        });
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText("Type");
        tableColumn.setWidth(50);
        columnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(10, 50, false));
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setWidth(80);
        tableColumn.setText("Name");
        columnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(30, 80));
        tableColumn = new TableColumn(table, 16384);
        tableColumn.setWidth(250);
        tableColumn.setText("Value");
        columnLayout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(60, 250, true));
        table.setHeaderVisible(true);
        return viewer;
    }

    private void hookContextMenu() {
        this.createMenu((StructuredViewer)this.staticsTable);
        this.createMenu((StructuredViewer)this.attributesTable);
        this.createMenu((StructuredViewer)this.topTableViewer);
        this.createMenu((StructuredViewer)this.classHierarchyTree);
    }

    private void createMenu(StructuredViewer viewer) {
        Menu menu = new Menu(viewer.getControl());
        menu.addMenuListener((org.eclipse.swt.events.MenuListener)new MenuListener(menu, viewer));
        viewer.getControl().setMenu(menu);
        this.contextMenus.add(menu);
    }

    private void fillContextMenu(PopupMenu manager, StructuredViewer viewer) {
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (this.editor != null) {
            boolean isObject;
            InspectorContextProvider contextProvider = new InspectorContextProvider(this.snapshot);
            final IContextObject firstElement = contextProvider.getContext(selection.getFirstElement());
            IStructuredSelection editorSelection = (IStructuredSelection)this.editor.getSelection();
            Object editorElement = editorSelection.getFirstElement();
            boolean bl = isObject = firstElement instanceof IContextObject && editorElement instanceof IContextObject && firstElement.getObjectId() != ((IContextObject)editorElement).getObjectId();
            if (isObject) {
                manager.add(new Action("Go Into"){

                    public void run() {
                        InspectorView.this.updateOnSelection((ISelection)new StructuredSelection(firstElement));
                    }
                });
                manager.addSeparator();
            }
            QueryContextMenu contextMenu = new QueryContextMenu((MultiPaneEditor)this.editor, (ContextProvider)contextProvider);
            contextMenu.addContextActions(manager, selection);
        }
    }

    private void showBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            this.partActivated((IWorkbenchPart)page.getActiveEditor());
        }
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof HeapEditor;
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.removeSelectionChangedListener(this);
            this.editor = null;
        }
        for (Menu menu : this.contextMenus) {
            if (menu == null || menu.isDisposed()) continue;
            menu.dispose();
            Object var1_2 = null;
        }
        if (this.font != null) {
            this.font.dispose();
        }
        this.getSite().getPage().removePartListener((IPartListener)this);
        super.dispose();
    }

    public void setFocus() {
        this.tabFolder.getSelection().getControl().setFocus();
    }

    public void partActivated(IWorkbenchPart part) {
        if (!this.isImportant(part)) {
            return;
        }
        if (!this.keepInSync) {
            return;
        }
        HeapEditor heapEditor = (HeapEditor)part;
        if (this.editor != heapEditor) {
            if (this.editor != null) {
                this.editor.removeSelectionChangedListener(this);
            }
            this.editor = heapEditor;
            final ISnapshotEditorInput input = heapEditor.getSnapshotInput();
            if (input.hasSnapshot()) {
                this.snapshot = input.getSnapshot();
            } else {
                this.snapshot = null;
                input.addChangeListener(new ISnapshotEditorInput.IChangeListener(){

                    public void onBaselineLoaded(ISnapshot snapshot) {
                    }

                    public void onSnapshotLoaded(ISnapshot snapshot) {
                        if (InspectorView.this.snapshot == null) {
                            InspectorView.this.snapshot = snapshot;
                        }
                        input.removeChangeListener(this);
                    }
                });
            }
            this.editor.addSelectionChangedListener(this);
            this.updateOnSelection(this.editor.getSelection());
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.partActivated(part);
    }

    public void partClosed(IWorkbenchPart part) {
        if (!this.isImportant(part)) {
            return;
        }
        HeapEditor heapEditor = (HeapEditor)part;
        if (this.editor == heapEditor) {
            this.editor.removeSelectionChangedListener(this);
            this.clearInput();
            this.snapshot = null;
            this.editor = null;
            if (!this.keepInSync) {
                this.keepInSync = true;
                this.showBootstrapPart();
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.keepInSync) {
            ISelection selection = event.getSelection();
            this.updateOnSelection(selection);
        }
    }

    private void updateOnSelection(ISelection selection) {
        Object object;
        IContextObject objectSet = null;
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IContextObject) {
            objectSet = (IContextObject)object;
        }
        if (objectSet == null || objectSet.getObjectId() < 0) {
            this.clearInput();
        } else {
            int current;
            final int objectId = objectSet.getObjectId();
            Object data = this.topTableViewer.getData("input");
            if (data != null && (current = ((Integer)data).intValue()) == objectId) {
                return;
            }
            Job job = new Job("Update Object Details"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (InspectorView.this.snapshot == null) {
                            return Status.OK_STATUS;
                        }
                        final IObject object = InspectorView.this.snapshot.getObject(objectId);
                        final List<Object> classInfos = this.prepareClassInfo(object);
                        final LazyFields<?> staticFields = this.prepareStaticFields(object);
                        final LazyFields<?> attributeFields = this.prepareAttributes(object);
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                int selectionIndex;
                                InspectorView.this.topTableViewer.setInput((Object)classInfos);
                                InspectorView.this.topTableViewer.setData("input", (Object)objectId);
                                InspectorView.this.staticsTable.setInput((Object)staticFields);
                                InspectorView.this.attributesTable.setInput((Object)attributeFields);
                                IClass input = object instanceof IClass ? (IClass)object : object.getClazz();
                                try {
                                    InspectorView.this.classHierarchyTree.getTree().setRedraw(false);
                                    InspectorView.this.classHierarchyTree.setInput(null);
                                    InspectorView.this.classHierarchyTree.setLabelProvider((IBaseLabelProvider)new HierarchyLabelProvider(input.getObjectId()));
                                    InspectorView.this.classHierarchyTree.setInput((Object)new IClass[]{input});
                                    InspectorView.this.classHierarchyTree.expandAll();
                                }
                                finally {
                                    InspectorView.this.classHierarchyTree.getTree().setRedraw(true);
                                }
                                if (!InspectorView.this.pinSelection && (selectionIndex = InspectorView.this.tabFolder.getSelectionIndex()) <= 1) {
                                    int newSelectionIndex;
                                    int n = newSelectionIndex = object instanceof IClass ? 0 : 1;
                                    if (selectionIndex != newSelectionIndex) {
                                        InspectorView.this.tabFolder.setSelection(newSelectionIndex);
                                    }
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                    catch (SnapshotException e) {
                        return new Status(4, "org.eclipse.mat.ui", "Error updating Inspector", (Throwable)e);
                    }
                }

                private LazyFields<?> prepareAttributes(IObject object) {
                    LazyFields fields = null;
                    fields = object instanceof IInstance ? new LazyFields.Instance((IInstance)object) : (object instanceof IPrimitiveArray ? new LazyFields.PrimitiveArray((IPrimitiveArray)object) : (object instanceof IObjectArray ? new LazyFields.ObjectArray((IObjectArray)object) : LazyFields.EMPTY));
                    return fields;
                }

                private LazyFields<?> prepareStaticFields(IObject object) {
                    LazyFields.Class fields = null;
                    fields = object instanceof IClass ? new LazyFields.Class((IClass)object) : (object instanceof IInstance ? new LazyFields.Class(object.getClazz()) : LazyFields.EMPTY);
                    return fields;
                }

                private List<Object> prepareClassInfo(IObject object) throws SnapshotException {
                    IClass superClass;
                    ArrayList<Object> details = new ArrayList<Object>();
                    details.add(new InfoItem(object.getObjectId(), MemoryAnalyserPlugin.getImageDescriptor("icons/id.gif"), "0x" + Long.toHexString(object.getObjectAddress())));
                    String className = object instanceof IClass ? ((IClass)object).getName() : object.getClazz().getName();
                    int p = className.lastIndexOf(46);
                    if (p < 0) {
                        InfoItem item = new InfoItem(object.getObjectId(), ImageHelper.getImageDescriptor(ImageHelper.getType(object)), className);
                        details.add(item);
                        details.add(new InfoItem(MemoryAnalyserPlugin.getImageDescriptor("icons/package.gif"), ""));
                    } else {
                        details.add(new InfoItem(object.getObjectId(), ImageHelper.getImageDescriptor(ImageHelper.getType(object)), className.substring(p + 1)));
                        details.add(new InfoItem(MemoryAnalyserPlugin.getImageDescriptor("icons/package.gif"), className.substring(0, p)));
                    }
                    details.add(new ObjectNode((IObject)object.getClazz()));
                    IClass iClass = superClass = object instanceof IClass ? ((IClass)object).getSuperClass() : object.getClazz().getSuperClass();
                    if (superClass != null) {
                        details.add(new InfoItem(superClass.getObjectId(), MemoryAnalyserPlugin.getImageDescriptor("icons/heapobjects/superclass.gif"), superClass.getName()));
                    }
                    if (object instanceof IClass) {
                        details.add(new ObjectNode(InspectorView.this.snapshot.getObject(((IClass)object).getClassLoaderId())));
                    } else {
                        details.add(new ObjectNode(InspectorView.this.snapshot.getObject(object.getClazz().getClassLoaderId())));
                    }
                    details.add(new InfoItem(MemoryAnalyserPlugin.getImageDescriptor("icons/size.gif"), MessageFormat.format("{0,number} (shallow size)", object.getUsedHeapSize())));
                    details.add(new InfoItem(MemoryAnalyserPlugin.getImageDescriptor("icons/size.gif"), MessageFormat.format("{0,number} (retained size)", object.getRetainedHeapSize())));
                    GCRootInfo[] gc = object.getGCRootInfo();
                    details.add(gc != null ? gc : new InfoItem(MemoryAnalyserPlugin.getImageDescriptor("icons/decorations/gc_root.gif"), "no GC root"));
                    return details;
                }
            };
            job.schedule();
        }
    }

    private void clearInput() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (InspectorView.this.topTableViewer.getContentProvider() != null) {
                    InspectorView.this.topTableViewer.setInput((Object)new Object[]{new Object()});
                }
                if (InspectorView.this.staticsTable.getContentProvider() != null) {
                    InspectorView.this.staticsTable.setInput(LazyFields.EMPTY);
                }
                if (InspectorView.this.attributesTable.getContentProvider() != null) {
                    InspectorView.this.attributesTable.setInput(LazyFields.EMPTY);
                }
                if (InspectorView.this.classHierarchyTree.getContentProvider() != null) {
                    InspectorView.this.classHierarchyTree.setInput((Object)new Object[]{new Object()});
                }
                for (Menu menu : InspectorView.this.contextMenus) {
                    if (menu.isDisposed()) continue;
                    InspectorView.this.disposeItems(menu);
                }
            }
        });
    }

    private void disposeItems(Menu menu) {
        MenuItem[] items;
        MenuItem[] menuItemArray = items = menu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menuItemArray[n2];
            if (!menuItem.isDisposed()) {
                menuItem.dispose();
            }
            ++n2;
        }
    }

    static class BaseNode {
        int objectId;

        public BaseNode(int objectId) {
            this.objectId = objectId;
        }
    }

    private class HierarchyLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private int classId;

        public HierarchyLabelProvider(int classId) {
            this.classId = classId;
        }

        public Image getImage(Object element) {
            return element instanceof IClass ? ImageHelper.getImage(8) : null;
        }

        public String getText(Object element) {
            return element instanceof IClass ? ((IClass)element).getName() : "";
        }

        public Font getFont(Object element) {
            if (element instanceof IClass && ((IClass)element).getObjectId() == this.classId) {
                return InspectorView.this.font;
            }
            return null;
        }
    }

    private class HierarchyTreeContentProvider
    implements ITreeContentProvider {
        LinkedList<IClass> supers;

        private HierarchyTreeContentProvider() {
        }

        public Object[] getChildren(Object element) {
            int index = this.supers.indexOf(element);
            if (index >= 0 && index + 1 < this.supers.size()) {
                return new Object[]{this.supers.get(index + 1)};
            }
            return ((IClass)element).getSubclasses().toArray();
        }

        public IClass getParent(Object element) {
            return ((IClass)element).getSuperClass();
        }

        public boolean hasChildren(Object element) {
            return !((IClass)element).getSubclasses().isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            if (this.supers.isEmpty()) {
                return new Object[0];
            }
            return new Object[]{this.supers.get(0)};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.supers = new LinkedList();
            if (newInput instanceof IClass[]) {
                IClass[] input = (IClass[])newInput;
                this.supers = new LinkedList();
                this.supers.add(input[0]);
                while (input[0].hasSuperClass()) {
                    input[0] = input[0].getSuperClass();
                    this.supers.addFirst(input[0]);
                }
            }
        }
    }

    public class InfoItem
    extends BaseNode {
        private ImageDescriptor descriptor;
        private String text;

        public InfoItem(ImageDescriptor descriptor, String text) {
            this(-1, descriptor, text);
        }

        public InfoItem(int objectId, ImageDescriptor descriptor, String text) {
            super(objectId);
            this.descriptor = descriptor;
            this.text = text;
        }

        public ImageDescriptor getDescriptor() {
            return this.descriptor;
        }

        public String getText() {
            return this.text;
        }
    }

    private class MenuListener
    extends MenuAdapter {
        private Menu menu;
        private StructuredViewer viewer;

        public MenuListener(Menu menu, StructuredViewer viewer) {
            this.menu = menu;
            this.viewer = viewer;
        }

        public void menuShown(MenuEvent e) {
            MenuItem[] items = this.menu.getItems();
            int ii = 0;
            while (ii < items.length) {
                items[ii].dispose();
                ++ii;
            }
            PopupMenu popup = new PopupMenu();
            InspectorView.this.fillContextMenu(popup, this.viewer);
            popup.addToMenu(InspectorView.this.editor.getEditorSite().getActionBars().getStatusLineManager(), this.menu);
        }
    }

    private class ObjectNode
    extends BaseNode {
        String label;
        int imageType;

        public ObjectNode(IObject object) {
            super(object.getObjectId());
            this.label = object.getTechnicalName();
            this.imageType = ImageHelper.getType(object);
        }

        public String getLabel() {
            return this.label;
        }

        public int getImageType() {
            return this.imageType;
        }
    }

    private static final class TableContentProvider
    implements IStructuredContentProvider {
        Object[] elements;

        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.elements = newInput instanceof Collection ? ((Collection)newInput).toArray() : (Object[])newInput;
        }
    }

    private static class TopTableLabelProvider
    extends LabelProvider {
        private TopTableLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof InfoItem) {
                return ((InfoItem)element).getText();
            }
            if (element instanceof ObjectNode) {
                return ((ObjectNode)element).getLabel();
            }
            if (element instanceof GCRootInfo[]) {
                return "GC root: " + GCRootInfo.getTypeSetAsString((GCRootInfo[])((GCRootInfo[])element));
            }
            return "";
        }

        public Image getImage(Object element) {
            if (element instanceof InfoItem) {
                return MemoryAnalyserPlugin.getDefault().getImage(((InfoItem)element).getDescriptor());
            }
            if (element instanceof ObjectNode) {
                return ImageHelper.getImage(((ObjectNode)element).getImageType());
            }
            if (element instanceof GCRootInfo[]) {
                return MemoryAnalyserPlugin.getImage("icons/decorations/gc_root.gif");
            }
            return null;
        }
    }
}

