/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.views.inspector;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.ui.snapshot.views.inspector.FieldNode;
import org.eclipse.mat.ui.snapshot.views.inspector.NamedReferenceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class LazyFields<O extends IObject> {
    private WeakReference<ISnapshot> snapshot;
    private WeakReference<O> array;
    private int objectId;
    protected List<Object> cache = new ArrayList<Object>();
    static final LazyFields<IObject> EMPTY = new LazyFields<IObject>(null){

        @Override
        protected Object createElement(IObject array, int index) {
            return null;
        }

        @Override
        public int getSize() {
            return 0;
        }
    };

    public LazyFields(O object) {
        if (object != null) {
            this.snapshot = new WeakReference<ISnapshot>(object.getSnapshot());
            this.array = new WeakReference<O>(object);
            this.objectId = object.getObjectId();
        }
    }

    public final List<?> getElements(int limit) {
        if (this.cache.size() >= limit || this.cache.size() == this.getSize()) {
            return this.cache;
        }
        O array = this.getObject();
        int ii = this.cache.size();
        while (ii < limit && ii < this.getSize()) {
            this.cache.add(this.createElement(array, ii));
            ++ii;
        }
        return this.cache;
    }

    private final O getObject() {
        IObject object = (IObject)this.array.get();
        if (object == null) {
            ISnapshot snapshot = (ISnapshot)this.snapshot.get();
            if (snapshot == null) {
                throw new RuntimeException("Error Reading arrays details: snapshot not available anymore.");
            }
            try {
                object = snapshot.getObject(this.objectId);
                this.array = new WeakReference<IObject>(object);
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }
        return (O)object;
    }

    protected abstract Object createElement(O var1, int var2);

    public abstract int getSize();

    protected static void fixObjectReferences(ISnapshot snapshot, List<Object> appendTo, List<?> fields, boolean areStatics) {
        int ii = 0;
        while (ii < fields.size()) {
            Field field = (Field)fields.get(ii);
            if (field.getValue() instanceof ObjectReference) {
                ObjectReference ref = (ObjectReference)field.getValue();
                if (ref != null) {
                    appendTo.add(new NamedReferenceNode(new NamedReference(snapshot, ref.getObjectAddress(), field.getName()), areStatics));
                } else {
                    Field f = new Field(field.getName(), field.getType(), (Object)"null");
                    appendTo.add(new FieldNode(f, areStatics));
                }
            } else {
                appendTo.add(new FieldNode(field, areStatics));
            }
            ++ii;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Class
    extends LazyFields<IClass> {
        public Class(IClass object) {
            super(object);
            Class.fixObjectReferences(object.getSnapshot(), this.cache, object.getStaticFields(), true);
        }

        @Override
        protected Object createElement(IClass array, int index) {
            return null;
        }

        @Override
        public int getSize() {
            return this.cache.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Instance
    extends LazyFields<IInstance> {
        public Instance(IInstance object) {
            super(object);
            Instance.fixObjectReferences(object.getSnapshot(), this.cache, object.getFields(), false);
        }

        @Override
        protected Object createElement(IInstance array, int index) {
            return null;
        }

        @Override
        public int getSize() {
            return this.cache.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ObjectArray
    extends LazyFields<IObjectArray> {
        private int length;

        public ObjectArray(IObjectArray array) {
            super(array);
            this.length = array.getLength();
        }

        @Override
        public int getSize() {
            return this.length;
        }

        @Override
        protected Object createElement(IObjectArray array, int index) {
            long[] refs = array.getReferenceArray(index, 1);
            if (refs[0] != 0L) {
                NamedReference ref = new NamedReference(array.getSnapshot(), refs[0], "[" + index + "]");
                return new NamedReferenceNode(ref, false);
            }
            Field f = new Field("[" + index + "]", 2, (Object)"null");
            return new FieldNode(f, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PrimitiveArray
    extends LazyFields<IPrimitiveArray> {
        private int length;

        public PrimitiveArray(IPrimitiveArray array) {
            super(array);
            this.length = array.getLength();
        }

        @Override
        public int getSize() {
            return this.length;
        }

        @Override
        protected Object createElement(IPrimitiveArray array, int index) {
            Field field = new Field("[" + index + "]", array.getType(), array.getValueAt(index));
            return new FieldNode(field, false);
        }
    }
}

