/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mat.query.refined.Filter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class Copy {
    private Control control;
    private Item[] selection;
    private Map<Integer, Integer> columnLengths = new HashMap<Integer, Integer>();

    public static void copyToClipboard(Control control) {
        TableItem[] selection = control instanceof Table ? ((Table)control).getSelection() : ((Tree)control).getSelection();
        new Copy(control, (Item[])selection).doCopy(null);
    }

    public static void exportToTxtFile(Control control, String fileName) {
        PrintWriter writer = null;
        try {
            try {
                writer = new PrintWriter(new FileWriter(fileName));
                new Copy(control, null).doCopy(writer);
            }
            catch (IOException e) {
                throw new RuntimeException("Error in export to .txt: data type not supported for export.", e);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private Copy(Control control, Item[] selection) {
        this.control = control;
        this.selection = selection != null && selection.length > 0 ? selection : null;
    }

    private void doCopy(PrintWriter writer) {
        StringBuffer resultBuffer = new StringBuffer();
        StringBuffer rowBuffer = new StringBuffer();
        int numberOfColumns = this.getColumnCount();
        Object[] items = this.selection != null ? this.selection : (this.control instanceof Table ? ((Table)this.control).getItems() : ((Tree)this.control).getItems());
        Item[] columns = this.getColumns(this.control);
        if (numberOfColumns == 0) {
            resultBuffer = this.copySimpleStructure(items, resultBuffer);
        } else {
            int columnIndex = 0;
            while (columnIndex < numberOfColumns) {
                this.getColumnLength(items, columns, columnIndex);
                ++columnIndex;
            }
            int i = 0;
            while (i < numberOfColumns) {
                if (i == 0) {
                    resultBuffer.append(Copy.align(columns[i].getText(), true, this.columnLengths.get(0)));
                } else {
                    resultBuffer.append("|" + Copy.align(columns[i].getText(), false, this.columnLengths.get(i)));
                }
                ++i;
            }
            resultBuffer.append("\r\n");
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                boolean addLineBreak = true;
                int columnIndex2 = 0;
                while (columnIndex2 < numberOfColumns) {
                    String value = "";
                    if (item instanceof TableItem) {
                        value = ((TableItem)item).getText(columnIndex2);
                    } else if (item instanceof TreeItem && this.toPrint((TreeItem)item)) {
                        value = ((TreeItem)item).getText(columnIndex2);
                    } else if (item instanceof TreeItem && !this.toPrint((TreeItem)item)) {
                        addLineBreak = false;
                        break;
                    }
                    String[] stringArray = Filter.FILTER_TYPES;
                    int n3 = Filter.FILTER_TYPES.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String filterName = stringArray[n4];
                        if (value.equals(filterName)) {
                            value = "";
                        }
                        ++n4;
                    }
                    if (columnIndex2 == 0) {
                        rowBuffer.append(Copy.align(value, true, this.columnLengths.get(0)));
                    } else {
                        rowBuffer.append("|" + Copy.align(value, false, this.columnLengths.get(columnIndex2)));
                    }
                    ++columnIndex2;
                }
                if (addLineBreak) {
                    rowBuffer.append("\r\n");
                }
                if (item instanceof TreeItem && ((TreeItem)item).getExpanded() && this.toPrint((TreeItem)item)) {
                    this.addNextLineToClipboard(new StringBuilder(), (TreeItem)item, rowBuffer, numberOfColumns, this.columnLengths.get(0));
                }
                ++n2;
            }
            String dashedLine = this.getDashedLine(numberOfColumns);
            this.columnLengths.clear();
            resultBuffer.append(String.valueOf(dashedLine) + "\r\n");
            resultBuffer.append(rowBuffer);
            resultBuffer.append(String.valueOf(dashedLine) + "\r\n");
        }
        if (writer != null) {
            writer.append(resultBuffer.toString());
            writer.flush();
            writer.close();
        } else {
            Clipboard clipboard = new Clipboard(this.control.getDisplay());
            clipboard.setContents(new Object[]{resultBuffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    /*
     * Unable to fully structure code
     */
    private StringBuffer copySimpleStructure(Object[] items, StringBuffer resultBuffer) {
        var6_3 = items;
        var5_4 = items.length;
        var4_5 = 0;
        while (var4_5 < var5_4) {
            block6: {
                block5: {
                    item = var6_3[var4_5];
                    addLineBreak = true;
                    value = "";
                    if (!(item instanceof TableItem)) break block5;
                    value = ((TableItem)item).getText();
                    ** GOTO lbl-1000
                }
                if (!(item instanceof TreeItem) || !this.toPrint((TreeItem)item)) break block6;
                value = ((TreeItem)item).getText();
                ** GOTO lbl-1000
            }
            if (item instanceof TreeItem && !this.toPrint((TreeItem)item)) {
                addLineBreak = false;
            } else lbl-1000:
            // 3 sources

            {
                resultBuffer.append(Copy.align(value, true, value.length()));
                if (addLineBreak) {
                    resultBuffer.append("\r\n");
                }
                if (item instanceof TreeItem && ((TreeItem)item).getExpanded() && this.toPrint((TreeItem)item)) {
                    this.addNextLineToClipboard(new StringBuilder(), (TreeItem)item, resultBuffer, 0, ((TreeItem)item).getText().length());
                }
            }
            ++var4_5;
        }
        return resultBuffer;
    }

    private void addNextLineToClipboard(StringBuilder level, TreeItem item, StringBuffer rowBuffer, int numberOfColumns, int length) {
        TreeItem[] children = item.getItems();
        int j = 0;
        while (j < children.length) {
            level = this.getLevel(level, children.length, j);
            if (this.selection == null || !this.skip(children[j])) {
                if (numberOfColumns == 0) {
                    rowBuffer.append(level + Copy.align(children[j].getText(), true, length - level.length()));
                } else {
                    int i = 0;
                    while (i < numberOfColumns) {
                        if (i == 0) {
                            rowBuffer.append(level + Copy.align(children[j].getText(i), true, length - level.length()));
                        } else {
                            rowBuffer.append("|" + Copy.align(children[j].getText(i), false, this.columnLengths.get(i)));
                        }
                        ++i;
                    }
                }
                rowBuffer.append("\r\n");
                if (children[j].getExpanded()) {
                    this.addNextLineToClipboard(level, children[j], rowBuffer, numberOfColumns, length);
                }
                if (level.length() >= 3) {
                    level.delete(level.length() - 3, level.length());
                }
            }
            ++j;
        }
    }

    private Item[] getColumns(Control control) {
        if (control instanceof Table) {
            return ((Table)control).getColumns();
        }
        return ((Tree)control).getColumns();
    }

    private int getColumnCount() {
        if (this.control instanceof Table) {
            return ((Table)this.control).getColumnCount();
        }
        if (this.control instanceof Tree) {
            return ((Tree)this.control).getColumnCount();
        }
        return 0;
    }

    private static String align(String s, boolean left, int length) {
        StringBuffer buf = new StringBuffer(length);
        if (s != null) {
            if (s.length() > length) {
                return s;
            }
            int blanks = length - s.length();
            if (left) {
                buf.append(s);
            }
            int i = 0;
            while (i < blanks) {
                buf.append(' ');
                ++i;
            }
            if (!left) {
                buf.append(' ');
                buf.append(s);
                buf.append(' ');
            }
        } else {
            int i = 0;
            while (i < length) {
                buf.append(' ');
                ++i;
            }
            if (!left) {
                buf.append(' ').append(' ');
            }
        }
        return buf.toString();
    }

    private String getDashedLine(int numberOfColumns) {
        StringBuffer dashes = new StringBuffer();
        int dashesLength = 0;
        int i = 0;
        while (i < numberOfColumns) {
            dashesLength += this.columnLengths.get(i).intValue();
            ++i;
        }
        i = 0;
        while (i < dashesLength + numberOfColumns * 2) {
            dashes.append('-');
            ++i;
        }
        return dashes.toString();
    }

    private int getColumnLength(Object[] items, Item[] columns, int columnNumber) {
        int lengthToCompare = 0;
        String header = columns[columnNumber].getText();
        int length = header != null ? header.length() : 0;
        int i = 0;
        while (i < items.length) {
            lengthToCompare = items[i] instanceof TableItem ? ((TableItem)items[i]).getText(columnNumber).length() : ((TreeItem)items[i]).getText(columnNumber).length();
            if (lengthToCompare > length) {
                length = lengthToCompare;
            }
            if (items[i] instanceof TreeItem && ((TreeItem)items[i]).getExpanded()) {
                lengthToCompare = columnNumber == 0 ? this.compare((TreeItem)items[i], length, new StringBuilder()) : this.getOtherColumnLength((TreeItem)items[i], length, columnNumber);
            }
            if (lengthToCompare > length) {
                length = lengthToCompare;
            }
            ++i;
        }
        if (!this.columnLengths.containsKey(columnNumber) || this.columnLengths.containsKey(columnNumber) && this.columnLengths.get(columnNumber) < length) {
            this.columnLengths.put(columnNumber, length);
        }
        return length;
    }

    private int getOtherColumnLength(TreeItem item, int length, int columnNumber) {
        int lengthToCompare = 0;
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            if (this.selection == null || !this.skip(children[i])) {
                String columnText = children[i].getText(columnNumber);
                if (columnText != null) {
                    lengthToCompare = columnText.length();
                }
                if (lengthToCompare > length) {
                    length = lengthToCompare;
                }
                if (children[i].getExpanded() && (lengthToCompare = this.getOtherColumnLength(children[i], length, columnNumber)) > length) {
                    length = lengthToCompare;
                }
            }
            ++i;
        }
        return length;
    }

    private int compare(TreeItem item, int length, StringBuilder level) {
        int lengthToCompare = 0;
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            if (this.selection == null || !this.skip(children[i])) {
                level = this.getLevel(level, children.length, i);
                lengthToCompare = children[i].getText(0).length() + level.length();
                if (lengthToCompare > length) {
                    length = lengthToCompare;
                }
                if (children[i].getExpanded() && (lengthToCompare = this.compare(children[i], length, level)) > length) {
                    length = lengthToCompare;
                }
                if (level.length() >= 3) {
                    level.delete(level.length() - 3, level.length());
                }
            }
            ++i;
        }
        return length;
    }

    private boolean toPrint(TreeItem item) {
        TreeItem[] selection;
        if (this.selection == null) {
            return true;
        }
        TreeItem[] treeItemArray = selection = (TreeItem[])this.selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem.equals(item.getParentItem())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean skip(TreeItem item) {
        TreeItem[] selection;
        TreeItem[] treeItemArray = selection = (TreeItem[])this.selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem.equals(item)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private StringBuilder getLevel(StringBuilder level, int length, int counter) {
        int k = level.indexOf("'-");
        if (k != -1) {
            level.replace(k, k + 2, "  ");
        } else {
            k = level.indexOf("|-");
            if (k != -1) {
                level.replace(k + 1, k + 2, " ");
            }
        }
        if (counter == length - 1) {
            level.append('\'');
        } else {
            level.append('|');
        }
        level.append("- ");
        return level;
    }
}

