/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.util;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ErrorHelper {
    public static void logThrowable(Throwable throwable) {
        Status status = new Status(4, "org.eclipse.mat.ui", 1, "Internal Error", throwable);
        MemoryAnalyserPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void logThrowableAndShowMessage(Throwable throwable, final String message) {
        final IStatus status = ErrorHelper.createErrorStatus(null, throwable);
        MemoryAnalyserPlugin.getDefault().getLog().log(status);
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)message, (IStatus)status);
            }
        });
    }

    public static void logThrowableAndShowMessage(Throwable throwable) {
        ErrorHelper.logThrowableAndShowMessage(throwable, throwable.getMessage());
    }

    public static void showErrorMessage(Throwable throwable) {
        ErrorHelper.showErrorMessage(ErrorHelper.createErrorStatus(throwable));
    }

    public static void showErrorMessage(String message) {
        ErrorHelper.showErrorMessage(ErrorHelper.createErrorStatus(message));
    }

    private static void showErrorMessage(final IStatus status) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", null, (IStatus)status);
            }
        });
    }

    public static void showInfoMessage(final String message) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Information", (String)message);
            }
        });
    }

    public static IStatus createErrorStatus(String message) {
        return new Status(4, "org.eclipse.mat.ui", message, null);
    }

    public static IStatus createErrorStatus(Throwable throwable) {
        return ErrorHelper.createErrorStatus(null, throwable);
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        if (message == null) {
            message = ErrorHelper.enrichErrorMessage(throwable.getMessage(), throwable.getClass().getName());
        }
        if (throwable == null) {
            return ErrorHelper.createErrorStatus(message);
        }
        if (throwable.getCause() == null) {
            return new Status(4, "org.eclipse.mat.ui", message, throwable);
        }
        MultiStatus result = new MultiStatus("org.eclipse.mat.ui", 0, message, null);
        while (throwable != null) {
            message = ErrorHelper.enrichErrorMessage(throwable.getMessage(), throwable.getClass().getName());
            result.add((IStatus)new Status(4, "org.eclipse.mat.ui", 0, message, throwable));
            throwable = throwable instanceof CoreException ? ((CoreException)throwable).getStatus().getException() : throwable.getCause();
        }
        return result;
    }

    public static String enrichErrorMessage(String message, String exceptionType) {
        if ("java.lang.RuntimeException".equals(exceptionType)) {
            return MessageFormat.format("Internal Runtime Error ({0})", message);
        }
        if ("java.lang.ClassNotFoundException".equals(exceptionType)) {
            return MessageFormat.format("Class {0} not found", message);
        }
        if ("java.lang.NoClassDefFoundError".equals(exceptionType)) {
            return MessageFormat.format("Definition of class {0} not found (NoClassDefFoundError)", message);
        }
        if ("java.lang.NoSuchMethodError".equals(exceptionType)) {
            return MessageFormat.format("No such method: {0}", message);
        }
        if (message == null) {
            return MessageFormat.format("Exception of type {0}", exceptionType);
        }
        return message;
    }
}

