/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.snapshot.HeapObjectContextArgument;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.DetailResultProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IStructuredResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.CategoryDescriptor;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.AbstractPaneJob;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.PaneState;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryContextMenu {
    private MultiPaneEditor editor;
    private List<ContextProvider> contextProvider;
    private List<DetailResultProvider> resultProvider;
    private QueryResult queryResult;
    private static final Pattern PATH_PATTERN = Pattern.compile("^[^ ]*\\.([A-Z][\\p{Alnum}$]([^ .])*.*)$");

    public QueryContextMenu(AbstractEditorPane pane, QueryResult result) {
        this(pane.getEditor(), result);
    }

    public QueryContextMenu(MultiPaneEditor editor, QueryResult result) {
        this.editor = editor;
        this.queryResult = result;
        if (!(result.getSubject() instanceof IStructuredResult)) {
            throw new UnsupportedOperationException("Subject of QueryResult must be of type IStructuredResult");
        }
        this.resultProvider = result.getResultMetaData().getDetailResultProviders();
        this.contextProvider = result.getResultMetaData().getContextProviders();
        if (this.contextProvider.isEmpty()) {
            this.contextProvider = new ArrayList<ContextProvider>(1);
            this.contextProvider.add(result.getDefaultContextProvider());
        }
    }

    public QueryContextMenu(MultiPaneEditor editor, ContextProvider provider) {
        this.editor = editor;
        this.resultProvider = new ArrayList<DetailResultProvider>(0);
        this.contextProvider = new ArrayList<ContextProvider>(1);
        this.contextProvider.add(provider);
    }

    public QueryContextMenu(AbstractEditorPane pane, ContextProvider provider) {
        this(pane.getEditor(), provider);
    }

    public final void addContextActions(PopupMenu manager, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        this.resultMenu(manager, selection);
        String label = null;
        for (ContextProvider p : this.contextProvider) {
            ArrayList<IContextObject> menuContext = new ArrayList<IContextObject>();
            for (Object selected : selection) {
                IContextObject ctx = p.getContext(selected);
                if (ctx == null) continue;
                menuContext.add(ctx);
            }
            if (menuContext.isEmpty()) continue;
            PopupMenu menu = manager;
            String menuLabel = p.getLabel();
            if (menuLabel != null) {
                menu = new PopupMenu(menuLabel);
                manager.add(menu);
            }
            if (label == null) {
                label = this.getLabel(selection);
            }
            this.queryMenu(menu, menuContext, label);
            this.customMenu(menu, menuContext, p, label);
        }
    }

    private String getLabel(IStructuredSelection selection) {
        Column col;
        IStructuredResult result;
        Object value;
        String label = this.queryResult == null ? "context" : (selection.size() == 1 ? ((value = (result = (IStructuredResult)this.queryResult.getSubject()).getColumnValue(selection.getFirstElement(), 0)) == null ? "selection of " + (this.queryResult.getQuery() != null ? this.queryResult.getQuery().getName() : this.queryResult.getCommand()) : ((col = result.getColumns()[0]).getFormatter() != null ? "selection of '" + col.getFormatter().format(value) + "'" : "selection of '" + QueryContextMenu.fixLabel(String.valueOf(value)) + "'")) : (this.queryResult.getQuery() != null ? "selection of " + this.queryResult.getQuery().getName() : "selection of " + this.queryResult.getCommand()));
        return label;
    }

    private void resultMenu(PopupMenu menu, IStructuredSelection selection) {
        if (selection.size() == 1) {
            boolean hasContextResultProviderMenu = false;
            for (final DetailResultProvider r : this.resultProvider) {
                Object firstElement;
                boolean hasResult = r.hasResult(firstElement = selection.getFirstElement());
                if (!hasResult) continue;
                final PaneState originator = this.editor.getActiveEditor().getPaneState();
                menu.add(new Action(r.getLabel()){

                    public void run() {
                        new AbstractPaneJob(MessageFormat.format("Processing: {0}", r.getLabel()), null){

                            protected IStatus doRun(IProgressMonitor monitor) {
                                try {
                                    IResult result = r.getResult(firstElement, (IProgressListener)new ProgressMonitorWrapper(monitor));
                                    QueryResult qr = new QueryResult(null, MessageFormat.format("Details: {0}", r.getLabel()), result);
                                    QueryExecution.displayResult(QueryContextMenu.this.editor, originator, null, qr, false);
                                    return Status.OK_STATUS;
                                }
                                catch (SnapshotException e) {
                                    return ErrorHelper.createErrorStatus(e);
                                }
                            }
                        }.schedule();
                    }
                });
                hasContextResultProviderMenu = true;
            }
            if (hasContextResultProviderMenu) {
                menu.addSeparator();
            }
        }
    }

    private void queryMenu(PopupMenu menu, List<IContextObject> menuContext, String label) {
        this.addCategories(menu, QueryRegistry.instance().getRootCategory(), menuContext, label, new Policy(menuContext));
    }

    private void addCategories(PopupMenu menu, CategoryDescriptor root, List<IContextObject> menuContext, String label, Policy policy) {
        for (Object item : root.getChildren()) {
            QueryDescriptor query;
            if (item instanceof CategoryDescriptor) {
                CategoryDescriptor sub = (CategoryDescriptor)item;
                PopupMenu subManager = new PopupMenu(sub.getName());
                menu.add(subManager);
                this.addCategories(subManager, sub, menuContext, label, policy);
                continue;
            }
            if (!(item instanceof QueryDescriptor) || !policy.accept(query = (QueryDescriptor)item)) continue;
            menu.add(new QueryAction(this.editor, query, menuContext, label));
        }
    }

    protected void customMenu(PopupMenu menu, List<IContextObject> menuContext, ContextProvider provider, String label) {
    }

    private static String fixLabel(String label) {
        Matcher matcher = PATH_PATTERN.matcher(label);
        label = matcher.matches() ? matcher.group(1) : label;
        return label.length() > 100 ? String.valueOf(label.substring(0, 100)) + "..." : label;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Policy {
        private final boolean multiRowSelection;
        private final boolean multiObjectSelection;
        private Class<? extends IContextObject> type;

        public Policy(List<IContextObject> menuContext) {
            this.multiRowSelection = menuContext.size() > 1;
            this.multiObjectSelection = this.multiRowSelection || menuContext.get(0) instanceof IContextObjectSet;
            this.type = IContextObjectSet.class;
            for (IContextObject obj : menuContext) {
                if (IContextObjectSet.class.isAssignableFrom(obj.getClass())) continue;
                this.type = IContextObject.class;
                break;
            }
        }

        public boolean accept(QueryDescriptor query) {
            boolean heapObjectArgExists = false;
            boolean heapObjectArgIsMultiple = false;
            boolean contextObjectArgExists = false;
            boolean contextObjectArgIsMultiple = false;
            for (ArgumentDescriptor argument : query.getArguments()) {
                if (this.isHeapObject(argument)) {
                    heapObjectArgExists = true;
                    heapObjectArgIsMultiple = heapObjectArgIsMultiple || argument.isMultiple() || IHeapObjectArgument.class.isAssignableFrom(argument.getType());
                    continue;
                }
                if (!argument.getType().isAssignableFrom(this.type)) continue;
                contextObjectArgExists = true;
                boolean bl = contextObjectArgIsMultiple = contextObjectArgIsMultiple || argument.isMultiple();
            }
            if (!heapObjectArgExists && !contextObjectArgExists) {
                return false;
            }
            if (heapObjectArgExists && !heapObjectArgIsMultiple && this.multiObjectSelection) {
                return false;
            }
            return !contextObjectArgExists || contextObjectArgIsMultiple || !this.multiRowSelection;
        }

        private boolean isHeapObject(ArgumentDescriptor argument) {
            Class argType = argument.getType();
            if (argType.isAssignableFrom(Integer.TYPE) && argument.getAdvice() == Argument.Advice.HEAP_OBJECT) {
                return true;
            }
            if (argType.isAssignableFrom(IObject.class)) {
                return true;
            }
            return argType.isAssignableFrom(IHeapObjectArgument.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class QueryAction
    extends Action {
        MultiPaneEditor editor;
        QueryDescriptor query;
        List<IContextObject> context;
        String label;

        public QueryAction(MultiPaneEditor editor, QueryDescriptor query, List<IContextObject> context, String label) {
            super(query.getName());
            this.editor = editor;
            this.query = query;
            this.context = context;
            this.label = label;
            this.setToolTipText(query.getShortDescription());
            this.setImageDescriptor(MemoryAnalyserPlugin.getDefault().getImageDescriptor(query));
        }

        public void run() {
            try {
                ArgumentSet set = this.query.createNewArgumentSet(this.editor.getQueryContext());
                this.fillInObjectArguments(set);
                QueryExecution.execute(this.editor, this.editor.getActiveEditor().getPaneState(), null, set, !this.query.isShallow(), false);
            }
            catch (SnapshotException e) {
                ErrorHelper.logThrowableAndShowMessage(e);
            }
        }

        private void fillInObjectArguments(ArgumentSet set) {
            ISnapshot snapshot = (ISnapshot)this.editor.getQueryContext().get(ISnapshot.class, null);
            for (ArgumentDescriptor argument : this.query.getArguments()) {
                if (Integer.TYPE.isAssignableFrom(argument.getType()) && argument.getAdvice() == Argument.Advice.HEAP_OBJECT || IObject.class.isAssignableFrom(argument.getType()) || IHeapObjectArgument.class.isAssignableFrom(argument.getType())) {
                    set.setArgumentValue(argument, (Object)new HeapObjectContextArgument(snapshot, this.context, this.label));
                    continue;
                }
                if (IContextObjectSet.class.isAssignableFrom(argument.getType())) {
                    if (argument.isMultiple()) {
                        set.setArgumentValue(argument, this.context);
                        continue;
                    }
                    set.setArgumentValue(argument, (Object)this.context.get(0));
                    continue;
                }
                if (!IContextObject.class.isAssignableFrom(argument.getType())) continue;
                if (argument.isMultiple()) {
                    set.setArgumentValue(argument, this.context);
                    continue;
                }
                set.setArgumentValue(argument, (Object)this.context.get(0));
            }
        }
    }
}

