/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.report.internal.ReportPlugin;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.RegistryReader;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpecFactory
extends RegistryReader<Report> {
    private static final SpecFactory instance = new SpecFactory();

    public static final SpecFactory instance() {
        return instance;
    }

    private SpecFactory() {
        this.init(ReportPlugin.getDefault().getExtensionTracker(), "org.eclipse.mat.report.report");
    }

    @Override
    protected Report createDelegate(IConfigurationElement configElement) throws CoreException {
        return new Report(configElement);
    }

    @Override
    protected void removeDelegate(Report delegate) {
    }

    public Spec create(Report report) throws IOException {
        URL url = report.getURL();
        if (url == null) {
            return null;
        }
        InputStream in = null;
        try {
            in = url.openStream();
            Spec spec = SpecFactory.read(in, Platform.getBundle((String)report.configElement.getNamespaceIdentifier()));
            return spec;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public Spec create(String extensionIdentifier) throws IOException {
        for (Report report : this.delegates()) {
            if (!extensionIdentifier.equals(report.getExtensionIdentifier())) continue;
            return this.create(report);
        }
        return null;
    }

    public Spec create(File specFile) throws IOException {
        FileInputStream in = new FileInputStream(specFile);
        try {
            Spec spec = SpecFactory.read(in, null);
            return spec;
        }
        finally {
            in.close();
        }
    }

    public void resolve(Spec master) throws IOException {
        if (master.getTemplate() != null) {
            String template = master.getTemplate();
            Spec other = this.create(template);
            if (other != null) {
                this.resolve(other);
                master.merge(other);
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, MessageUtil.format(Messages.SpecFactory_Error_MissingTemplate, template));
            }
        }
        if (master instanceof SectionSpec) {
            for (Spec child : ((SectionSpec)master).getChildren()) {
                this.resolve(child);
            }
        }
    }

    private static final Spec read(InputStream input, Bundle bundle) throws IOException {
        try {
            SpecHandler handler = new SpecHandler(bundle);
            XMLReader saxXmlReader = XMLReaderFactory.createXMLReader();
            saxXmlReader.setContentHandler(handler);
            saxXmlReader.setErrorHandler(handler);
            saxXmlReader.parse(new InputSource(input));
            return handler.getSpec();
        }
        catch (SAXException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public class Report {
        String name;
        String description;
        IConfigurationElement configElement;

        public Report(IConfigurationElement configElement) {
            this.configElement = configElement;
            this.name = configElement.getAttribute("name");
            this.description = configElement.getAttribute("description");
        }

        public String getExtensionIdentifier() {
            return String.valueOf(this.configElement.getNamespaceIdentifier()) + ":" + this.configElement.getAttribute("id");
        }

        protected URL getURL() {
            Bundle bundle = Platform.getBundle((String)this.configElement.getContributor().getName());
            if (bundle == null) {
                return null;
            }
            return bundle.getResource(this.configElement.getAttribute("file"));
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static class SpecHandler
    extends DefaultHandler {
        private Bundle bundle;
        private LinkedList<Spec> stack;
        private StringBuilder buf;

        private SpecHandler(Bundle bundle) {
            this.bundle = bundle;
            this.stack = new LinkedList();
            this.stack.add(new SectionSpec("root"));
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("section".equals(localName)) {
                String n = attributes.getValue("name");
                if (this.bundle != null && n != null && n.length() > 0 && n.charAt(0) == '%') {
                    n = Platform.getResourceString((Bundle)this.bundle, (String)n);
                }
                SectionSpec spec = new SectionSpec(n);
                ((SectionSpec)this.stack.getLast()).add(spec);
                this.stack.add(spec);
            } else if ("query".equals(localName)) {
                String n = attributes.getValue("name");
                if (this.bundle != null && n != null && n.length() > 0 && n.charAt(0) == '%') {
                    n = Platform.getResourceString((Bundle)this.bundle, (String)n);
                }
                QuerySpec spec = new QuerySpec(n);
                ((SectionSpec)this.stack.getLast()).add(spec);
                this.stack.add(spec);
            } else if ("param".equals(localName)) {
                this.stack.getLast().set(attributes.getValue("key"), attributes.getValue("value"));
            } else if ("template".equals(localName)) {
                this.buf = new StringBuilder();
            } else if ("command".equals(localName)) {
                this.buf = new StringBuilder();
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            if ("section".equals(localName)) {
                this.stack.removeLast();
            } else if ("query".equals(localName)) {
                this.stack.removeLast();
            } else if ("template".equals(localName)) {
                this.stack.getLast().setTemplate(this.buf.toString());
                this.buf = null;
            } else if ("command".equals(localName)) {
                ((QuerySpec)this.stack.getLast()).setCommand(this.buf.toString());
                this.buf = null;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buf != null) {
                this.buf.append(ch, start, length);
            }
        }

        public Spec getSpec() {
            return ((SectionSpec)this.stack.getFirst()).getChildren().get(0);
        }
    }
}

