/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentRegistryReader;
import org.eclipse.ui.internal.navigator.wizards.CommonWizardDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public class CommonWizardDescriptorManager {
    private static final CommonWizardDescriptorManager INSTANCE = new CommonWizardDescriptorManager();
    private static boolean isInitialized = false;
    private static final String[] NO_DESCRIPTOR_IDS = new String[0];
    private static final CommonWizardDescriptor[] NO_DESCRIPTORS = new CommonWizardDescriptor[0];
    public static final String WIZARD_TYPE_NEW = "new";
    private Map commonWizardDescriptors = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommonWizardDescriptorManager getInstance() {
        if (isInitialized) {
            return INSTANCE;
        }
        CommonWizardDescriptorManager commonWizardDescriptorManager = INSTANCE;
        synchronized (commonWizardDescriptorManager) {
            if (!isInitialized) {
                INSTANCE.init();
                isInitialized = true;
            }
        }
        return INSTANCE;
    }

    private void init() {
        new CommonWizardRegistry().readRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommonWizardDescriptor(CommonWizardDescriptor aDesc) {
        if (aDesc == null) {
            return;
        }
        if (aDesc.getWizardId() == null) {
            NavigatorPlugin.logError(0, "A null wizardId was supplied for a commonWizard in " + aDesc.getNamespace(), null);
        }
        Map map = this.commonWizardDescriptors;
        synchronized (map) {
            HashSet<CommonWizardDescriptor> descriptors = (HashSet<CommonWizardDescriptor>)this.commonWizardDescriptors.get(aDesc.getType());
            if (descriptors == null) {
                descriptors = new HashSet<CommonWizardDescriptor>();
                this.commonWizardDescriptors.put(aDesc.getType(), descriptors);
            }
            if (!descriptors.contains(aDesc)) {
                descriptors.add(aDesc);
            }
        }
    }

    public String[] getEnabledCommonWizardDescriptorIds(Object anElement, String aType, INavigatorContentService aContentService) {
        Set commonDescriptors = (Set)this.commonWizardDescriptors.get(aType);
        if (commonDescriptors == null) {
            return NO_DESCRIPTOR_IDS;
        }
        ArrayList<String> descriptorIds = new ArrayList<String>();
        Iterator commonWizardDescriptorsItr = commonDescriptors.iterator();
        while (commonWizardDescriptorsItr.hasNext()) {
            CommonWizardDescriptor descriptor = (CommonWizardDescriptor)commonWizardDescriptorsItr.next();
            if (!this.isVisible(aContentService, descriptor) || !descriptor.isEnabledFor(anElement)) continue;
            descriptorIds.add(descriptor.getWizardId());
        }
        String[] wizardIds = new String[descriptorIds.size()];
        return descriptorIds.toArray(wizardIds);
    }

    public CommonWizardDescriptor[] getEnabledCommonWizardDescriptors(Object anElement, String aType, INavigatorContentService aContentService) {
        Set commonDescriptors = (Set)this.commonWizardDescriptors.get(aType);
        if (commonDescriptors == null) {
            return NO_DESCRIPTORS;
        }
        ArrayList<CommonWizardDescriptor> descriptors = new ArrayList<CommonWizardDescriptor>();
        Iterator commonWizardDescriptorsItr = commonDescriptors.iterator();
        while (commonWizardDescriptorsItr.hasNext()) {
            CommonWizardDescriptor descriptor = (CommonWizardDescriptor)commonWizardDescriptorsItr.next();
            if (!this.isVisible(aContentService, descriptor) || !descriptor.isEnabledFor(anElement)) continue;
            descriptors.add(descriptor);
        }
        CommonWizardDescriptor[] enabledDescriptors = new CommonWizardDescriptor[descriptors.size()];
        return descriptors.toArray(enabledDescriptors);
    }

    private boolean isVisible(INavigatorContentService aContentService, CommonWizardDescriptor descriptor) {
        return !WorkbenchActivityHelper.filterItem((Object)descriptor) && (aContentService == null || descriptor.getId() == null || aContentService.isVisible(descriptor.getId()) && aContentService.isActive(descriptor.getId()));
    }

    private class CommonWizardRegistry
    extends NavigatorContentRegistryReader {
        private CommonWizardRegistry() {
        }

        protected boolean readElement(IConfigurationElement anElement) {
            if ("commonWizard".equals(anElement.getName())) {
                try {
                    CommonWizardDescriptorManager.this.addCommonWizardDescriptor(new CommonWizardDescriptor(anElement));
                }
                catch (WorkbenchException e) {
                    NavigatorPlugin.logError(0, e.getMessage(), e);
                    return false;
                }
                return true;
            }
            if ("navigatorContent".equals(anElement.getName())) {
                IConfigurationElement[] commonWizards = anElement.getChildren("commonWizard");
                String contentExtensionId = anElement.getAttribute("id");
                int i = 0;
                while (i < commonWizards.length) {
                    try {
                        CommonWizardDescriptorManager.this.addCommonWizardDescriptor(new CommonWizardDescriptor(commonWizards[i], contentExtensionId));
                    }
                    catch (WorkbenchException e) {
                        NavigatorPlugin.logError(0, e.getMessage(), e);
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return super.readElement(anElement);
        }
    }
}

