/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.datafeed;

import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.util.CDateTime;

final class GroupingUtil {
    GroupingUtil() {
    }

    static CDateTime formatGroupedDateTime(Object obj, GroupingUnitType groupingUnitType) {
        int cunit = GroupingUtil.groupingUnit2CDateUnit(groupingUnitType);
        CDateTime date = null;
        date = obj instanceof CDateTime ? (CDateTime)((Object)obj) : new CDateTime(0L);
        date.clearBelow(cunit);
        return date;
    }

    static int groupingUnit2CDateUnit(GroupingUnitType groupingUnitType) {
        if (groupingUnitType != null) {
            switch (groupingUnitType.getValue()) {
                case 0: {
                    return 13;
                }
                case 1: {
                    return 12;
                }
                case 2: {
                    return 11;
                }
                case 3: {
                    return 5;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 2;
                }
                case 7: {
                    return 1;
                }
                case 6: {
                    return 6;
                }
            }
        }
        return 14;
    }

    public static boolean isMatchedGroupingString(String baseValue, String baseReference, GroupingUnitType groupingUnit, int groupingInterval) {
        if (baseValue == null && baseReference == null) {
            return true;
        }
        if (baseValue == null || baseReference == null) {
            return false;
        }
        if (groupingUnit == GroupingUnitType.STRING_PREFIX_LITERAL) {
            if (groupingInterval <= 0) {
                return true;
            }
            if (baseValue.length() < groupingInterval || baseReference.length() < groupingInterval) {
                return baseValue.equals(baseReference);
            }
            return baseValue.substring(0, groupingInterval).equals(baseReference.substring(0, groupingInterval));
        }
        if (groupingUnit == GroupingUnitType.STRING_LITERAL) {
            return baseValue.equals(baseReference);
        }
        return baseValue.equals(baseReference);
    }

    public static Object getGroupedString(String stringValue, GroupingUnitType groupingUnit, int groupingInterval) {
        if (stringValue == null) {
            return stringValue;
        }
        if (groupingUnit == GroupingUnitType.STRING_PREFIX_LITERAL) {
            if (groupingInterval <= 0) {
                return "";
            }
            if (stringValue.length() < groupingInterval) {
                return stringValue;
            }
            return stringValue.substring(0, groupingInterval);
        }
        return stringValue;
    }
}

