/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ScaleUnitType implements Enumerator
{
    SECONDS_LITERAL(0, "Seconds", "Seconds"),
    MINUTES_LITERAL(1, "Minutes", "Minutes"),
    HOURS_LITERAL(2, "Hours", "Hours"),
    DAYS_LITERAL(3, "Days", "Days"),
    WEEKS_LITERAL(4, "Weeks", "Weeks"),
    MONTHS_LITERAL(5, "Months", "Months"),
    YEARS_LITERAL(6, "Years", "Years");

    public static final int SECONDS = 0;
    public static final int MINUTES = 1;
    public static final int HOURS = 2;
    public static final int DAYS = 3;
    public static final int WEEKS = 4;
    public static final int MONTHS = 5;
    public static final int YEARS = 6;
    private static final ScaleUnitType[] VALUES_ARRAY;
    public static final List<ScaleUnitType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ScaleUnitType[]{SECONDS_LITERAL, MINUTES_LITERAL, HOURS_LITERAL, DAYS_LITERAL, WEEKS_LITERAL, MONTHS_LITERAL, YEARS_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ScaleUnitType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ScaleUnitType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ScaleUnitType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ScaleUnitType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ScaleUnitType get(int value) {
        switch (value) {
            case 0: {
                return SECONDS_LITERAL;
            }
            case 1: {
                return MINUTES_LITERAL;
            }
            case 2: {
                return HOURS_LITERAL;
            }
            case 3: {
                return DAYS_LITERAL;
            }
            case 4: {
                return WEEKS_LITERAL;
            }
            case 5: {
                return MONTHS_LITERAL;
            }
            case 6: {
                return YEARS_LITERAL;
            }
        }
        return null;
    }

    private ScaleUnitType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

