/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.util;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.ULocale;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.birt.chart.aggregate.IAggregateFunction;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.computation.Polygon;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.internal.factory.DateFormatWrapperFactory;
import org.eclipse.birt.chart.internal.factory.IDateFormatWrapper;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.ScaleUnitType;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartUtil {
    public static final double EPS = 1.0E-9;
    private static final String EPS_FORMAT = "%.9f";
    private static final IGObjectFactory goFactory = GObjectFactory.instance();
    private static final int DEFAULT_MAX_ROW_COUNT = 0;
    public static final String CHART_MAX_ROW = "CHART_MAX_ROW";

    public static final boolean isColorTransparent(ColorDefinition cdef) {
        return cdef == null || cdef.isSetTransparency() && cdef.getTransparency() == 0;
    }

    public static final boolean isShadowDefined(Label la) {
        return !ChartUtil.isColorTransparent(la.getShadowColor());
    }

    public static final boolean mathEqual(double v1, double v2) {
        return Math.abs(v1 - v2) < 1.0E-9;
    }

    public static final boolean mathNE(double v1, double v2) {
        return Math.abs(v1 - v2) >= 1.0E-9;
    }

    public static final boolean mathLT(double lv, double rv) {
        return rv - lv > 1.0E-9;
    }

    public static final boolean mathLE(double lv, double rv) {
        return rv - lv > 1.0E-9 || Math.abs(lv - rv) < 1.0E-9;
    }

    public static final boolean mathGT(double lv, double rv) {
        return lv - rv > 1.0E-9;
    }

    public static final boolean mathGE(double lv, double rv) {
        return lv - rv > 1.0E-9 || Math.abs(lv - rv) < 1.0E-9;
    }

    public static String formatDouble(double value) {
        return String.format(EPS_FORMAT, value);
    }

    public static final double convertPixelsToPoints(IDisplayServer idsSWT, double dOriginalHeight) {
        return dOriginalHeight * 72.0 / (double)idsSWT.getDpiResolution();
    }

    public static final int getQuadrant(double dAngle) {
        if ((dAngle -= (double)((int)dAngle / 360 * 360)) < 0.0) {
            dAngle += 360.0;
        }
        if (dAngle == 0.0) {
            return -1;
        }
        if (dAngle == 90.0) {
            return -2;
        }
        if (dAngle == 180.0) {
            return -3;
        }
        if (dAngle == 270.0) {
            return -4;
        }
        if (dAngle >= 0.0 && dAngle < 90.0) {
            return 1;
        }
        if (dAngle > 90.0 && dAngle < 180.0) {
            return 2;
        }
        if (dAngle > 180.0 && dAngle < 270.0) {
            return 3;
        }
        return 4;
    }

    public static boolean intersects(Polygon pg1, Polygon pg2) {
        if (pg1 != null) {
            return pg1.intersects(pg2);
        }
        return false;
    }

    public static void mergeFont(FontDefinition original, FontDefinition source) {
        if (source != null) {
            if (original.getAlignment() == null) {
                original.setAlignment(source.getAlignment());
            } else if (!original.getAlignment().isSetHorizontalAlignment() && source.getAlignment() != null) {
                original.getAlignment().setHorizontalAlignment(source.getAlignment().getHorizontalAlignment());
            }
            if (original.getName() == null) {
                original.setName(source.getName());
            }
            if (!original.isSetBold()) {
                original.setBold(source.isBold());
            }
            if (!original.isSetItalic()) {
                original.setItalic(source.isItalic());
            }
            if (!original.isSetRotation()) {
                original.setRotation(source.getRotation());
            }
            if (!original.isSetSize()) {
                original.setSize(source.getSize());
            }
            if (!original.isSetWordWrap()) {
                original.setWordWrap(source.isWordWrap());
            }
            if (!original.isSetUnderline()) {
                original.setUnderline(source.isUnderline());
            }
            if (!original.isSetStrikethrough()) {
                original.setStrikethrough(source.isStrikethrough());
            }
        }
    }

    public static String stringValue(Object value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public static Fill convertFill(Fill fill, double dValue, Fill fNegative) {
        if (dValue >= 0.0) {
            if (fill instanceof MultipleFill) {
                fill = goFactory.copyOf((ColorDefinition)((MultipleFill)fill).getFills().get(0));
            }
        } else if (fill instanceof MultipleFill) {
            fill = goFactory.copyOf((ColorDefinition)((MultipleFill)fill).getFills().get(1));
        } else if (fNegative != null) {
            fill = fNegative;
        }
        return fill;
    }

    public static Anchor transposeAnchor(Anchor an) throws IllegalArgumentException {
        if (an == null) {
            return null;
        }
        switch (an.getValue()) {
            case 0: {
                return Anchor.EAST_LITERAL;
            }
            case 4: {
                return Anchor.WEST_LITERAL;
            }
            case 2: {
                return Anchor.NORTH_LITERAL;
            }
            case 6: {
                return Anchor.SOUTH_LITERAL;
            }
            case 7: {
                return Anchor.SOUTH_EAST_LITERAL;
            }
            case 1: {
                return Anchor.NORTH_EAST_LITERAL;
            }
            case 5: {
                return Anchor.SOUTH_WEST_LITERAL;
            }
            case 3: {
                return Anchor.NORTH_WEST_LITERAL;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle().getString("exception.anchor.transpose"), new Object[]{an}));
    }

    public static TextAlignment transposeAlignment(TextAlignment ta) {
        if (ta == null) {
            return null;
        }
        HorizontalAlignment ha = ta.getHorizontalAlignment();
        VerticalAlignment va = ta.getVerticalAlignment();
        switch (ha.getValue()) {
            case 0: {
                ta.setVerticalAlignment(VerticalAlignment.BOTTOM_LITERAL);
                break;
            }
            case 2: {
                ta.setVerticalAlignment(VerticalAlignment.TOP_LITERAL);
                break;
            }
            case 1: {
                ta.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
            }
        }
        switch (va.getValue()) {
            case 2: {
                ta.setHorizontalAlignment(HorizontalAlignment.LEFT_LITERAL);
                break;
            }
            case 0: {
                ta.setHorizontalAlignment(HorizontalAlignment.RIGHT_LITERAL);
                break;
            }
            case 1: {
                ta.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            }
        }
        return ta;
    }

    public static int convertUnitTypeToCalendarConstant(ScaleUnitType unitType) {
        switch (unitType.getValue()) {
            case 3: {
                return 5;
            }
            case 2: {
                return 11;
            }
            case 1: {
                return 12;
            }
            case 5: {
                return 2;
            }
            case 0: {
                return 13;
            }
            case 4: {
                return 3;
            }
            case 6: {
                return 1;
            }
        }
        return -1;
    }

    public static int getSupportedMaxRowCount(RunTimeContext rtc) {
        int iMaxRowCount = 0;
        Object contextMaxRow = rtc.getState(CHART_MAX_ROW);
        if (contextMaxRow != null) {
            iMaxRowCount = ((Number)contextMaxRow).intValue();
        } else {
            String jvmMaxRow = SecurityUtil.getSysProp(CHART_MAX_ROW);
            if (jvmMaxRow != null) {
                try {
                    iMaxRowCount = Integer.parseInt(jvmMaxRow);
                }
                catch (NumberFormatException numberFormatException) {
                    iMaxRowCount = 0;
                }
            }
        }
        if (iMaxRowCount <= 0) {
            iMaxRowCount = 0;
        }
        return iMaxRowCount;
    }

    public static String[] getSupportedOutputFormats() throws ChartException {
        String[][] outputFormatArray = PluginSettings.instance().getRegisteredOutputFormats();
        String[] formats = new String[outputFormatArray.length];
        int i = 0;
        while (i < formats.length) {
            formats[i] = outputFormatArray[i][0];
            ++i;
        }
        return formats;
    }

    public static String[] getSupportedOutputDisplayNames() throws ChartException {
        String[][] outputFormatArray = PluginSettings.instance().getRegisteredOutputFormats();
        String[] formats = new String[outputFormatArray.length];
        int i = 0;
        while (i < formats.length) {
            formats[i] = outputFormatArray[i][1] == null ? outputFormatArray[i][0] : outputFormatArray[i][1];
            ++i;
        }
        return formats;
    }

    public static boolean isOutputFormatSupport(String output) throws ChartException {
        if (output == null || output.trim().length() == 0) {
            return false;
        }
        output = output.toUpperCase();
        String[] allTypes = ChartUtil.getSupportedOutputFormats();
        int i = 0;
        while (i < allTypes.length) {
            if (output.equals(allTypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isRightToLeftLocale(ULocale lcl) {
        String language;
        return lcl != null && ((language = lcl.getLanguage()).equals("he") || language.equals("iw") || language.equals("ar") || language.equals("fa") || language.equals("ur") || language.equals("yi") || language.equals("ji"));
    }

    public static boolean checkDoublePrecise(double dValue) {
        if (dValue - (double)((int)dValue) == 0.0) {
            return true;
        }
        String sValue = String.valueOf(dValue);
        if (sValue.length() < 8) {
            return true;
        }
        int iPoint = sValue.indexOf(46);
        int iZero = sValue.lastIndexOf("00000000");
        if (iZero >= iPoint) {
            return false;
        }
        int iNine = sValue.lastIndexOf("99999999");
        return iNine < iPoint;
    }

    public static double computeHeightOfOrthogonalAxisTitle(ChartWithAxes cm, IDisplayServer xs) {
        Bounds chartBounds = cm.getBlock().getBounds();
        Bounds titleBounds = cm.getTitle().getBounds();
        Bounds legendBounds = cm.getLegend().getBounds();
        int titleAnchor = cm.getTitle().getAnchor().getValue();
        int legendPosition = cm.getLegend().getPosition().getValue();
        if (titleAnchor == 0) {
            if (legendPosition == 0) {
                return (chartBounds.getHeight() + chartBounds.getTop() - legendBounds.getTop() - legendBounds.getHeight()) / 72.0 * (double)xs.getDpiResolution();
            }
            if (legendPosition == 1) {
                return (legendBounds.getTop() - titleBounds.getTop() - titleBounds.getHeight()) / 72.0 * (double)xs.getDpiResolution();
            }
            return (chartBounds.getHeight() + chartBounds.getTop() - titleBounds.getTop() - titleBounds.getHeight()) / 72.0 * (double)xs.getDpiResolution();
        }
        if (titleAnchor == 4) {
            if (legendPosition == 0) {
                return (titleBounds.getTop() - legendBounds.getTop() - legendBounds.getHeight()) / 72.0 * (double)xs.getDpiResolution();
            }
            if (legendPosition == 1) {
                return (legendBounds.getTop() - chartBounds.getTop()) / 72.0 * (double)xs.getDpiResolution();
            }
            return (titleBounds.getTop() - chartBounds.getTop()) / 72.0 * (double)xs.getDpiResolution();
        }
        if (legendPosition == 0) {
            return (chartBounds.getHeight() + chartBounds.getTop() - legendBounds.getTop() - legendBounds.getHeight()) / 72.0 * (double)xs.getDpiResolution();
        }
        if (legendPosition == 1) {
            return (legendBounds.getTop() - chartBounds.getTop()) / 72.0 * (double)xs.getDpiResolution();
        }
        return chartBounds.getHeight() / 72.0 * (double)xs.getDpiResolution();
    }

    public static String getGroupingUnitName(SeriesGrouping grouping) {
        if (grouping.getGroupType() == DataType.NUMERIC_LITERAL) {
            return null;
        }
        if (grouping.getGroupType() == DataType.DATE_TIME_LITERAL) {
            if (grouping.getGroupingUnit() == null) {
                return GroupingUnitType.SECONDS_LITERAL.getName();
            }
            return grouping.getGroupingUnit().getName();
        }
        if (grouping.getGroupType() == DataType.TEXT_LITERAL) {
            if (grouping.getGroupingUnit() == null || !GroupingUnitType.STRING_PREFIX_LITERAL.getName().equals(grouping.getGroupingUnit().getName())) {
                return GroupingUnitType.STRING_LITERAL.getName();
            }
            return grouping.getGroupingUnit().getName();
        }
        return null;
    }

    public static String removeInvalidSymbols(String expression) {
        return expression.replaceAll("\"", "").replaceAll("\\n", "").replaceAll(new String(new char[]{'\uffff'}), "").replaceAll("\\r", "");
    }

    public static String createValueSeriesRowFullExpression(Query orthQuery, SeriesDefinition orthSD, SeriesDefinition categorySD) throws ChartException {
        String str = orthQuery.getDefinition();
        if (ChartUtil.isConstantExpression(str)) {
            return str;
        }
        if (ChartUtil.isCubeRowExpression(str, true)) {
            return orthQuery.getDefinition();
        }
        return ChartUtil.getValueSeriesRowFullExpression(orthQuery, orthSD, categorySD);
    }

    public static boolean isCubeRowExpression(String expr, boolean hasOperation) {
        if (expr == null) {
            return false;
        }
        String regExp = hasOperation ? ".*\\Qdata[\"\\E.*\\Q\"]\\E.*" : "\\Qdata[\"\\E.*\\Q\"]\\E";
        return expr.matches(regExp);
    }

    public static boolean isConstantExpression(String expr) {
        if (expr == null) {
            return false;
        }
        return expr.matches("^[+-]?\\d*([\\.]?\\d*)?$");
    }

    public static String getValueSeriesFullExpression(Query orthQuery, SeriesDefinition orthoSD, SeriesDefinition categorySD) throws ChartException {
        String returnExpr = null;
        String fullAggExpr = ChartUtil.getFullAggregateExpression(orthoSD, categorySD, orthQuery);
        returnExpr = fullAggExpr == null ? orthQuery.getDefinition() : String.valueOf(orthQuery.getDefinition()) + "_" + fullAggExpr;
        return ChartUtil.removeInvalidSymbols(returnExpr);
    }

    public static String getValueSeriesRowFullExpression(Query orthQuery, SeriesDefinition orthoSD, SeriesDefinition categorySD) throws ChartException {
        String fullAggExpr = ChartUtil.getFullAggregateExpression(orthoSD, categorySD, orthQuery);
        if (fullAggExpr == null) {
            return orthQuery.getDefinition();
        }
        return ExpressionUtil.createRowExpression((String)ChartUtil.removeInvalidSymbols(String.valueOf(orthQuery.getDefinition()) + "_" + fullAggExpr));
    }

    public static String getFullAggregateExpression(SeriesDefinition orthoSD, SeriesDefinition categorySD, Query orthQuery) throws ChartException {
        String expr = ChartUtil.getAggregateFuncExpr(orthoSD, categorySD, orthQuery);
        if (expr == null) {
            return null;
        }
        expr = ChartUtil.createFullAggregateString(expr, ChartUtil.getAggFunParameters(orthoSD, categorySD, orthQuery));
        return expr;
    }

    public static String createFullAggregateString(String aggrFunc, Object[] aggrParameters) throws ChartException {
        if (aggrFunc == null) {
            return null;
        }
        String expr = aggrFunc;
        IAggregateFunction aFunc = PluginSettings.instance().getAggregateFunction(aggrFunc);
        int i = 0;
        while (i < aggrParameters.length && i < aFunc.getParametersCount()) {
            String param = aggrParameters[i] == null ? "" : (String)aggrParameters[i];
            expr = String.valueOf(expr) + "_" + param;
            ++i;
        }
        return expr;
    }

    public static String[] getAggFunParameters(SeriesDefinition orthSD, SeriesDefinition baseSD, Query orthQuery) {
        if (baseSD.getGrouping() != null && baseSD.getGrouping().isEnabled()) {
            SeriesGrouping grouping = orthSD.getGrouping();
            if (grouping.isEnabled()) {
                if (orthQuery != null && orthQuery.getGrouping() != null) {
                    return (String[])orthQuery.getGrouping().getAggregateParameters().toArray((Object[])new String[0]);
                }
                return (String[])grouping.getAggregateParameters().toArray((Object[])new String[0]);
            }
            return (String[])baseSD.getGrouping().getAggregateParameters().toArray((Object[])new String[0]);
        }
        if (orthQuery != null && orthQuery.getGrouping() != null) {
            return (String[])orthQuery.getGrouping().getAggregateParameters().toArray((Object[])new String[0]);
        }
        return (String[])orthSD.getGrouping().getAggregateParameters().toArray((Object[])new String[0]);
    }

    public static String getAggregateFunctionExpr(SeriesDefinition orthoSD, String strBaseAggExp, Query orthQuery) throws ChartException {
        IAggregateFunction aFunc;
        String strOrthoAgg = null;
        SeriesGrouping grouping = orthoSD.getGrouping();
        if (orthQuery != null && orthQuery.getGrouping() != null && orthQuery.getGrouping().isEnabled()) {
            strOrthoAgg = orthQuery.getGrouping().getAggregateExpression();
        } else if (grouping != null && grouping.isEnabled()) {
            strOrthoAgg = grouping.getAggregateExpression();
        }
        if (strBaseAggExp == null && strOrthoAgg != null && (aFunc = PluginSettings.instance().getAggregateFunction(strOrthoAgg)).getType() != 1) {
            strOrthoAgg = null;
        }
        if (strOrthoAgg == null || "".equals(strOrthoAgg)) {
            strOrthoAgg = strBaseAggExp;
        }
        return strOrthoAgg;
    }

    public static String getAggregateFuncExpr(SeriesDefinition orthSD, SeriesDefinition baseSD, Query orthQuery) throws ChartException {
        String strBaseAggExp = null;
        if (baseSD.getGrouping() != null && baseSD.getGrouping().isEnabled()) {
            strBaseAggExp = baseSD.getGrouping().getAggregateExpression();
        }
        if ((strBaseAggExp = ChartUtil.getAggregateFunctionExpr(orthSD, strBaseAggExp, orthQuery)) != null && strBaseAggExp.trim().length() == 0) {
            strBaseAggExp = null;
        }
        return strBaseAggExp;
    }

    public static boolean isMagicAggregate(String aggFunc) {
        return "Count".equals(aggFunc) || "DistinctCount".equals(aggFunc) || "Top".equals(aggFunc) || "TopPercent".equals(aggFunc) || "Bottom".equals(aggFunc) || "BottomPercent".equals(aggFunc) || "Rank".equals(aggFunc) || "PercentRank".equals(aggFunc);
    }

    private static void pruneInvisibleSedsFromEList(EList<SeriesDefinition> elSed) {
        Iterator itSed = elSed.iterator();
        while (itSed.hasNext()) {
            SeriesDefinition sed = (SeriesDefinition)itSed.next();
            Series ds = sed.getDesignTimeSeries();
            if (ds == null || ds.isVisible()) continue;
            itSed.remove();
        }
    }

    public static void pruneInvisibleSeries(Chart cm) {
        block4: {
            block3: {
                if (!(cm instanceof ChartWithAxes)) break block3;
                ChartWithAxes cmWithAxes = (ChartWithAxes)cm;
                Axis[] axBaseAxis = cmWithAxes.getBaseAxes();
                int j = 0;
                while (j < axBaseAxis.length) {
                    Axis axBase = axBaseAxis[j];
                    Axis[] axis = cmWithAxes.getOrthogonalAxes(axBase, true);
                    int i = 0;
                    while (i < axis.length) {
                        Axis ax = axis[i];
                        ChartUtil.pruneInvisibleSedsFromEList(ax.getSeriesDefinitions());
                        ++i;
                    }
                    ++j;
                }
                break block4;
            }
            if (!(cm instanceof ChartWithoutAxes)) break block4;
            ChartWithoutAxes cmNoAxes = (ChartWithoutAxes)cm;
            for (SeriesDefinition sedCata : cmNoAxes.getSeriesDefinitions()) {
                ChartUtil.pruneInvisibleSedsFromEList(sedCata.getSeriesDefinitions());
            }
        }
    }

    public static double alignWithInt(double dValue, boolean bForced) {
        int power = (int)Math.log10(dValue);
        if (power < 16) {
            long lValue = Math.round(dValue);
            if (bForced || ChartUtil.mathEqual(dValue, lValue)) {
                dValue = lValue;
            }
            return dValue;
        }
        double dPower = Math.pow(10.0, power - 14);
        long lValue = Math.round(dValue / dPower);
        return (double)lValue * dPower;
    }

    public static EList<SeriesDefinition> getBaseSeriesDefinitions(Chart chart) {
        if (chart instanceof ChartWithAxes) {
            return ((Axis)((ChartWithAxes)chart).getAxes().get(0)).getSeriesDefinitions();
        }
        if (chart instanceof ChartWithoutAxes) {
            return ((ChartWithoutAxes)chart).getSeriesDefinitions();
        }
        return null;
    }

    public static List<SeriesDefinition> getAllOrthogonalSeriesDefinitions(Chart chart) {
        ArrayList<SeriesDefinition> seriesList = new ArrayList<SeriesDefinition>();
        if (chart instanceof ChartWithAxes) {
            EList<Axis> axisList = ((Axis)((ChartWithAxes)chart).getAxes().get(0)).getAssociatedAxes();
            int i = 0;
            while (i < axisList.size()) {
                seriesList.addAll((Collection<SeriesDefinition>)((Axis)axisList.get(i)).getSeriesDefinitions());
                ++i;
            }
        } else if (chart instanceof ChartWithoutAxes) {
            seriesList.addAll((Collection<SeriesDefinition>)((SeriesDefinition)((ChartWithoutAxes)chart).getSeriesDefinitions().get(0)).getSeriesDefinitions());
        }
        return seriesList;
    }

    public static String createRegularRowExpression(String expression, boolean hasOperation) {
        if (expression == null) {
            return null;
        }
        String regularExpr = "row\\[\"" + ChartUtil.escapeRegexpSymbol(expression) + "\"\\]";
        if (hasOperation) {
            regularExpr = ".*" + regularExpr + ".*";
        }
        return regularExpr;
    }

    private static String escapeRegexpSymbol(String expr) {
        char[] specialSymbol = new char[]{'$', '(', ')', '*', '+', '.', '[', '?', '^', '{', '|', '}', '\\'};
        ArrayList<Character> specialList = new ArrayList<Character>();
        int i = 0;
        while (i < specialSymbol.length) {
            specialList.add(Character.valueOf(specialSymbol[i]));
            ++i;
        }
        StringBuffer sb = new StringBuffer(expr);
        int i2 = 0;
        while (i2 < sb.length()) {
            int index = specialList.indexOf(Character.valueOf(sb.charAt(i2)));
            if (index >= 0) {
                if (((Character)specialList.get(index)).charValue() == '\\') {
                    sb.insert(i2++, '\\');
                    sb.insert(i2++, '\\');
                }
                sb.insert(i2++, '\\');
            }
            ++i2;
        }
        return sb.toString();
    }

    public static String[] getValueSeriesExpressions(Chart cm) {
        LinkedHashSet<String> valueExprs = new LinkedHashSet<String>();
        List<SeriesDefinition> orthSDs = ChartUtil.getAllOrthogonalSeriesDefinitions(cm);
        for (SeriesDefinition sd : orthSDs) {
            Series s = sd.getDesignTimeSeries();
            EList<Query> queries = s.getDataDefinition();
            for (Query q : queries) {
                if (q.getDefinition() == null || "".equals(q.getDefinition().trim())) continue;
                valueExprs.add(q.getDefinition());
            }
        }
        return valueExprs.toArray(new String[valueExprs.size()]);
    }

    public static String[] getYOptoinalExpressions(Chart cm) {
        LinkedHashSet<String> yOptionalExprs = new LinkedHashSet<String>();
        List<SeriesDefinition> orthSDs = ChartUtil.getAllOrthogonalSeriesDefinitions(cm);
        for (SeriesDefinition sd : orthSDs) {
            if (sd.getQuery() == null || sd.getQuery().getDefinition() == null || "".equals(sd.getQuery().getDefinition())) continue;
            yOptionalExprs.add(sd.getQuery().getDefinition());
        }
        return yOptionalExprs.toArray(new String[yOptionalExprs.size()]);
    }

    public static String[] getCategoryExpressions(Chart cm) {
        LinkedHashSet<String> categoryExprs = new LinkedHashSet<String>();
        EList<SeriesDefinition> baseSDs = ChartUtil.getBaseSeriesDefinitions(cm);
        for (SeriesDefinition sd : baseSDs) {
            EList<Query> dds = sd.getDesignTimeSeries().getDataDefinition();
            for (Query q : dds) {
                if (q.getDefinition() == null || "".equals(q.getDefinition())) continue;
                categoryExprs.add(q.getDefinition());
            }
        }
        return categoryExprs.toArray(new String[categoryExprs.size()]);
    }

    public static int compareVersion(String va, String vb) {
        String[] vas = va.split("\\.");
        String[] vbs = vb.split("\\.");
        ArrayList<String> vaList = new ArrayList<String>();
        int i = 0;
        while (i < vas.length) {
            vaList.add(vas[i].trim().equals("") ? "0" : vas[i]);
            ++i;
        }
        ArrayList<String> vbList = new ArrayList<String>();
        int i2 = 0;
        while (i2 < vbs.length) {
            vbList.add(vbs[i2].trim().equals("") ? "0" : vbs[i2]);
            ++i2;
        }
        if (vas.length < vbs.length) {
            i2 = vas.length;
            while (i2 < vbs.length) {
                vaList.add("0");
                ++i2;
            }
        } else if (vas.length > vbs.length) {
            i2 = vbs.length;
            while (i2 < vas.length) {
                vbList.add("0");
                ++i2;
            }
        }
        i2 = 0;
        while (i2 < vaList.size()) {
            int b;
            int a = Integer.valueOf((String)vaList.get(i2));
            if (a != (b = Integer.valueOf((String)vbList.get(i2)).intValue())) {
                return a - b;
            }
            ++i2;
        }
        return 0;
    }

    public static String[] getStringTokens(String str) {
        if (str.indexOf("\\,") < 0) {
            return str.split(",");
        }
        ArrayList<String> list = new ArrayList<String>();
        char[] charArray = (String.valueOf(str) + ",").toCharArray();
        int startIndex = 0;
        int i = 0;
        while (i < charArray.length) {
            char c = charArray[i];
            if (c == ',' && charArray[i - 1] != '\\' && i > 0) {
                list.add(str.substring(startIndex, i).replaceAll("\\\\,", ",").trim());
                startIndex = i + 1;
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String getNewSampleData(AxisType axisType, int index) {
        if (axisType.equals((Object)AxisType.DATE_TIME_LITERAL)) {
            String dsRepresentation = "01/05/2000,02/01/2000,04/12/2000,03/12/2000,02/29/2000";
            String[] strTok = ChartUtil.getStringTokens(dsRepresentation);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < strTok.length) {
                String strDataElement = strTok[i];
                SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
                try {
                    Date dateElement = sdf.parse(strDataElement);
                    long value = i * index % 2 == 0 ? dateElement.getTime() + dateElement.getTime() * (long)index / 10L : dateElement.getTime() - dateElement.getTime() * (long)index / 10L;
                    dateElement.setTime(value);
                    sb.append(sdf.format(dateElement));
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
                if (i < strTok.length - 1) {
                    sb.append(",");
                }
                ++i;
            }
            return sb.toString();
        }
        if (axisType.equals((Object)AxisType.TEXT_LITERAL)) {
            return "'A','B','C','D','E'";
        }
        String dsRepresentation = "6,4,12,8,10";
        String[] strTok = ChartUtil.getStringTokens(dsRepresentation);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < strTok.length) {
            String strDataElement = strTok[i];
            NumberFormat nf = NumberFormat.getNumberInstance();
            try {
                Number numberElement = nf.parse(strDataElement);
                double value = numberElement.doubleValue() * (double)(index + 1) + (double)(i * index);
                sb.append((int)value);
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            if (i < strTok.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        if (index > 0) {
            return sb.reverse().toString();
        }
        return sb.toString();
    }

    public static String getNewAncillarySampleData(Vector<SeriesDefinition> vOSD) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < vOSD.size()) {
            sb.append(vOSD.get(i).getDesignTimeSeries().getSeriesIdentifier());
            if (i < vOSD.size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        return sb.toString();
    }

    public static Chart getChartFromSeries(Series series) {
        Chart cm = null;
        EObject e = series.eContainer();
        int loop_limit = 10;
        while (e != null && loop_limit-- > 0) {
            if (e instanceof Chart) {
                cm = (Chart)e;
                break;
            }
            e = e.eContainer();
        }
        return cm;
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static boolean containsYOptionalGrouping(Chart chart) {
        SeriesDefinition os;
        boolean YOG = false;
        List<SeriesDefinition> sds = ChartUtil.getAllOrthogonalSeriesDefinitions(chart);
        if (sds.size() > 0 && (os = sds.get(0)) != null && os.getQuery() != null && os.getQuery().getDefinition() != null && os.getQuery().getDefinition().length() != 0) {
            YOG = true;
        }
        return YOG;
    }

    public static boolean XOR(boolean b0, boolean b1) {
        return !b0 && b1 || b0 && !b1;
    }

    public static <T extends EObject> T eCopy(T src) {
        return (T)EcoreUtil.copy(src);
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static void reviseVersion(Chart chartModel) {
        if (chartModel.getVersion().equals("2.5.0")) {
            return;
        }
        chartModel.setVersion("2.5.0");
    }

    public static boolean isDataEmpty(RunTimeContext rtc) {
        Boolean bDataEmpty = rtc.getState(RunTimeContext.StateKey.DATA_EMPTY_KEY);
        if (bDataEmpty == null) {
            bDataEmpty = false;
        }
        return bDataEmpty;
    }

    public static boolean hasMultipleYAxes(Chart cm) {
        return cm.getDimension() != ChartDimension.THREE_DIMENSIONAL_LITERAL && cm instanceof ChartWithAxes && ((Axis)((ChartWithAxes)cm).getAxes().get(0)).getAssociatedAxes().size() > 1;
    }

    public static boolean isStudyLayout(Chart cm) {
        return ChartUtil.hasMultipleYAxes(cm) && ((ChartWithAxes)cm).isStudyLayout();
    }

    public static Axis getAxisFromSeries(Series series) {
        EObject e = series.eContainer();
        int loop_limit = 10;
        while (e != null && loop_limit-- > 0) {
            if (e instanceof Axis) {
                return (Axis)e;
            }
            e = e.eContainer();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Cache<T, V> {
        private Map<T, V> hm = new HashMap<T, V>();
        protected ULocale locale;

        public Cache(ULocale lcl) {
            this.locale = lcl;
        }

        public V get(T key) {
            V value = this.hm.get(key);
            if (value == null) {
                value = this.newValue(key);
                this.hm.put(key, value);
            }
            return value;
        }

        protected abstract V newValue(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheDateFormat
    extends Cache<Integer, IDateFormatWrapper> {
        public CacheDateFormat(ULocale lcl) {
            super(lcl);
        }

        @Override
        protected IDateFormatWrapper newValue(Integer iDateTimeUnit) {
            return DateFormatWrapperFactory.getPreferredDateFormat(iDateTimeUnit, this.locale);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheDecimalFormat
    extends Cache<String, DecimalFormat> {
        public CacheDecimalFormat(ULocale lcl) {
            super(lcl);
        }

        @Override
        protected DecimalFormat newValue(String pattern) {
            return new DecimalFormat(pattern, new DecimalFormatSymbols(this.locale));
        }
    }
}

