/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.io.BufferedRandomAccessInputStream;
import org.eclipse.mat.parser.io.SimpleBufferedRandomAccessInputStream;

public class PositionInputStream
extends FilterInputStream
implements DataInput {
    private final byte[] readBuffer = new byte[32];
    private long position = 0L;

    public PositionInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        int res = super.read();
        if (res != -1) {
            ++this.position;
        }
        return res;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int res = super.read(b, off, len);
        if (res != -1) {
            this.position += (long)res;
        }
        return res;
    }

    public long skip(long n) throws IOException {
        long res = super.skip(n);
        this.position += res;
        return res;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readLimit) {
        throw new UnsupportedOperationException(Messages.PositionInputStream_mark);
    }

    public void reset() {
        throw new UnsupportedOperationException(Messages.PositionInputStream_reset);
    }

    public final int skipBytes(int n) throws IOException {
        int total = 0;
        int cur = 0;
        while (total < n && (cur = (int)this.skip(n - total)) > 0) {
            total += cur;
        }
        return total;
    }

    public final int skipBytes(long n) throws IOException {
        int total = 0;
        int cur = 0;
        while ((long)total < n && (cur = (int)this.skip(n - (long)total)) > 0) {
            total += cur;
        }
        return total;
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        int n = 0;
        while (n < len) {
            int count = this.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
    }

    public long position() {
        return this.position;
    }

    public void seek(long pos) throws IOException {
        if (this.in instanceof BufferedRandomAccessInputStream) {
            this.position = pos;
            ((BufferedRandomAccessInputStream)this.in).seek(pos);
        } else if (this.in instanceof SimpleBufferedRandomAccessInputStream) {
            this.position = pos;
            ((SimpleBufferedRandomAccessInputStream)this.in).seek(pos);
        } else {
            throw new UnsupportedOperationException(Messages.PositionInputStream_seek);
        }
    }

    public final int readUnsignedByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        ++this.position;
        return ch;
    }

    public final int readInt() throws IOException {
        this.readFully(this.readBuffer, 0, 4);
        return PositionInputStream.readInt(this.readBuffer, 0);
    }

    public final long readLong() throws IOException {
        this.readFully(this.readBuffer, 0, 8);
        return PositionInputStream.readLong(this.readBuffer, 0);
    }

    public boolean readBoolean() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        ++this.position;
        return ch != 0;
    }

    public byte readByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        ++this.position;
        return (byte)ch;
    }

    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.position += 2L;
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.position += 2L;
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.position += 2L;
        return (ch1 << 8) + (ch2 << 0);
    }

    public int readIntArray(int[] a) throws IOException {
        byte[] b;
        int len = a.length * 4;
        byte[] byArray = b = len > this.readBuffer.length ? new byte[len] : this.readBuffer;
        if (this.read(b, 0, len) != len) {
            throw new IOException();
        }
        int ii = 0;
        while (ii < a.length) {
            a[ii] = PositionInputStream.readInt(b, ii * 4);
            ++ii;
        }
        return a.length;
    }

    private static final int readInt(byte[] b, int offset) throws IOException {
        int ch1 = b[offset] & 0xFF;
        int ch2 = b[offset + 1] & 0xFF;
        int ch3 = b[offset + 2] & 0xFF;
        int ch4 = b[offset + 3] & 0xFF;
        if ((ch1 | ch2 | ch3 | ch4) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public int readLongArray(long[] a) throws IOException {
        byte[] b;
        int len = a.length * 8;
        byte[] byArray = b = len > this.readBuffer.length ? new byte[len] : this.readBuffer;
        if (this.read(b, 0, len) != len) {
            throw new IOException();
        }
        int ii = 0;
        while (ii < a.length) {
            a[ii] = PositionInputStream.readLong(b, ii * 8);
            ++ii;
        }
        return a.length;
    }

    private static final long readLong(byte[] b, int offset) {
        return ((long)b[offset] << 56) + ((long)(b[offset + 1] & 0xFF) << 48) + ((long)(b[offset + 2] & 0xFF) << 40) + ((long)(b[offset + 3] & 0xFF) << 32) + ((long)(b[offset + 4] & 0xFF) << 24) + (long)((b[offset + 5] & 0xFF) << 16) + (long)((b[offset + 6] & 0xFF) << 8) + (long)((b[offset + 7] & 0xFF) << 0);
    }
}

