/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.birt.core.archive.compound.ArchiveConstants;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFileV1;
import org.eclipse.birt.core.archive.compound.ArchiveFileV2;
import org.eclipse.birt.core.archive.compound.BlockManager;
import org.eclipse.birt.core.archive.compound.IArchiveFile;

public class ArchiveFile
implements IArchiveFile,
ArchiveConstants {
    protected String archiveName;
    protected String systemId;
    protected IArchiveFile af;

    public ArchiveFile(String fileName, String mode) throws IOException {
        this(null, fileName, mode);
    }

    public ArchiveFile(String systemId, String fileName, String mode) throws IOException {
        if (fileName == null || fileName.length() == 0) {
            throw new IOException("The file name is null or empty string.");
        }
        File fd = new File(fileName);
        this.archiveName = fileName = fd.getCanonicalPath();
        this.systemId = systemId;
        if ("r".equals(mode)) {
            this.openArchiveForReading();
        } else if ("rw+".equals(mode)) {
            this.openArchiveForAppending();
        } else {
            this.af = new ArchiveFileV2(systemId, fileName, mode);
        }
    }

    protected void openArchiveForReading() throws IOException {
        RandomAccessFile rf = new RandomAccessFile(this.archiveName, "r");
        try {
            long magicTag = rf.readLong();
            if (magicTag != 90504964424259L) {
                this.af = new ArchiveFileV1(this.archiveName, rf);
            } else {
                ArchiveFileV2 v2 = new ArchiveFileV2(this.archiveName, rf, "r");
                this.upgradeSystemId(v2);
                this.af = v2;
            }
        }
        catch (IOException ex) {
            rf.close();
            throw ex;
        }
    }

    protected void openArchiveForAppending() throws IOException {
        RandomAccessFile rf = new RandomAccessFile(this.archiveName, "rw");
        if (rf.length() == 0L) {
            this.af = new ArchiveFileV2(this.archiveName, rf, "rw");
        } else {
            try {
                long magicTag = rf.readLong();
                if (magicTag == 90504964424259L) {
                    this.af = new ArchiveFileV2(this.archiveName, rf, "rw+");
                } else {
                    rf.close();
                    this.upgradeArchiveV1();
                    this.af = new ArchiveFileV2(this.archiveName, "rw+");
                }
                this.upgradeSystemId(this.af);
            }
            catch (IOException ex) {
                rf.close();
                throw ex;
            }
        }
    }

    public String getName() {
        return this.archiveName;
    }

    public String getDependId() {
        return this.af.getDependId();
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void close() throws IOException {
        if (this.isArchiveFileAvailable(this.af)) {
            this.af.close();
            this.af = null;
        }
    }

    public void setCacheSize(int cacheSize) {
        if (this.isArchiveFileAvailable(this.af)) {
            this.af.setCacheSize(cacheSize);
        }
    }

    public int getUsedCache() {
        if (this.isArchiveFileAvailable(this.af)) {
            return this.af.getUsedCache();
        }
        return 0;
    }

    public static int getTotalUsedCache() {
        return BlockManager.totalCacheSize;
    }

    public void saveAs(String fileName) throws IOException {
        ArchiveFileV2 file = new ArchiveFileV2(this.systemId, fileName, "rw");
        try {
            List entries = this.listEntries("/");
            ListIterator iter = entries.listIterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                ArchiveEntry tgt = file.createEntry(name);
                ArchiveEntry src = this.getEntry(name);
                this.copyEntry(src, tgt);
            }
        }
        finally {
            file.close();
        }
    }

    public void save() throws IOException {
        if (this.isArchiveFileAvailable(this.af)) {
            if (this.af instanceof ArchiveFileV2) {
                ((ArchiveFileV2)this.af).save();
            } else {
                this.af.flush();
            }
        } else {
            throw new IOException("The archive file has been closed. System ID: " + this.systemId);
        }
    }

    private void copyEntry(ArchiveEntry src, ArchiveEntry tgt) throws IOException {
        byte[] b = new byte[4096];
        long length = src.getLength();
        long pos = 0L;
        while (pos < length) {
            int size = src.read(pos, b, 0, 4096);
            tgt.write(pos, b, 0, size);
            pos += (long)size;
        }
    }

    public synchronized void flush() throws IOException {
        if (!this.isArchiveFileAvailable(this.af)) {
            throw new IOException("The archive file has been closed. System ID: " + this.systemId);
        }
        this.af.flush();
    }

    public synchronized void refresh() throws IOException {
        if (!this.isArchiveFileAvailable(this.af)) {
            throw new IOException("The archive file has been closed. System ID: " + this.systemId);
        }
        this.af.refresh();
    }

    public synchronized boolean exists(String name) {
        if (this.isArchiveFileAvailable(this.af)) {
            return this.af.exists(name);
        }
        return false;
    }

    public synchronized ArchiveEntry getEntry(String name) throws IOException {
        if (this.isArchiveFileAvailable(this.af)) {
            return this.af.getEntry(name);
        }
        throw new IOException("Can not get entry named " + name + " because the archive file has been closed. System ID: " + this.systemId);
    }

    public synchronized List listEntries(String namePattern) {
        if (this.isArchiveFileAvailable(this.af)) {
            return this.af.listEntries(namePattern);
        }
        return Collections.EMPTY_LIST;
    }

    public synchronized ArchiveEntry createEntry(String name) throws IOException {
        if (this.isArchiveFileAvailable(this.af)) {
            return this.af.createEntry(name);
        }
        throw new IOException("Can not create entry named " + name + "because the archive file has been closed. System ID: " + this.systemId);
    }

    public synchronized boolean removeEntry(String name) throws IOException {
        if (this.isArchiveFileAvailable(this.af)) {
            return this.af.removeEntry(name);
        }
        throw new IOException("Can not remove entry named " + name + " because the archive file has been closed. System ID: " + this.systemId);
    }

    public Object lockEntry(ArchiveEntry entry) throws IOException {
        return this.af.lockEntry(entry);
    }

    public void unlockEntry(Object locker) throws IOException {
        if (!this.isArchiveFileAvailable(this.af)) {
            throw new IOException("The archive file has been closed. System ID: " + this.systemId);
        }
        this.af.unlockEntry(locker);
    }

    private void upgradeArchiveV1() throws IOException {
        ArchiveFileV1 reader = new ArchiveFileV1(this.archiveName);
        try {
            File tempFile = File.createTempFile("temp_", ".archive");
            tempFile.deleteOnExit();
            ArchiveFile writer = new ArchiveFile(tempFile.getAbsolutePath(), "rwt");
            List streams = reader.listEntries("");
            for (String name : streams) {
                ArchiveEntry src = reader.getEntry(name);
                ArchiveEntry tgt = writer.createEntry(name);
                this.copyEntry(src, tgt);
            }
            writer.saveAs(this.archiveName);
            writer.close();
        }
        finally {
            reader.close();
        }
    }

    private void upgradeSystemId(IArchiveFile file) {
        if (this.systemId == null) {
            this.systemId = file.getSystemId();
        }
    }

    private boolean isArchiveFileAvailable(IArchiveFile af) {
        return af != null;
    }
}

