/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.rcp.actions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.mat.ui.rcp.Messages;
import org.eclipse.mat.ui.rcp.RCPPlugin;
import org.eclipse.mat.util.RegistryReader;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class OpenPreferenceAction
extends Action {
    private static final Set<String> ALLOWED_IDS = new HashSet<String>(Arrays.asList("org.eclipse.ui.net.NetPreferences", "org.eclipse.update.internal.ui.preferences.MainPreferencePage"));
    PreferenceRegistry reg;

    public OpenPreferenceAction() {
        super(Messages.OpenPreferenceAction_Preferences);
    }

    public void run() {
        if (this.reg == null) {
            this.reg = new PreferenceRegistry();
        }
        PreferenceManager manager = new PreferenceManager('/');
        for (Node node : this.reg.delegates()) {
            manager.addToRoot((IPreferenceNode)node);
        }
        PreferenceDialog dialog = new PreferenceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), manager);
        dialog.open();
    }

    private class Node
    extends PreferenceNode {
        private IConfigurationElement configElement;

        public Node(String id, IConfigurationElement configurationElement) {
            super(id);
            this.configElement = configurationElement;
        }

        public String getLabelText() {
            return this.configElement.getAttribute("name");
        }

        public void createPage() {
            IWorkbenchPreferencePage page;
            try {
                page = (IWorkbenchPreferencePage)this.configElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            page.init(PlatformUI.getWorkbench());
            if (this.getLabelImage() != null) {
                page.setImageDescriptor(this.getImageDescriptor());
            }
            page.setTitle(this.getLabelText());
            this.setPage((IPreferencePage)page);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PreferenceRegistry
    extends RegistryReader<Node> {
        public PreferenceRegistry() {
            this.init(RCPPlugin.getDefault().getExtensionTracker(), "org.eclipse.ui.preferencePages");
        }

        protected Node createDelegate(IConfigurationElement configElement) throws CoreException {
            String id = configElement.getAttribute("id");
            return ALLOWED_IDS.contains(id) ? new Node(id, configElement) : null;
        }

        protected void removeDelegate(Node delegate) {
        }
    }
}

