/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.impl.chart;

import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.CallBackValueImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.impl.LabelBlockImpl;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mat.impl.chart.LabelRenderScript;
import org.eclipse.mat.impl.chart.Messages;
import org.eclipse.mat.impl.chart.StorageUnitRenderScript;
import org.eclipse.mat.query.IResultPie;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.Units;

public class ChartBuilder {
    private static final String CHARS = "abcdefghijklmnopqrstuvwxyz";
    private static final int[] COLOR_REST = new int[]{220, 220, 220};
    private static final int[][] COLORS = new int[][]{{96, 127, 143}, {98, 146, 147}, {110, 138, 79}, {140, 101, 87}, {123, 96, 114}, {101, 129, 120}, {148, 132, 75}, {150, 103, 110}, {152, 173, 183}, {154, 185, 185}, {162, 180, 141}, {181, 156, 147}, {170, 152, 164}, {156, 175, 168}, {186, 176, 139}, {188, 157, 162}, {68, 105, 125}, {21, 101, 112}, {85, 118, 48}, {119, 74, 57}, {100, 68, 89}, {73, 108, 96}, {129, 110, 44}, {132, 76, 84}};

    public static final Chart create(IResultPie pie, boolean isInteractive) {
        int ii;
        float fontSize = "macosx".equals(Platform.getOS()) ? 10.0f : 8.0f;
        List slices = pie.getSlices();
        String[] labels = new String[slices.size()];
        if (isInteractive) {
            ii = 0;
            while (ii < labels.length) {
                labels[ii] = ((IResultPie.Slice)slices.get(ii)).getLabel();
                ++ii;
            }
        } else {
            ii = 0;
            while (ii < labels.length) {
                labels[ii] = ChartBuilder.withPrefix(ii, ((IResultPie.Slice)slices.get(ii)).getLabel());
                ++ii;
            }
        }
        double total = 0.0;
        double[] values = new double[slices.size()];
        int ii2 = 0;
        while (ii2 < values.length) {
            values[ii2] = ((IResultPie.Slice)slices.get(ii2)).getValue();
            total += values[ii2];
            ++ii2;
        }
        ChartWithoutAxes chart = ChartWithoutAxesImpl.create();
        if (isInteractive) {
            chart.setScript(StorageUnitRenderScript.class.getName());
        } else {
            chart.setScript(LabelRenderScript.class.getName());
        }
        chart.getTitle().setVisible(false);
        long t = new Double(total).longValue();
        LabelBlock label = (LabelBlock)LabelBlockImpl.create();
        label.getLabel().getCaption().setValue(MessageUtil.format((String)Messages.ChartBuilder_Total, (Object[])new Object[]{Units.Storage.of((long)t).format(t)}));
        label.getLabel().getCaption().getFont().setSize(fontSize);
        label.getLabel().getCaption().getFont().setBold(true);
        label.setAnchor(Anchor.SOUTH_LITERAL);
        chart.getPlot().add((Block)label);
        if (isInteractive) {
            chart.getLegend().setVisible(false);
        } else {
            chart.getLegend().setVisible(true);
            chart.getLegend().setBackground((Fill)ColorDefinitionImpl.WHITE());
            chart.getLegend().getText().getFont().setSize(fontSize);
        }
        Plot p = chart.getPlot();
        p.setBackground((Fill)ColorDefinitionImpl.WHITE());
        p.getClientArea().setBackground((Fill)ColorDefinitionImpl.WHITE());
        chart.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Series seLabels = SeriesImpl.create();
        seLabels.setDataSet((DataSet)TextDataSetImpl.create((Object)labels));
        SeriesDefinition sd = SeriesDefinitionImpl.create();
        sd.getSeries().add((Object)seLabels);
        chart.getSeriesDefinitions().add((Object)sd);
        EList entries = sd.getSeriesPalette().getEntries();
        entries.clear();
        int index = 0;
        while (index < slices.size() - 1) {
            int[] color = COLORS[index % COLORS.length];
            ColorDefinition defn = ColorDefinitionImpl.create((int)color[0], (int)color[1], (int)color[2]);
            entries.add((Object)defn);
            ++index;
        }
        int[] lastColor = ((IResultPie.Slice)slices.get(slices.size() - 1)).getContext() == null ? COLOR_REST : COLORS[(slices.size() - 1) % COLORS.length];
        entries.add((Object)ColorDefinitionImpl.create((int)lastColor[0], (int)lastColor[1], (int)lastColor[2]));
        PieSeries pieSeries = (PieSeries)PieSeriesImpl.create();
        pieSeries.setDataSet((DataSet)NumberDataSetImpl.create((Object)values));
        pieSeries.setLabelPosition(Position.OUTSIDE_LITERAL);
        pieSeries.getLabel().getCaption().getFont().setSize(fontSize);
        pieSeries.setExplosion(5);
        if (isInteractive) {
            pieSeries.getTriggers().add((Object)TriggerImpl.create((TriggerCondition)TriggerCondition.ONCLICK_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.CALL_BACK_LITERAL, (ActionValue)CallBackValueImpl.create((String)"click"))));
            pieSeries.getTriggers().add((Object)TriggerImpl.create((TriggerCondition)TriggerCondition.ONMOUSEOVER_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.CALL_BACK_LITERAL, (ActionValue)CallBackValueImpl.create((String)"tooltip"))));
        }
        SeriesDefinition sdBase = SeriesDefinitionImpl.create();
        sd.getSeriesDefinitions().add((Object)sdBase);
        sdBase.getSeries().add((Object)pieSeries);
        return chart;
    }

    public static final String withPrefix(int index, String label) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        int d = index / CHARS.length();
        if (d > 0) {
            buf.append(CHARS.charAt(d % CHARS.length()));
        }
        buf.append(CHARS.charAt(index % CHARS.length()));
        buf.append(")  ");
        buf.append(label);
        return buf.toString();
    }
}

