/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.browser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryHistory {
    private static final int HISTORY_LIMIT = 50;
    private static final String FILE_NAME = String.valueOf(MemoryAnalyserPlugin.getDefault().getStateLocation().toOSString()) + File.separator + "commandHistory.ser";
    private static LinkedList<String> history = null;

    public static synchronized void addQuery(String queryString) {
        if (history == null) {
            QueryHistory.loadHistory();
        }
        Iterator iter = history.iterator();
        while (iter.hasNext()) {
            String item = (String)iter.next();
            if (!queryString.equals(item)) continue;
            iter.remove();
            break;
        }
        history.addFirst(queryString);
        while (history.size() > 50) {
            history.removeLast();
        }
        QueryHistory.saveHistory();
    }

    public static synchronized List<String> getHistoryEntries() {
        if (history == null) {
            QueryHistory.loadHistory();
        }
        return new ArrayList<String>(history);
    }

    private static void loadHistory() {
        File file = new File(FILE_NAME);
        if (file.exists()) {
            try {
                ObjectInputStream oin = new ObjectInputStream(new FileInputStream(file));
                history = (LinkedList)oin.readObject();
                oin.close();
            }
            catch (Exception ignore) {
                MemoryAnalyserPlugin.log(ignore);
            }
        }
        if (history == null) {
            history = new LinkedList();
        }
    }

    private static void saveHistory() {
        try {
            if (!history.isEmpty()) {
                ObjectOutputStream oout = new ObjectOutputStream(new FileOutputStream(FILE_NAME));
                oout.writeObject(history);
                oout.close();
            } else {
                File file = new File(FILE_NAME);
                file.delete();
            }
        }
        catch (IOException ignore) {
            MemoryAnalyserPlugin.log(ignore);
        }
    }
}

