/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.actions;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mat.query.registry.CategoryDescriptor;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.snapshot.ImageHelper;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class OpenIconAssistAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private Shell shell;

    public void run() {
        this.openIconAssist(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public void run(IAction action) {
        this.openIconAssist(this.window);
    }

    private void openIconAssist(IWorkbenchWindow window) {
        this.shell = window.getShell();
        PopupTable table = new PopupTable(this.shell, 131072);
        Rectangle rectangle = this.shell.getBounds();
        int x = rectangle.x + rectangle.width - 315;
        int y = rectangle.y + rectangle.height - rectangle.height / 2;
        table.open(new Rectangle(x, y, 305, rectangle.height / 2));
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public static class Handler
    extends AbstractHandler {
        public Object execute(ExecutionEvent executionEvent) {
            new OpenIconAssistAction().run();
            return null;
        }
    }

    private static class Icon {
        private ImageDescriptor image;
        private String description;

        public Icon(ImageDescriptor image, String description) {
            this.setImageDescriptor(image);
            this.setDescription(description);
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public ImageDescriptor getImageDescriptor() {
            return this.image;
        }

        public void setImageDescriptor(ImageDescriptor image) {
            this.image = image;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IconAssist {
        public List<Icon> icons = new LinkedList<Icon>();

        public IconAssist() {
            this.icons.add(new Icon(null, Messages.OpenIconAssistAction_HeapObjects));
            this.icons.add(new Icon(MemoryAnalyserPlugin.getImageDescriptor("icons/heapobjects/class.gif"), Messages.OpenIconAssistAction_InstancesGroupedByClass));
            this.icons.add(new Icon(ImageHelper.getImageDescriptor(0), Messages.OpenIconAssistAction_ClassObject));
            this.icons.add(new Icon(ImageHelper.getImageDescriptor(2), Messages.OpenIconAssistAction_ClassLoaderObject));
            this.icons.add(new Icon(ImageHelper.getImageDescriptor(3), Messages.OpenIconAssistAction_ArrayObject));
            this.icons.add(new Icon(ImageHelper.getImageDescriptor(1), Messages.OpenIconAssistAction_OtherObject));
            this.icons.add(new Icon(ImageHelper.getImageDescriptor(9), Messages.OpenIconAssistAction_Package));
            this.icons.add(new Icon(null, Messages.OpenIconAssistAction_IndicatorsAdded));
            this.icons.add(new Icon(ImageHelper.getInboundImageDescriptor(1), Messages.OpenIconAssistAction_ReferenceAbove));
            this.icons.add(new Icon(ImageHelper.getOutboundImageDescriptor(1), Messages.OpenIconAssistAction_ReferenceBelow));
            this.icons.add(new Icon(ImageHelper.decorate(1, MemoryAnalyserPlugin.getImageDescriptor("icons/decorations/gc_root.gif")), Messages.OpenIconAssistAction_ThisObjectIsGCRoot));
            this.icons.add(new Icon(null, Messages.OpenIconAssistAction_QueryViews));
            this.icons.addAll(this.getQueryIcons());
            this.icons.add(new Icon(null, Messages.OpenIconAssistAction_Others));
            this.icons.add(new Icon(MemoryAnalyserPlugin.getImageDescriptor("icons/query_browser.gif"), Messages.OpenIconAssistAction_ExecuteQuery));
        }

        private List<Icon> getQueryIcons() {
            LinkedList<CategoryDescriptor> categories = new LinkedList<CategoryDescriptor>();
            categories.add(QueryRegistry.instance().getRootCategory());
            ArrayList<Icon> answer = new ArrayList<Icon>();
            while (!categories.isEmpty()) {
                CategoryDescriptor cat = (CategoryDescriptor)categories.removeFirst();
                categories.addAll(cat.getSubCategories());
                URL icon = null;
                boolean isFirst = true;
                boolean itemsWithDifferentIcons = false;
                for (QueryDescriptor query : cat.getQueries()) {
                    URL thisIcon = query.getIcon();
                    if (isFirst) {
                        icon = thisIcon;
                    } else if (thisIcon != null && !thisIcon.equals(icon) || thisIcon == null && icon != null) {
                        itemsWithDifferentIcons = true;
                        break;
                    }
                    isFirst = false;
                }
                if (itemsWithDifferentIcons) {
                    for (QueryDescriptor query : cat.getQueries()) {
                        icon = query.getIcon();
                        if (icon == null) continue;
                        String categoryName = cat.getFullName();
                        String label = categoryName != null ? String.valueOf(categoryName) + " / " + query.getName() : query.getName();
                        answer.add(new Icon(MemoryAnalyserPlugin.getDefault().getImageDescriptor(icon), label));
                    }
                    continue;
                }
                if (icon == null) continue;
                answer.add(new Icon(MemoryAnalyserPlugin.getDefault().getImageDescriptor(icon), cat.getFullName()));
            }
            Collections.sort(answer, new Comparator<Icon>(){

                @Override
                public int compare(Icon o1, Icon o2) {
                    return o1.description.compareTo(o2.description);
                }
            });
            return answer;
        }

        public List<Icon> getIcons() {
            return this.icons;
        }
    }

    private static class IconsLabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        Font boldFont;

        public IconsLabelProvider(Font defaultFont) {
            FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)defaultFont);
            fontDescriptor = fontDescriptor.setStyle(1);
            this.boldFont = fontDescriptor.createFont((Device)Display.getDefault());
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Icon icon = (Icon)element;
            switch (columnIndex) {
                case 0: {
                    return MemoryAnalyserPlugin.getDefault().getImage(icon.getImageDescriptor());
                }
                case 1: {
                    return null;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Icon icon = (Icon)element;
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return icon.getDescription();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            this.boldFont.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Font getFont(Object element) {
            return ((Icon)element).getImageDescriptor() == null ? this.boldFont : null;
        }
    }

    private static class PopupTable {
        private Table table;
        Shell shell;

        public PopupTable(Shell parent, int style) {
            this.shell = new Shell(parent, PopupTable.checkStyle(style));
            TableViewer viewer = new TableViewer((Composite)this.shell, 832);
            this.table = viewer.getTable();
            TableColumn tc1 = new TableColumn(this.table, 0x1000000);
            TableColumn tc2 = new TableColumn(this.table, 16384);
            tc1.setWidth(25);
            tc2.setWidth(270);
            this.table.setLinesVisible(true);
            viewer.setContentProvider((IContentProvider)new TableContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)new IconsLabelProvider(viewer.getTable().getFont()));
            viewer.setInput(new IconAssist().getIcons());
            this.shell.addListener(27, new Listener(){

                public void handleEvent(Event e) {
                    PopupTable.this.shell.setVisible(false);
                }
            });
            this.shell.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    Rectangle shellSize = PopupTable.this.shell.getClientArea();
                    PopupTable.this.table.setSize(shellSize.width, shellSize.height);
                }
            });
        }

        private static int checkStyle(int style) {
            int mask = 0x6000000;
            return style & mask;
        }

        public void open(Rectangle rect) {
            this.shell.setBounds(new Rectangle(rect.x, rect.y, rect.width + 10, rect.height));
            this.shell.open();
            this.table.setFocus();
            Display display = this.shell.getDisplay();
            while (!this.shell.isDisposed() && this.shell.isVisible()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }

    private static class TableContentProvider
    implements IStructuredContentProvider {
        Object[] elements;

        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.elements = newInput instanceof Collection ? ((Collection)newInput).toArray() : (Object[])newInput;
        }
    }
}

