/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

public class ReferenceQuery {
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("java\\.lang\\.ref\\..*Reference");
    private static final Pattern QUEUE_PATTERN = Pattern.compile("java\\.lang\\.ref\\..*ReferenceQueue.*");

    public static IResult execute(String className, ISnapshot snapshot, String labelHistogramReferenced, String labelHistogramRetained, IProgressListener listener) throws SnapshotException {
        listener.subTask(Messages.ReferenceQuery_Msg_ComputingReferentSet);
        ArrayInt instanceSet = new ArrayInt();
        SetInt referentSet = new SetInt();
        Collection<IClass> classes = snapshot.getClassesByName(Pattern.compile(className), true);
        if (classes == null) {
            throw new SnapshotException(MessageUtil.format((String)Messages.ReferenceQuery_ErrorMsg_NoMatchingClassesFound, (Object[])new Object[]{className}));
        }
        for (IClass clazz : classes) {
            int[] objs = clazz.getObjectIds();
            instanceSet.addAll(objs);
            int ii = 0;
            while (ii < objs.length) {
                IInstance obj = (IInstance)snapshot.getObject(objs[ii]);
                ObjectReference ref = ReferenceQuery.getReferent(obj);
                if (ref != null) {
                    referentSet.add(ref.getObjectId());
                }
                ++ii;
            }
            if (!listener.isCanceled()) continue;
            throw new IProgressListener.OperationCanceledException();
        }
        return ReferenceQuery.execute(instanceSet, referentSet, snapshot, labelHistogramReferenced, labelHistogramRetained, listener);
    }

    public static CompositeResult execute(ArrayInt instanceSet, SetInt referentSet, ISnapshot snapshot, String labelHistogramReferenced, String labelHistogramRetained, IProgressListener listener) throws SnapshotException {
        CompositeResult result = new CompositeResult(new IResult[0]);
        Histogram histogram = snapshot.getHistogram(referentSet.toArray(), listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        histogram.setLabel(labelHistogramReferenced);
        result.addResult(labelHistogramReferenced, (IResult)histogram);
        listener.subTask(Messages.ReferenceQuery_Msg_ComputingRetainedSet);
        int[] retainedSet = snapshot.getRetainedSet(instanceSet.toArray(), new String[]{"referent"}, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        histogram = snapshot.getHistogram(retainedSet, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        histogram.setLabel(labelHistogramRetained);
        result.addResult(labelHistogramRetained, (IResult)histogram);
        return result;
    }

    public static ObjectReference getReferent(IInstance instance) throws SnapshotException {
        Field field = instance.getField("referent");
        if (field != null) {
            return (ObjectReference)field.getValue();
        }
        if (REFERENCE_PATTERN.matcher(instance.getClazz().getName()).matches() || "java.lang.ref.Finalizer".equals(instance.getClazz().getName())) {
            int[] outbounds;
            ISnapshot snapshot = instance.getSnapshot();
            int[] nArray = outbounds = snapshot.getOutboundReferentIds(instance.getObjectId());
            int n = outbounds.length;
            int n2 = 0;
            while (n2 < n) {
                int outboundId = nArray[n2];
                IClass outboundType = snapshot.getClassOf(outboundId);
                if (instance.getClazz().getObjectId() != outboundId && !ReferenceQuery.isReferenceType(outboundType) && !ReferenceQuery.isReferenceQueueType(outboundType)) {
                    long address = snapshot.mapIdToAddress(outboundId);
                    return new ObjectReference(snapshot, address);
                }
                ++n2;
            }
            return null;
        }
        return null;
    }

    private static boolean isReferenceType(IClass clazz) throws SnapshotException {
        return REFERENCE_PATTERN.matcher(clazz.getName()).matches() || "java.lang.ref.Finalizer".equals(clazz.getName()) || clazz.doesExtend("java.lang.ref.Reference");
    }

    private static boolean isReferenceQueueType(IClass clazz) throws SnapshotException {
        return QUEUE_PATTERN.matcher(clazz.getName()).matches() || clazz.doesExtend("java.lang.ref.ReferenceQueue");
    }
}

