/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.inspections.ReferenceQuery;
import org.eclipse.mat.inspections.collections.CollectionUtil;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.refined.RefinedResultBuilder;
import org.eclipse.mat.query.refined.RefinedTable;
import org.eclipse.mat.query.refined.TotalsRow;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.ExcludedReferencesDescriptor;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.PieFactory;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.Units;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CommandName(value="component_report")
@HelpUrl(value="/org.eclipse.mat.ui.help/reference/inspections/component_report.html")
public class ComponentReportQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;

    public IResult execute(IProgressListener listener) throws Exception {
        SectionSpec componentReport = new SectionSpec(MessageUtil.format((String)Messages.ComponentReportQuery_ComponentReport, (Object[])new Object[]{this.objects.getLabel()}));
        Ticks ticks = new Ticks(listener, componentReport.getName(), 31);
        int[] retained = this.calculateRetainedSize(ticks);
        ticks.tick();
        Histogram histogram = this.snapshot.getHistogram(retained, ticks);
        ticks.tick();
        long totalSize = this.snapshot.getHeapSize(retained);
        ticks.tick();
        this.addOverview(componentReport, totalSize, retained, histogram, ticks);
        SectionSpec possibleWaste = new SectionSpec(Messages.ComponentReportQuery_PossibleMemoryWaste);
        componentReport.add((Spec)possibleWaste);
        try {
            this.addDuplicateStrings(possibleWaste, histogram, ticks);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            this.addEmptyCollections(possibleWaste, totalSize, histogram, ticks);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            this.addCollectionFillRatios(possibleWaste, totalSize, histogram, ticks);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        SectionSpec miscellaneous = new SectionSpec(Messages.ComponentReportQuery_Miscellaneous);
        componentReport.add((Spec)miscellaneous);
        try {
            this.addSoftReferenceStatistic(miscellaneous, histogram, ticks);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            this.addFinalizerStatistic(miscellaneous, retained, ticks);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            this.addHashMapsCollisionRatios(miscellaneous, histogram, ticks);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        ticks.delegate.done();
        return componentReport;
    }

    private int[] calculateRetainedSize(Ticks ticks) throws SnapshotException {
        int[] retained = null;
        ArrayList<ExcludedReferencesDescriptor> excludes = new ArrayList<ExcludedReferencesDescriptor>();
        this.addExcludes(excludes, "java.lang.ref.Finalizer", "referent");
        this.addExcludes(excludes, "java.lang.ref.WeakReference", "referent");
        this.addExcludes(excludes, "java.lang.ref.SoftReference", "referent");
        retained = excludes.isEmpty() ? this.snapshot.getRetainedSet(this.objects.getIds(ticks), ticks) : this.snapshot.getRetainedSet(this.objects.getIds(ticks), excludes.toArray(new ExcludedReferencesDescriptor[0]), (IProgressListener)ticks);
        return retained;
    }

    private void addExcludes(List<ExcludedReferencesDescriptor> excludes, String className, String ... fields) throws SnapshotException {
        Collection<IClass> finalizer = this.snapshot.getClassesByName(className, true);
        if (finalizer != null) {
            ArrayInt objectIds = new ArrayInt();
            for (IClass c : finalizer) {
                objectIds.addAll(c.getObjectIds());
            }
            excludes.add(new ExcludedReferencesDescriptor(objectIds.toArray(), fields));
        }
    }

    private void addOverview(SectionSpec componentReport, long totalSize, int[] retained, Histogram histogram, Ticks listener) throws Exception {
        SectionSpec overview = new SectionSpec(Messages.ComponentReportQuery_Overview);
        overview.set("html.show_heading", Boolean.FALSE.toString());
        this.addOverviewNumbers(retained, histogram, overview, totalSize);
        listener.tick();
        this.addOverviewPie(overview, totalSize);
        listener.tick();
        this.addTopConsumer(overview, retained, listener);
        listener.tick();
        this.addRetainedSet(overview, histogram);
        listener.tick();
        componentReport.add((Spec)overview);
    }

    private void addOverviewNumbers(int[] retained, Histogram histogram, SectionSpec overview, long totalSize) {
        int noOfClasses = histogram.getClassHistogramRecords().size();
        int noOfObjects = retained.length;
        int noOfClassLoaders = histogram.getClassLoaderHistogramRecords().size();
        StringBuilder buf = new StringBuilder();
        buf.append(String.valueOf(Messages.ComponentReportQuery_Size) + " <strong>").append(Units.Storage.of((long)totalSize).format(totalSize)).append("</strong> ");
        buf.append(String.valueOf(Messages.ComponentReportQuery_Classes) + " <strong>").append(Units.Plain.of((long)noOfClasses).format((long)noOfClasses)).append("</strong> ");
        buf.append(String.valueOf(Messages.ComponentReportQuery_Objects) + " <strong>").append(Units.Plain.of((long)noOfObjects).format((long)noOfObjects)).append("</strong> ");
        buf.append(String.valueOf(Messages.ComponentReportQuery_ClassLoader) + " <strong>").append(Units.Plain.of((long)noOfClassLoaders).format((long)noOfClassLoaders)).append("</strong>");
        QuerySpec spec = new QuerySpec(Messages.ComponentReportQuery_Details, (IResult)new TextResult(buf.toString(), true));
        spec.set("html.show_heading", Boolean.FALSE.toString());
        overview.add((Spec)spec);
    }

    private void addOverviewPie(SectionSpec overview, long totalSize) {
        PieFactory pie = new PieFactory(this.snapshot);
        pie.addSlice(-1, this.objects.getLabel(), totalSize, totalSize);
        QuerySpec spec = new QuerySpec(Messages.ComponentReportQuery_Distribution, (IResult)pie.build());
        spec.set("html.show_heading", Boolean.FALSE.toString());
        overview.add((Spec)spec);
    }

    private void addTopConsumer(SectionSpec componentReport, int[] retained, IProgressListener listener) throws Exception {
        IResult result = SnapshotQuery.lookup("top_consumers_html", this.snapshot).set("objects", retained).execute(listener);
        QuerySpec topConsumers = new QuerySpec(Messages.ComponentReportQuery_TopConsumers);
        topConsumers.set("html.separate_file", Boolean.TRUE.toString());
        topConsumers.set("html.collapsed", Boolean.FALSE.toString());
        topConsumers.setResult(result);
        componentReport.add((Spec)topConsumers);
    }

    private void addRetainedSet(SectionSpec componentReport, Histogram histogram) {
        QuerySpec retainedSet = new QuerySpec(Messages.ComponentReportQuery_RetainedSet);
        retainedSet.set("html.separate_file", Boolean.TRUE.toString());
        retainedSet.setResult((IResult)histogram);
        componentReport.add((Spec)retainedSet);
    }

    private void addDuplicateStrings(SectionSpec componentReport, Histogram histogram, Ticks listener) throws Exception {
        for (ClassHistogramRecord record : histogram.getClassHistogramRecords()) {
            if (!"char[]".equals(record.getLabel())) continue;
            int[] objectIds = record.getObjectIds();
            if (objectIds.length > 100000) {
                int[] copy = new int[100000];
                System.arraycopy(objectIds, 0, copy, 0, copy.length);
                objectIds = copy;
            }
            RefinedResultBuilder builder = SnapshotQuery.lookup("group_by_value", this.snapshot).set("objects", objectIds).refine(listener);
            builder.setFilter(1, ">=10");
            builder.setInlineRetainedSizeCalculation(true);
            RefinedTable table = (RefinedTable)builder.build();
            TotalsRow totals = new TotalsRow();
            table.calculateTotals(table.getRows(), totals, (IProgressListener)listener);
            StringBuilder comment = new StringBuilder();
            comment.append(MessageUtil.format((String)Messages.ComponentReportQuery_Msg_FoundOccurrences, (Object[])new Object[]{table.getRowCount(), totals.getLabel(2)}));
            comment.append("<p>" + Messages.ComponentReportQuery_TopElementsInclude + "<ul>");
            int rowId = 0;
            while (rowId < table.getRowCount() && rowId < 5) {
                Object row = table.getRow(rowId);
                String value = table.getFormattedColumnValue(row, 0);
                if (value.length() > 50) {
                    value = String.valueOf(value.substring(0, 50)) + "...";
                }
                String size = table.getFormattedColumnValue(row, 3);
                comment.append("<li>").append(table.getFormattedColumnValue(row, 1));
                comment.append(" x <strong>").append(value).append("</strong> ");
                comment.append(MessageUtil.format((String)Messages.ComponentReportQuery_Label_Bytes, (Object[])new Object[]{size})).append("</li>");
                ++rowId;
            }
            comment.append("</ul>");
            SectionSpec duplicateStrings = new SectionSpec(Messages.ComponentReportQuery_DuplicateStrings);
            componentReport.add((Spec)duplicateStrings);
            QuerySpec spec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(comment.toString(), true));
            spec.set("rendering.pattern", "overview_details");
            duplicateStrings.add((Spec)spec);
            spec = new QuerySpec(Messages.ComponentReportQuery_Histogram);
            spec.setResult((IResult)table);
            duplicateStrings.add((Spec)spec);
            listener.tick();
            break;
        }
    }

    private void addEmptyCollections(SectionSpec componentReport, long totalSize, Histogram histogram, Ticks listener) throws Exception {
        long threshold = totalSize / 20L;
        SectionSpec overview = new SectionSpec(Messages.ComponentReportQuery_EmptyCollections);
        StringBuilder comment = new StringBuilder();
        SectionSpec collectionbySizeSpec = new SectionSpec(Messages.ComponentReportQuery_Details);
        collectionbySizeSpec.set("html.collapsed", Boolean.TRUE.toString());
        HashMapIntObject metadata = new HashMapIntObject();
        for (CollectionUtil.Info info : CollectionUtil.getKnownCollections(this.snapshot)) {
            Collection<IClass> classes;
            if (!info.hasSize() || (classes = this.snapshot.getClassesByName(info.getClassName(), true)) == null) continue;
            for (IClass clasz : classes) {
                metadata.put(clasz.getObjectId(), (Object)info);
            }
        }
        for (ClassHistogramRecord record : histogram.getClassHistogramRecords()) {
            if (!metadata.containsKey(record.getClassId())) continue;
            IClass clazz = (IClass)this.snapshot.getObject(record.getClassId());
            RefinedResultBuilder builder = SnapshotQuery.lookup("collections_grouped_by_size", this.snapshot).set("objects", record.getObjectIds()).refine(listener);
            builder.setInlineRetainedSizeCalculation(true);
            RefinedTable refinedTable = (RefinedTable)builder.build();
            int count = refinedTable.getRowCount();
            int rowId = 0;
            while (rowId < count && rowId < 10) {
                Object row = refinedTable.getRow(rowId);
                int collectionSize = (Integer)refinedTable.getColumnValue(row, 0);
                if (collectionSize == 0) {
                    long size = Math.abs((Long)refinedTable.getColumnValue(row, 3));
                    if (size <= threshold) break;
                    int numberOfObjects = (Integer)refinedTable.getColumnValue(row, 1);
                    String retainedSize = refinedTable.getFormattedColumnValue(row, 3);
                    if (comment.length() == 0) {
                        comment.append(String.valueOf(Messages.ComponentReportQuery_DetectedEmptyCollections) + "<ul>");
                    }
                    comment.append("<li>");
                    comment.append(MessageUtil.format((String)Messages.ComponentReportQuery_Msg_InstancesRetainBytes, (Object[])new Object[]{numberOfObjects, clazz.getName(), retainedSize}));
                    comment.append("</li>");
                    break;
                }
                ++rowId;
            }
            QuerySpec bySizeSpec = new QuerySpec(clazz.getName());
            bySizeSpec.setResult((IResult)refinedTable);
            collectionbySizeSpec.add((Spec)bySizeSpec);
            listener.tick();
        }
        if (collectionbySizeSpec.getChildren().isEmpty()) {
            return;
        }
        if (comment.length() == 0) {
            comment.append(Messages.ComponentReportQuery_Msg_NoExcessiveEmptyCollectionsFound);
        } else {
            comment.append("</ul>");
        }
        QuerySpec spec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(comment.toString(), true));
        spec.set("rendering.pattern", "overview_details");
        overview.add((Spec)spec);
        overview.add((Spec)collectionbySizeSpec);
        componentReport.add((Spec)overview);
    }

    private void addCollectionFillRatios(SectionSpec componentReport, long totalSize, Histogram histogram, Ticks listener) throws Exception {
        long threshold = totalSize / 20L;
        SectionSpec overview = new SectionSpec(Messages.ComponentReportQuery_CollectionFillRatios);
        StringBuilder comment = new StringBuilder();
        SectionSpec detailsSpec = new SectionSpec(Messages.ComponentReportQuery_Details);
        detailsSpec.set("html.collapsed", Boolean.TRUE.toString());
        HashMapIntObject metadata = new HashMapIntObject();
        for (CollectionUtil.Info info : CollectionUtil.getKnownCollections(this.snapshot)) {
            Collection<IClass> classes;
            if (!info.hasSize() || !info.hasBackingArray() || (classes = this.snapshot.getClassesByName(info.getClassName(), true)) == null) continue;
            for (IClass clasz : classes) {
                metadata.put(clasz.getObjectId(), (Object)info);
            }
        }
        for (ClassHistogramRecord record : histogram.getClassHistogramRecords()) {
            if (!metadata.containsKey(record.getClassId())) continue;
            IClass clazz = (IClass)this.snapshot.getObject(record.getClassId());
            RefinedResultBuilder builder = SnapshotQuery.lookup("collection_fill_ratio", this.snapshot).set("objects", record.getObjectIds()).refine(listener);
            builder.setInlineRetainedSizeCalculation(true);
            RefinedTable refinedTable = (RefinedTable)builder.build();
            int count = refinedTable.getRowCount();
            int rowId = 0;
            while (rowId < count) {
                Object row = refinedTable.getRow(rowId);
                double fillRatio = (Double)refinedTable.getColumnValue(row, 0);
                if (fillRatio > 0.0 && fillRatio < 0.21) {
                    long size = Math.abs((Long)refinedTable.getColumnValue(row, 3));
                    if (size <= threshold) break;
                    int numberOfObjects = (Integer)refinedTable.getColumnValue(row, 1);
                    String retainedSize = refinedTable.getFormattedColumnValue(row, 3);
                    if (comment.length() == 0) {
                        comment.append(String.valueOf(Messages.ComponentReportQuery_Msg_DetectedCollectionFillRatios) + "<ul>");
                    }
                    comment.append("<li>");
                    comment.append(MessageUtil.format((String)Messages.ComponentReportQuery_Msg_InstancesRetainBytes, (Object[])new Object[]{numberOfObjects, clazz.getName(), retainedSize}));
                    comment.append("</li>");
                    break;
                }
                ++rowId;
            }
            QuerySpec spec = new QuerySpec(clazz.getName());
            spec.setResult((IResult)refinedTable);
            detailsSpec.add((Spec)spec);
            listener.tick();
        }
        if (detailsSpec.getChildren().isEmpty()) {
            return;
        }
        if (comment.length() == 0) {
            comment.append(Messages.ComponentReportQuery_Msg_NoLowFillRatiosFound);
        } else {
            comment.append("</ul>");
        }
        QuerySpec commentSpec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(comment.toString(), true));
        commentSpec.set("rendering.pattern", "overview_details");
        overview.add((Spec)commentSpec);
        overview.add((Spec)detailsSpec);
        componentReport.add((Spec)overview);
    }

    private void addHashMapsCollisionRatios(SectionSpec componentReport, Histogram histogram, Ticks listener) throws Exception {
        SectionSpec overview = new SectionSpec(Messages.ComponentReportQuery_MapCollisionRatios);
        StringBuilder comment = new StringBuilder();
        SectionSpec detailsSpec = new SectionSpec(Messages.ComponentReportQuery_Details);
        detailsSpec.set("html.collapsed", Boolean.TRUE.toString());
        HashMapIntObject<CollectionUtil.Info> metadata = CollectionUtil.getKnownMaps(this.snapshot);
        for (ClassHistogramRecord record : histogram.getClassHistogramRecords()) {
            if (!metadata.containsKey(record.getClassId())) continue;
            IClass clazz = (IClass)this.snapshot.getObject(record.getClassId());
            int[] objectIds = record.getObjectIds();
            if (objectIds.length > 20000) {
                int[] copy = new int[20000];
                System.arraycopy(objectIds, 0, copy, 0, copy.length);
                objectIds = copy;
            }
            RefinedResultBuilder builder = SnapshotQuery.lookup("map_collision_ratio", this.snapshot).set("objects", objectIds).refine(listener);
            builder.setInlineRetainedSizeCalculation(true);
            RefinedTable refinedTable = (RefinedTable)builder.build();
            int count = refinedTable.getRowCount();
            int rowId = 0;
            while (rowId < count) {
                Object row = refinedTable.getRow(rowId);
                double collisionRato = (Double)refinedTable.getColumnValue(row, 0);
                if (collisionRato > 0.79) {
                    int numberOfObjects = (Integer)refinedTable.getColumnValue(row, 1);
                    String retainedSize = refinedTable.getFormattedColumnValue(row, 3);
                    if (comment.length() == 0) {
                        comment.append(String.valueOf(Messages.ComponentReportQuery_Msg_DetectedCollisionRatios) + "<ul>");
                    }
                    comment.append("<li>");
                    comment.append(MessageUtil.format((String)Messages.ComponentReportQuery_Msg_InstancesRetainBytes, (Object[])new Object[]{numberOfObjects, clazz.getName(), retainedSize}));
                    comment.append("</li>");
                    break;
                }
                ++rowId;
            }
            QuerySpec spec = new QuerySpec(clazz.getName());
            spec.setResult((IResult)refinedTable);
            detailsSpec.add((Spec)spec);
            listener.tick();
        }
        if (detailsSpec.getChildren().isEmpty()) {
            return;
        }
        if (comment.length() == 0) {
            comment.append(Messages.ComponentReportQuery_Msg_NoCollisionRatiosFound);
        } else {
            comment.append("</ul>");
        }
        QuerySpec commentSpec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(comment.toString(), true));
        commentSpec.set("rendering.pattern", "overview_details");
        overview.add((Spec)commentSpec);
        overview.add((Spec)detailsSpec);
        componentReport.add((Spec)overview);
    }

    private void addSoftReferenceStatistic(SectionSpec componentReport, Histogram histogram, Ticks ticks) throws SnapshotException {
        Object object;
        Collection<IClass> classes = this.snapshot.getClassesByName("java.lang.ref.SoftReference", true);
        if (classes == null) {
            this.addEmptyResult(componentReport, Messages.ComponentReportQuery_SoftReferenceStatistics, Messages.ComponentReportQuery_Msg_NoSoftReferencesFound);
            return;
        }
        SetInt softRefClassIds = new SetInt(classes.size());
        for (IClass c : classes) {
            softRefClassIds.add(c.getObjectId());
        }
        ArrayList<ClassHistogramRecord> softRefs = new ArrayList<ClassHistogramRecord>();
        long numObjects = 0L;
        long heapSize = 0L;
        ArrayInt instanceSet = new ArrayInt();
        SetInt referentSet = new SetInt();
        for (ClassHistogramRecord record : histogram.getClassHistogramRecords()) {
            if (!softRefClassIds.contains(record.getClassId())) continue;
            softRefs.add(record);
            numObjects += record.getNumberOfObjects();
            heapSize += record.getUsedHeapSize();
            instanceSet.addAll(record.getObjectIds());
            object = record.getObjectIds();
            int n = ((int[])object).length;
            int n2 = 0;
            while (n2 < n) {
                int objectId = object[n2];
                IInstance obj = (IInstance)this.snapshot.getObject(objectId);
                ObjectReference ref = ReferenceQuery.getReferent(obj);
                if (ref != null) {
                    referentSet.add(ref.getObjectId());
                }
                ++n2;
            }
        }
        if (instanceSet.isEmpty()) {
            this.addEmptyResult(componentReport, Messages.ComponentReportQuery_SoftReferenceStatistics, Messages.ComponentReportQuery_Msg_NoAliveSoftReferences);
            return;
        }
        Histogram softRefHistogram = new Histogram(Messages.ComponentReportQuery_HistogramOfSoftReferences, softRefs, null, numObjects, heapSize, 0L);
        CompositeResult referents = ReferenceQuery.execute(instanceSet, referentSet, this.snapshot, Messages.SoftReferenceStatQuery_Label_Referenced, Messages.SoftReferenceStatQuery_Label_Retained, ticks);
        StringBuilder comment = new StringBuilder();
        comment.append(MessageUtil.format((String)Messages.ComponentReportQuery_Msg_SoftReferencesFound, (Object[])new Object[]{instanceSet.size(), referentSet.size()}));
        Histogram onlySoftlyReachable = (Histogram)((CompositeResult.Entry)referents.getResultEntries().get(1)).getResult();
        numObjects = 0L;
        heapSize = 0L;
        object = onlySoftlyReachable.getClassHistogramRecords().iterator();
        while (object.hasNext()) {
            ClassHistogramRecord r = (ClassHistogramRecord)object.next();
            numObjects += r.getNumberOfObjects();
            heapSize += r.getUsedHeapSize();
        }
        comment.append(MessageUtil.format((String)Messages.ComponentReportQuery_Msg_SoftReferencesRetained, (Object[])new Object[]{numObjects, Units.Storage.of((long)heapSize).format(heapSize)}));
        SectionSpec overview = new SectionSpec(Messages.ComponentReportQuery_SoftReferenceStatistics);
        QuerySpec commentSpec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(comment.toString(), true));
        commentSpec.set("rendering.pattern", "overview_details");
        overview.add((Spec)commentSpec);
        QuerySpec child = new QuerySpec(softRefHistogram.getLabel(), (IResult)softRefHistogram);
        child.set("derived_data_column", "_default_=" + RetainedSizeDerivedData.APPROXIMATE.getCode());
        overview.add((Spec)child);
        for (CompositeResult.Entry entry : referents.getResultEntries()) {
            overview.add((Spec)new QuerySpec(entry.getName(), entry.getResult()));
        }
        componentReport.add((Spec)overview);
    }

    private void addFinalizerStatistic(SectionSpec componentReport, int[] retained, Ticks ticks) throws SnapshotException {
        Collection<IClass> classes = this.snapshot.getClassesByName("java.lang.ref.Finalizer", true);
        if (classes == null) {
            this.addEmptyResult(componentReport, Messages.ComponentReportQuery_FinalizerStatistics, Messages.ComponentReportQuery_Msg_NoFinalizerObjects);
            return;
        }
        SetInt retainedSet = new SetInt(retained.length / 100 * 110);
        int ii = 0;
        while (ii < retained.length) {
            retainedSet.add(retained[ii]);
            ++ii;
        }
        ArrayInt finalizers = new ArrayInt();
        for (IClass c : classes) {
            int[] nArray = c.getObjectIds();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int referentId;
                int objectId = nArray[n2];
                IInstance obj = (IInstance)this.snapshot.getObject(objectId);
                ObjectReference ref = ReferenceQuery.getReferent(obj);
                if (ref != null && retainedSet.contains(referentId = ref.getObjectId())) {
                    finalizers.add(referentId);
                }
                ++n2;
            }
        }
        if (finalizers.isEmpty()) {
            this.addEmptyResult(componentReport, Messages.ComponentReportQuery_FinalizerStatistics, Messages.ComponentReportQuery_Msg_NoFinalizerFound);
            return;
        }
        SectionSpec overview = new SectionSpec(Messages.ComponentReportQuery_FinalizerStatistics);
        StringBuilder comment = new StringBuilder();
        comment.append(MessageUtil.format((String)Messages.ComponentReportQuery_Msg_TotalFinalizerMethods, (Object[])new Object[]{finalizers.size()}));
        QuerySpec commentSpec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(comment.toString(), true));
        commentSpec.set("rendering.pattern", "overview_details");
        overview.add((Spec)commentSpec);
        Histogram histogram = this.snapshot.getHistogram(finalizers.toArray(), ticks);
        histogram.setLabel(Messages.ComponentReportQuery_HistogramFinalizeMethod);
        overview.add((Spec)new QuerySpec(histogram.getLabel(), (IResult)histogram));
        componentReport.add((Spec)overview);
    }

    private void addEmptyResult(SectionSpec report, String sectionLabel, String message) {
        SectionSpec section = new SectionSpec(sectionLabel);
        QuerySpec commentSpec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(message, true));
        commentSpec.set("rendering.pattern", "overview_details");
        section.add((Spec)commentSpec);
        report.add((Spec)section);
    }

    private static class Ticks
    implements IProgressListener {
        IProgressListener delegate;

        public Ticks(IProgressListener delegate, String task, int totalTicks) {
            this.delegate = delegate;
            this.delegate.beginTask(task, totalTicks);
        }

        public void tick() {
            this.delegate.worked(1);
        }

        public void beginTask(String name, int totalWork) {
            this.delegate.subTask(name);
        }

        public void subTask(String name) {
            this.delegate.subTask(name);
        }

        public void done() {
        }

        public boolean isCanceled() {
            return this.delegate.isCanceled();
        }

        public void sendUserMessage(IProgressListener.Severity severity, String message, Throwable exception) {
            this.delegate.sendUserMessage(severity, message, exception);
        }

        public void setCanceled(boolean value) {
            this.delegate.setCanceled(true);
        }

        public void worked(int work) {
        }
    }
}

