/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.util.ArrayList;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.results.ListResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="heap_dump_overview")
@Category(value="__hidden__")
public class HeapDumpInfoQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();

    public IResult execute(IProgressListener listener) throws Exception {
        SnapshotInfo info = this.snapshot.getSnapshotInfo();
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        ArrayList<TextEntry> entries = new ArrayList<TextEntry>(6);
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_UsedHeapDump, this.getUsedHeapInMb(info.getUsedHeapSize())));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_NumObjects, numberFormatter.format((long)info.getNumberOfObjects()).toString()));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_NumClasses, numberFormatter.format((long)info.getNumberOfClasses()).toString()));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_NumClassLoaders, numberFormatter.format((long)info.getNumberOfClassLoaders()).toString()));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_NumGCRoots, numberFormatter.format((long)info.getNumberOfGCRoots()).toString()));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_IdentifierSize, this.getSize(info.getIdentifierSize())));
        return new ListResult(TextEntry.class, entries, new String[]{"propertyName", "propertyValue"});
    }

    private String getUsedHeapInMb(long usedHeapSize) {
        double roundedHeapSize = Math.round(usedHeapSize / 10000L);
        return new DecimalFormat("#,##0.0 M").format(roundedHeapSize / 100.0);
    }

    private String getSize(int identifierSize) {
        switch (identifierSize) {
            case 0: {
                return null;
            }
            case 4: {
                return Messages.HeapDumpInfoQuery_32bit;
            }
            case 8: {
                return Messages.HeapDumpInfoQuery_64bit;
            }
        }
        return String.valueOf(identifierSize);
    }

    public static class TextEntry {
        private String propertyValue;
        private String propertyName;

        public TextEntry(String propertyName, String propertyValue) {
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

