/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.finalizer;

import java.util.Collection;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="finalizer_queue")
@Category(value="__hidden__")
@Icon(value="/META-INF/icons/finalizer.gif")
public class FinalizerQueueQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;

    public IResult execute(IProgressListener listener) throws Exception {
        Collection<IClass> finalizerClasses = this.snapshot.getClassesByName("java.lang.ref.Finalizer", false);
        ArrayInt result = new ArrayInt();
        if (finalizerClasses != null) {
            if (finalizerClasses.size() != 1) {
                throw new Exception(Messages.FinalizerQueueQuery_ErrorMsg_MultipleFinalizerClasses);
            }
            IClass finalizerClass = finalizerClasses.iterator().next();
            IObject queue = (IObject)finalizerClass.resolveValue("queue");
            if (queue != null) {
                IInstance item = (IInstance)queue.resolveValue("head");
                int length = ((Long)queue.resolveValue("queueLength")).intValue();
                int threshold = length / 100;
                int worked = 0;
                listener.beginTask(Messages.FinalizerQueueQuery_Msg_ExtractingObjects, length);
                while (item != null) {
                    IInstance next;
                    if (listener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    ObjectReference ref = (ObjectReference)item.getField("referent").getValue();
                    if (ref != null) {
                        result.add(ref.getObjectId());
                    }
                    if ((next = (IInstance)item.resolveValue("next")) == item) {
                        next = null;
                    }
                    item = next;
                    if (++worked < threshold) continue;
                    listener.worked(worked);
                    worked = 0;
                }
                listener.done();
            }
        }
        int[] nArray = this.snapshot.getGCRoots();
        int item = nArray.length;
        int queue = 0;
        while (queue < item) {
            GCRootInfo[] ifo;
            int root = nArray[queue];
            GCRootInfo[] gCRootInfoArray = ifo = this.snapshot.getGCRootInfo(root);
            int n = ifo.length;
            int n2 = 0;
            while (n2 < n) {
                GCRootInfo rootInfo = gCRootInfoArray[n2];
                if (rootInfo.getType() == 512) {
                    result.add(rootInfo.getObjectId());
                    break;
                }
                ++n2;
            }
            ++queue;
        }
        SectionSpec spec = new SectionSpec(Messages.FinalizerQueueQuery_ReadyForFinalizerThread);
        QuerySpec objList = new QuerySpec(Messages.FinalizerQueueQuery_ReadyForFinalizerThread_List, (IResult)new ObjectListResult.Outbound(this.snapshot, result.toArray()));
        spec.add((Spec)objList);
        QuerySpec histogram = new QuerySpec(Messages.FinalizerQueueQuery_ReadyForFinalizerThread_Histogram, (IResult)this.snapshot.getHistogram(result.toArray(), listener));
        histogram.set("sort_column", Messages.Column_RetainedHeap);
        histogram.set("derived_data_column", "_default_=APPROXIMATE");
        spec.add((Spec)histogram);
        return spec;
    }
}

