/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.rcp.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.mat.ui.internal.Perspective;
import org.eclipse.mat.ui.rcp.Messages;
import org.eclipse.mat.ui.rcp.actions.ShowViewAction;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ShowViewMenu
extends ContributionItem {
    private IWorkbenchWindow window;
    protected boolean dirty = true;
    private Map<String, IAction> actions = new HashMap<String, IAction>(10);
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            ShowViewMenu.this.dirty = true;
        }
    };

    public ShowViewMenu(IWorkbenchWindow window) {
        this.window = window;
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        MenuManager manager = new MenuManager();
        this.fillMenu((IMenuManager)manager);
        IContributionItem[] items = manager.getItems();
        if (items.length == 0) {
            MenuItem item = new MenuItem(menu, 0, index++);
            item.setText(Messages.ShowViewMenu_NoApplicableView);
            item.setEnabled(false);
        } else {
            int i = 0;
            while (i < items.length) {
                items[i].fill(menu, index++);
                ++i;
            }
        }
        this.dirty = false;
    }

    private void fillMenu(IMenuManager innerMgr) {
        innerMgr.removeAll();
        ArrayList<IAction> actions = new ArrayList<IAction>(Perspective.Views.values().length);
        Perspective.Views[] viewsArray = Perspective.Views.values();
        int n = viewsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Perspective.Views view = viewsArray[n2];
            IAction action = this.getAction(view.getId());
            if (action != null) {
                actions.add(action);
            }
            ++n2;
        }
        for (IAction action : actions) {
            innerMgr.add(action);
        }
    }

    private IAction getAction(String id) {
        IViewRegistry reg;
        IViewDescriptor desc;
        Object action = this.actions.get(id);
        if (action == null && (desc = (reg = PlatformUI.getWorkbench().getViewRegistry()).find(id)) != null) {
            action = new ShowViewAction(this.window, desc);
            action.setActionDefinitionId(id);
            this.actions.put(id, (IAction)action);
        }
        return action;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }
}

