/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.LongDateRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    LongDateRec dateRec;
    LongDateRec dateAndTime = new LongDateRec();
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;
    Color fg;
    Color bg;
    Calendar calendar;
    DateFormatSymbols formatSymbols;
    Button monthDown;
    Button monthUp;
    Button yearDown;
    Button yearUp;
    static final int MARGIN_WIDTH = 2;
    static final int MARGIN_HEIGHT = 1;

    public DateTime(Composite parent, int style) {
        super(parent, DateTime.checkStyle(style) | ((style & 0x400) != 0 ? 0x100000 : 0));
        if ((this.style & 0x400) != 0) {
            this.calendar = Calendar.getInstance();
            this.formatSymbols = new DateFormatSymbols();
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 9: {
                            DateTime.this.handlePaint(event);
                            break;
                        }
                        case 11: {
                            DateTime.this.handleResize(event);
                            break;
                        }
                        case 3: {
                            DateTime.this.handleMouseDown(event);
                            break;
                        }
                        case 1: {
                            DateTime.this.handleKeyDown(event);
                            break;
                        }
                        case 31: {
                            DateTime.this.handleTraverse(event);
                        }
                    }
                }
            };
            this.addListener(9, listener);
            this.addListener(11, listener);
            this.addListener(3, listener);
            this.addListener(1, listener);
            this.addListener(31, listener);
            this.yearDown = new Button(this, 16388);
            this.monthDown = new Button(this, 16388);
            this.monthUp = new Button(this, 131076);
            this.yearUp = new Button(this, 131076);
            listener = new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.handleSelection(event);
                }
            };
            this.yearDown.addListener(13, listener);
            this.monthDown.addListener(13, listener);
            this.monthUp.addListener(13, listener);
            this.yearUp.addListener(13, listener);
        }
    }

    static int checkStyle(int style) {
        style &= 0xFFFFFCFF;
        style = DateTime.checkBits(style, 65536, 32768, 0x10000000, 0, 0, 0);
        return DateTime.checkBits(style, 32, 128, 1024, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (wHint == -1 || hHint == -1) {
            if ((this.style & 0x400) != 0) {
                Point cellSize = this.getCellSize(null);
                Point buttonSize = this.monthDown.computeSize(-1, -1, changed);
                width = cellSize.x * 7;
                height = cellSize.y * 7 + Math.max(cellSize.y, buttonSize.y);
            } else {
                Rect rect = new Rect();
                OS.GetBestControlRect(this.handle, rect, null);
                width = rect.right - rect.left;
                height = rect.bottom - rect.top;
            }
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    void createHandle() {
        int clockType = -1;
        if ((this.style & 0x80) != 0) {
            int n = clockType = (this.style & 0x8000) != 0 ? 0 : 1;
        }
        if ((this.style & 0x20) != 0) {
            int n = clockType = (this.style & 0x8000) != 0 ? 3 : 2;
        }
        if (clockType != -1) {
            int clockFlags = 0;
            int[] outControl = new int[1];
            int window = OS.GetControlOwner(this.parent.handle);
            OS.CreateClockControl(window, null, clockType, clockFlags, outControl);
            if (outControl[0] == 0) {
                this.error(2);
            }
            this.handle = outControl[0];
        } else {
            super.createHandle();
        }
    }

    void createWidget() {
        super.createWidget();
        this.getDate();
    }

    void drawDay(GC gc, Point cellSize, int day) {
        int cell = this.getCell(day);
        Point location = this.getCellLocation(cell, cellSize);
        String str = String.valueOf(day);
        Point extent = gc.stringExtent(str);
        int date = this.calendar.get(5);
        if (day == date) {
            Display display = this.getDisplay();
            gc.setBackground(display.getSystemColor(26));
            gc.setForeground(display.getSystemColor(27));
            gc.fillRectangle(location.x, location.y, cellSize.x, cellSize.y);
        }
        gc.drawString(str, location.x + (cellSize.x - extent.x) / 2, location.y + (cellSize.y - extent.y) / 2, true);
        if (day == date) {
            gc.setBackground(this.getBackground());
            gc.setForeground(this.getForeground());
        }
    }

    void drawDays(GC gc, Point cellSize, Rectangle client) {
        gc.setBackground(this.getBackground());
        gc.setForeground(this.getForeground());
        gc.fillRectangle(0, cellSize.y, client.width, cellSize.y * 7);
        int firstDay = this.calendar.getActualMinimum(5);
        int lastDay = this.calendar.getActualMaximum(5);
        int day = firstDay;
        while (day <= lastDay) {
            this.drawDay(gc, cellSize, day);
            ++day;
        }
    }

    void drawDaysOfWeek(GC gc, Point cellSize, Rectangle client) {
        Display display = this.getDisplay();
        gc.setBackground(display.getSystemColor(22));
        gc.setForeground(display.getSystemColor(21));
        gc.fillRectangle(0, 0, client.width, cellSize.y);
        String[] days = this.formatSymbols.getShortWeekdays();
        int x = 0;
        int y = 0;
        int i = 1;
        while (i < days.length) {
            String day = days[i];
            Point extent = gc.stringExtent(day);
            gc.drawString(day, x + (cellSize.x - extent.x) / 2, y + (cellSize.y - extent.y) / 2, true);
            x += cellSize.x;
            ++i;
        }
        gc.drawLine(0, cellSize.y - 1, client.width, cellSize.y - 1);
    }

    void drawMonth(GC gc, Point cellSize, Rectangle client) {
        Display display = this.getDisplay();
        gc.setBackground(display.getSystemColor(22));
        gc.setForeground(display.getSystemColor(21));
        int y = cellSize.y * 7;
        gc.fillRectangle(0, y, client.width, cellSize.y);
        gc.drawLine(0, y - 1, client.width, y - 1);
        String str = String.valueOf(this.formatSymbols.getShortMonths()[this.calendar.get(2)]) + ", " + this.calendar.get(1);
        Point extent = gc.stringExtent(str);
        gc.drawString(str, (cellSize.x * 7 - extent.x) / 2, y + (cellSize.y - extent.y) / 2, true);
    }

    void handleKeyDown(Event event) {
        int newDay = this.calendar.get(5);
        switch (event.keyCode) {
            case 0x1000002: {
                newDay += 7;
                break;
            }
            case 0x1000001: {
                newDay -= 7;
                break;
            }
            case 0x1000004: {
                ++newDay;
                break;
            }
            case 0x1000003: {
                --newDay;
            }
        }
        this.setDay(newDay, true);
    }

    void handleMouseDown(Event event) {
        this.setFocus();
        Point cellSize = this.getCellSize(null);
        int column = event.x / cellSize.x;
        int row = event.y / cellSize.y;
        int cell = row * 7 + column;
        int newDay = this.getDate(cell);
        this.setDay(newDay, true);
    }

    void handlePaint(Event event) {
        GC gc = event.gc;
        Rectangle client = this.getClientArea();
        Point cellSize = this.getCellSize(gc);
        this.drawDaysOfWeek(gc, cellSize, client);
        this.drawDays(gc, cellSize, client);
        this.drawMonth(gc, cellSize, client);
    }

    void handleResize(Event event) {
        this.yearDown.pack();
        this.monthDown.pack();
        this.monthUp.pack();
        this.yearUp.pack();
        Point cellSize = this.getCellSize(null);
        Point size = this.monthDown.getSize();
        int height = Math.max(cellSize.y, size.y);
        int y = cellSize.y * 7 + (height - size.y) / 2;
        this.yearDown.setLocation(0, y);
        this.monthDown.setLocation(size.x, y);
        int x = cellSize.x * 7 - size.x;
        this.monthUp.setLocation(x - size.x, y);
        this.yearUp.setLocation(x, y);
    }

    void handleSelection(Event event) {
        if (event.widget == this.monthDown) {
            this.calendar.add(2, -1);
        } else if (event.widget == this.monthUp) {
            this.calendar.add(2, 1);
        } else if (event.widget == this.yearDown) {
            this.calendar.add(1, -1);
        } else if (event.widget == this.yearUp) {
            this.calendar.add(1, 1);
        } else {
            return;
        }
        this.redraw();
        this.postEvent(13);
    }

    void handleTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 256: 
            case 512: {
                event.doit = true;
            }
        }
    }

    Point getCellSize(GC gc) {
        boolean dispose;
        boolean bl = dispose = gc == null;
        if (gc == null) {
            gc = new GC(this);
        }
        int width = 0;
        int height = 0;
        String[] days = this.formatSymbols.getShortWeekdays();
        int i = 0;
        while (i < days.length) {
            Point extent = gc.stringExtent(days[i]);
            width = Math.max(width, extent.x);
            height = Math.max(height, extent.y);
            ++i;
        }
        int firstDay = this.calendar.getMinimum(5);
        int lastDay = this.calendar.getMaximum(5);
        int day = firstDay;
        while (day <= lastDay) {
            Point extent = gc.stringExtent(String.valueOf(day));
            width = Math.max(width, extent.x);
            height = Math.max(height, extent.y);
            ++day;
        }
        if (dispose) {
            gc.dispose();
        }
        return new Point(width + 4, height + 2);
    }

    Point getCellLocation(int cell, Point cellSize) {
        return new Point(cell % 7 * cellSize.x, cell / 7 * cellSize.y);
    }

    int getCell(int date) {
        int day = this.calendar.get(5);
        this.calendar.set(5, 1);
        int result = date + this.calendar.get(7) + 5;
        this.calendar.set(5, day);
        return result;
    }

    void getDate() {
        this.dateRec = new LongDateRec();
        OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
    }

    int getDate(int cell) {
        int day = this.calendar.get(5);
        this.calendar.set(5, 1);
        int result = cell - this.calendar.get(7) - 5;
        this.calendar.set(5, day);
        return result;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.bg == null) {
            return this.getDisplay().getSystemColor(25);
        }
        return this.bg;
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.fg == null) {
            return this.getDisplay().getSystemColor(24);
        }
        return this.fg;
    }

    public int getDay() {
        this.checkWidget();
        if ((this.style & 0x80) != 0) {
            return this.dateAndTime.day;
        }
        if ((this.style & 0x400) != 0) {
            return this.calendar.get(5);
        }
        this.getDate();
        return this.dateRec.day;
    }

    public int getHours() {
        this.checkWidget();
        if ((this.style & 0x20) != 0) {
            return this.dateAndTime.hour;
        }
        if ((this.style & 0x400) != 0) {
            return this.calendar.get(11);
        }
        this.getDate();
        return this.dateRec.hour;
    }

    public int getMinutes() {
        this.checkWidget();
        if ((this.style & 0x20) != 0) {
            return this.dateAndTime.minute;
        }
        if ((this.style & 0x400) != 0) {
            return this.calendar.get(12);
        }
        this.getDate();
        return this.dateRec.minute;
    }

    public int getMonth() {
        this.checkWidget();
        if ((this.style & 0x80) != 0) {
            return this.dateAndTime.month - 1;
        }
        if ((this.style & 0x400) != 0) {
            return this.calendar.get(2);
        }
        this.getDate();
        return this.dateRec.month - 1;
    }

    String getNameText() {
        return (this.style & 0x80) != 0 ? String.valueOf(this.getHours()) + ":" + this.getMinutes() + ":" + this.getSeconds() : String.valueOf(this.getMonth() + 1) + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        if ((this.style & 0x20) != 0) {
            return this.dateAndTime.second;
        }
        if ((this.style & 0x400) != 0) {
            return this.calendar.get(13);
        }
        this.getDate();
        return this.dateRec.second;
    }

    public int getYear() {
        this.checkWidget();
        if ((this.style & 0x80) != 0) {
            return this.dateAndTime.year;
        }
        if ((this.style & 0x400) != 0) {
            return this.calendar.get(1);
        }
        this.getDate();
        return this.dateRec.year;
    }

    void hookEvents() {
        super.hookEvents();
        if (OS.VERSION >= 4160) {
            int clockProc = this.display.clockProc;
            int[] mask = new int[]{1668050787, 1};
            int controlTarget = OS.GetControlEventTarget(this.handle);
            OS.InstallEventHandler(controlTarget, clockProc, mask.length / 2, mask, this.handle, null);
        }
    }

    boolean isValidTime(int fieldName, int value) {
        Calendar calendar = Calendar.getInstance();
        int min = calendar.getActualMinimum(fieldName);
        int max = calendar.getActualMaximum(fieldName);
        return value >= min && value <= max;
    }

    boolean isValidDate(int year, int month, int day) {
        if (year < 1752 || year > 9999) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day);
        return calendar.get(1) == year && calendar.get(2) == month && calendar.get(5) == day;
    }

    int kEventClockDateOrTimeChanged(int nextHandler, int theEvent, int userData) {
        this.sendSelectionEvent();
        return 0;
    }

    int kEventControlHit(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlHit(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (OS.VERSION < 4160) {
            this.sendSelectionEvent();
        }
        return result;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        int result = super.kEventTextInputUnicodeForKeyEvent(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (OS.VERSION < 4160) {
            this.sendSelectionEvent();
        }
        return result;
    }

    boolean pollTrackEvent() {
        return (this.style & 0x20) != 0 || (this.style & 0x80) != 0;
    }

    void redraw(int cell, Point cellSize) {
        Point location = this.getCellLocation(cell, cellSize);
        this.redraw(location.x, location.y, cellSize.x, cellSize.y, false);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.dateRec = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void sendSelectionEvent() {
        LongDateRec rec = new LongDateRec();
        OS.GetControlData(this.handle, (short)0, 1684108389, 28, rec, null);
        if (rec.second != this.dateRec.second || rec.minute != this.dateRec.minute || rec.hour != this.dateRec.hour || rec.day != this.dateRec.day || rec.month != this.dateRec.month || rec.year != this.dateRec.year) {
            this.dateRec = rec;
            this.postEvent(13);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        super.setBackground(color);
        this.bg = color;
    }

    public void setForeground(Color color) {
        this.checkWidget();
        super.setForeground(color);
        this.fg = color;
    }

    void setDay(int newDay, boolean notify) {
        int firstDay = this.calendar.getActualMinimum(5);
        int lastDay = this.calendar.getActualMaximum(5);
        if (firstDay > newDay || newDay > lastDay) {
            return;
        }
        Point cellSize = this.getCellSize(null);
        this.redraw(this.getCell(this.calendar.get(5)), cellSize);
        this.calendar.set(5, newDay);
        this.redraw(this.getCell(this.calendar.get(5)), cellSize);
        if (notify) {
            this.postEvent(13);
        }
    }

    public void setDate(int year, int month, int day) {
        this.checkWidget();
        if (!this.isValidDate(year, month, day)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.calendar.set(1, year);
            this.calendar.set(5, 1);
            this.calendar.set(2, month);
            this.redraw();
            this.setDay(day, false);
        } else {
            this.dateRec.year = (short)year;
            this.dateRec.month = (short)(month + 1);
            this.dateRec.day = (short)day;
            OS.SetControlData(this.handle, 0, 1684108389, 28, this.dateRec);
            OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
            this.redraw();
            if ((this.style & 0x80) != 0) {
                this.dateAndTime.year = (short)year;
                this.dateAndTime.month = (short)(month + 1);
                this.dateAndTime.day = (short)day;
            }
        }
    }

    public void setDay(int day) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), this.getMonth(), day)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.setDay(day, false);
        } else {
            this.dateRec.day = (short)day;
            OS.SetControlData(this.handle, 0, 1684108389, 28, this.dateRec);
            OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
            if ((this.style & 0x80) != 0) {
                this.dateAndTime.day = (short)day;
            }
            this.redraw();
        }
    }

    public void setHours(int hours) {
        this.checkWidget();
        if (!this.isValidTime(11, hours)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.calendar.set(11, hours);
        } else {
            this.dateRec.hour = (short)hours;
            OS.SetControlData(this.handle, 0, 1684108389, 28, this.dateRec);
            OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
            if ((this.style & 0x20) != 0) {
                this.dateAndTime.hour = (short)hours;
            }
        }
        this.redraw();
    }

    public void setMinutes(int minutes) {
        this.checkWidget();
        if (!this.isValidTime(12, minutes)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.calendar.set(12, minutes);
        } else {
            this.dateRec.minute = (short)minutes;
            OS.SetControlData(this.handle, 0, 1684108389, 28, this.dateRec);
            OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
            if ((this.style & 0x20) != 0) {
                this.dateAndTime.minute = (short)minutes;
            }
        }
        this.redraw();
    }

    public void setMonth(int month) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), month, this.getDay())) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.calendar.set(2, month);
        } else {
            this.dateRec.month = (short)(month + 1);
            OS.SetControlData(this.handle, 0, 1684108389, 28, this.dateRec);
            OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
            if ((this.style & 0x80) != 0) {
                this.dateAndTime.month = (short)(month + 1);
            }
        }
        this.redraw();
    }

    public void setSeconds(int seconds) {
        this.checkWidget();
        if (!this.isValidTime(13, seconds)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.calendar.set(13, seconds);
        } else {
            this.dateRec.second = (short)seconds;
            OS.SetControlData(this.handle, 0, 1684108389, 28, this.dateRec);
            OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
            if ((this.style & 0x20) != 0) {
                this.dateAndTime.second = (short)seconds;
            }
        }
        this.redraw();
    }

    public void setTime(int hours, int minutes, int seconds) {
        this.checkWidget();
        if (!this.isValidTime(11, hours)) {
            return;
        }
        if (!this.isValidTime(12, minutes)) {
            return;
        }
        if (!this.isValidTime(13, seconds)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.calendar.set(11, hours);
            this.calendar.set(12, minutes);
            this.calendar.set(13, seconds);
        } else {
            this.dateRec.hour = (short)hours;
            this.dateRec.minute = (short)minutes;
            this.dateRec.second = (short)seconds;
            OS.SetControlData(this.handle, 0, 1684108389, 28, this.dateRec);
            OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
            if ((this.style & 0x20) != 0) {
                this.dateAndTime.hour = (short)hours;
                this.dateAndTime.minute = (short)minutes;
                this.dateAndTime.second = (short)seconds;
            }
        }
        this.redraw();
    }

    public void setYear(int year) {
        this.checkWidget();
        if (!this.isValidDate(year, this.getMonth(), this.getDay())) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.calendar.set(1, year);
        } else {
            this.dateRec.year = (short)year;
            OS.SetControlData(this.handle, 0, 1684108389, 28, this.dateRec);
            OS.GetControlData(this.handle, (short)0, 1684108389, 28, this.dateRec, null);
            if ((this.style & 0x80) != 0) {
                this.dateAndTime.year = (short)year;
            }
        }
        this.redraw();
    }
}

