/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.dtfj;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.dtfj.DTFJIndexBuilder;
import org.eclipse.mat.dtfj.Messages;
import org.eclipse.mat.parser.IObjectReader;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.ClassLoaderImpl;
import org.eclipse.mat.parser.model.InstanceImpl;
import org.eclipse.mat.parser.model.ObjectArrayImpl;
import org.eclipse.mat.parser.model.PrimitiveArrayImpl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTFJHeapObjectReader
implements IObjectReader {
    private static final int LARGE_ARRAY_SIZE = 1000;
    private Image image;
    private JavaRuntime jvm;
    private ImageAddressSpace addrSpace;
    private static final boolean throwExceptions = true;

    public void close() throws IOException {
        this.image = null;
        this.jvm = null;
        this.addrSpace = null;
    }

    public <A> A getAddon(Class<A> addon) throws SnapshotException {
        if (this.image != null && addon.isAssignableFrom(this.image.getClass())) {
            return (A)this.image;
        }
        if (this.jvm != null && addon.isAssignableFrom(this.jvm.getClass())) {
            return (A)this.jvm;
        }
        return null;
    }

    public void open(ISnapshot snapshot) throws IOException {
        this.image = DTFJIndexBuilder.getDump(new File(snapshot.getSnapshotInfo().getPath()), snapshot.getSnapshotInfo().getProperty("$heapFormat"));
        this.jvm = DTFJIndexBuilder.getRuntime(this.image, null);
        try {
            this.addrSpace = DTFJIndexBuilder.getAddressSpace(this.jvm);
        }
        catch (CorruptDataException e) {
            IOException e2 = new IOException(Messages.DTFJHeapObjectReader_UnableToFindAddressSpace);
            e2.initCause(e);
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObject read(int objectId, ISnapshot snapshot) throws SnapshotException, IOException {
        long addr = snapshot.mapIdToAddress(objectId);
        try {
            Image image = this.image;
            synchronized (image) {
                JavaObject jo = this.getJavaObjectByAddress0(addr);
                Object inst = snapshot.isArray(objectId) ? this.createArray(snapshot, objectId, addr, jo) : this.createObject(snapshot, objectId, addr, jo);
                return inst;
            }
        }
        catch (MemoryAccessException e) {
            throw new SnapshotException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectAtIndex, objectId, DTFJHeapObjectReader.format(addr)), (Throwable)e);
        }
        catch (CorruptDataException e) {
            throw new SnapshotException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectAtIndex, objectId, DTFJHeapObjectReader.format(addr)), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new SnapshotException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectAtIndex, objectId, DTFJHeapObjectReader.format(addr)), (Throwable)e);
        }
    }

    private JavaObject getJavaObjectByAddress0(long addr) throws CorruptDataException, MemoryAccessException {
        ImagePointer ip = this.addrSpace.getPointer(addr);
        try {
            JavaObject jo = this.jvm.getObjectAtAddress(ip);
            return jo;
        }
        catch (DataUnavailable dataUnavailable) {
            return this.getJavaObjectByAddress(addr);
        }
        catch (LinkageError linkageError) {
            return this.getJavaObjectByAddress(addr);
        }
    }

    private JavaObject getJavaObjectByAddress(long addr) {
        Iterator i = this.jvm.getHeaps();
        while (i.hasNext()) {
            Object next = i.next();
            if (next instanceof CorruptData) continue;
            JavaHeap jh = (JavaHeap)next;
            Iterator j = jh.getObjects();
            while (j.hasNext()) {
                JavaObject jo;
                Object next2 = j.next();
                if (next2 instanceof CorruptData || (jo = (JavaObject)next2).getID().getAddress() != addr) continue;
                return jo;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.DTFJHeapObjectReader_JavaObjectAtAddressNotFound, DTFJHeapObjectReader.format(addr)));
    }

    private InstanceImpl createObject(ISnapshot snapshot, int objectId, long addr, JavaObject jo) throws CorruptDataException, MemoryAccessException, SnapshotException {
        ClassImpl cls = (ClassImpl)snapshot.getClassOf(objectId);
        int nFields = 0;
        ClassImpl cls2 = cls;
        while (cls2 != null) {
            nFields += cls2.getFieldDescriptors().size();
            cls2 = cls2.getSuperClass();
        }
        ArrayList<Field> fields = new ArrayList<Field>(nFields);
        if (nFields > 0) {
            JavaClass jc = jo.getJavaClass();
            while (jc != null) {
                Iterator ii = jc.getDeclaredFields();
                while (ii.hasNext()) {
                    JavaField jf;
                    Object next = ii.next();
                    if (next instanceof CorruptData || Modifier.isStatic((jf = (JavaField)next).getModifiers())) continue;
                    Object val = null;
                    try {
                        Object o = jf.get(jo);
                        if (o instanceof JavaObject) {
                            JavaObject jo2 = (JavaObject)o;
                            long addr2 = jo2.getID().getAddress();
                            val = new ObjectReference(snapshot, addr2);
                        } else if (o instanceof Number || o instanceof Character || o instanceof Boolean || o == null) {
                            val = o;
                        }
                    }
                    catch (CorruptDataException e) {
                        this.logOrThrow(e);
                    }
                    catch (MemoryAccessException e) {
                        this.logOrThrow(e);
                    }
                    Field f = new Field(jf.getName(), DTFJIndexBuilder.signatureToType(jf.getSignature()), val);
                    fields.add(f);
                }
                jc = jc.getSuperclass();
            }
        }
        Object inst = snapshot.isClassLoader(objectId) ? new ClassLoaderImpl(objectId, addr, cls, fields) : new InstanceImpl(objectId, addr, cls, fields);
        return inst;
    }

    private IObject createArray(ISnapshot snapshot, int objectId, long addr, JavaObject jo) throws CorruptDataException, MemoryAccessException, SnapshotException {
        ClassImpl cls = (ClassImpl)snapshot.getClassOf(objectId);
        int offset = 0;
        int length = jo.getArraySize();
        JavaClass arrayClass = jo.getJavaClass();
        if (DTFJIndexBuilder.isPrimitiveArray(arrayClass)) {
            String typeName = arrayClass.getName();
            int type = this.getArrayType(typeName);
            Object res = length < 1000 ? this.getPrimitiveData(jo, type, offset, length) : new DeferredReadArray(objectId, addr, jo);
            PrimitiveArrayImpl ret = new PrimitiveArrayImpl(objectId, addr, cls, length, type);
            ret.setInfo(res);
            return ret;
        }
        Object res = length < 1000 ? this.getObjectData(jo, offset, length) : (Object)new DeferredReadArray(objectId, addr, jo);
        ObjectArrayImpl ret = new ObjectArrayImpl(objectId, addr, cls, length);
        ret.setInfo(res);
        return ret;
    }

    private long[] getObjectData(JavaObject jo, int offset, int length) throws CorruptDataException, MemoryAccessException {
        JavaObject[] temp = new JavaObject[length];
        try {
            jo.arraycopy(offset, (Object)temp, 0, length);
        }
        catch (MemoryAccessException e) {
            this.logOrThrow(e);
        }
        long[] res = new long[length];
        int i = 0;
        while (i < length) {
            long addr2;
            res[i] = addr2 = temp[i] == null ? 0L : temp[i].getID().getAddress();
            ++i;
        }
        return res;
    }

    private int getArrayType(String typeName) {
        int type;
        if (typeName.equals("[Z") || typeName.equals("[boolean")) {
            type = 4;
        } else if (typeName.equals("[B") || typeName.equals("[byte")) {
            type = 8;
        } else if (typeName.equals("[C") || typeName.equals("[char")) {
            type = 5;
        } else if (typeName.equals("[S") || typeName.equals("[short")) {
            type = 9;
        } else if (typeName.equals("[I") || typeName.equals("[int")) {
            type = 10;
        } else if (typeName.equals("[F") || typeName.equals("[float")) {
            type = 6;
        } else if (typeName.equals("[J") || typeName.equals("[long")) {
            type = 11;
        } else if (typeName.equals("[D") || typeName.equals("[double")) {
            type = 7;
        } else {
            int type2 = 8;
            throw new IllegalArgumentException(MessageFormat.format(Messages.DTFJHeapObjectReader_UnexpectedTypeName, typeName));
        }
        return type;
    }

    private Object getPrimitiveData(JavaObject jo, int type, int offset, int length) throws CorruptDataException, MemoryAccessException {
        Object[] res;
        switch (type) {
            case 4: {
                res = new boolean[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 8: {
                res = new byte[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 5: {
                res = new char[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 9: {
                res = new short[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 10: {
                res = new int[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 6: {
                res = new float[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 11: {
                res = new long[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            case 7: {
                res = new double[length];
                try {
                    jo.arraycopy(offset, (Object)res, 0, length);
                }
                catch (MemoryAccessException e) {
                    this.logOrThrow(e);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(Messages.DTFJHeapObjectReader_UnexpectedType, type));
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readPrimitiveArrayContent(PrimitiveArrayImpl array, int offset, int length) throws IOException, SnapshotException {
        Object res;
        block7: {
            Object info = array.getInfo();
            if (info instanceof DeferredReadArray) {
                DeferredReadArray da = (DeferredReadArray)info;
                try {
                    Image image = this.image;
                    synchronized (image) {
                        res = this.getPrimitiveData(da.getJo(), array.getType(), offset, length);
                        break block7;
                    }
                }
                catch (CorruptDataException e) {
                    IOException e1 = new IOException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingPrimitiveArray, da.getObjectId(), DTFJHeapObjectReader.format(da.getAddr()), offset, length));
                    e1.initCause(e);
                    throw e1;
                }
                catch (MemoryAccessException e) {
                    IOException e1 = new IOException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingPrimitiveArray, da.getObjectId(), DTFJHeapObjectReader.format(da.getAddr()), offset, length));
                    e1.initCause(e);
                    throw e1;
                }
            }
            res = Array.newInstance(info.getClass().getComponentType(), length);
            System.arraycopy(info, offset, res, 0, length);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] readObjectArrayContent(ObjectArrayImpl array, int offset, int length) throws IOException, SnapshotException {
        long[] res;
        block7: {
            Object info = array.getInfo();
            if (info instanceof DeferredReadArray) {
                DeferredReadArray da = (DeferredReadArray)info;
                try {
                    Image image = this.image;
                    synchronized (image) {
                        res = this.getObjectData(da.getJo(), offset, length);
                        break block7;
                    }
                }
                catch (CorruptDataException e) {
                    IOException e1 = new IOException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectArray, da.getObjectId(), DTFJHeapObjectReader.format(da.getAddr()), offset, length));
                    e1.initCause(e);
                    throw e1;
                }
                catch (MemoryAccessException e) {
                    IOException e1 = new IOException(MessageFormat.format(Messages.DTFJHeapObjectReader_ErrorReadingObjectArray, da.getObjectId(), DTFJHeapObjectReader.format(da.getAddr()), offset, length));
                    e1.initCause(e);
                    throw e1;
                }
            }
            res = new long[length];
            System.arraycopy(info, offset, res, 0, length);
        }
        return res;
    }

    private static String format(long address) {
        return "0x" + Long.toHexString(address);
    }

    private void logOrThrow(MemoryAccessException e) throws MemoryAccessException {
        throw e;
    }

    private void logOrThrow(CorruptDataException e) throws CorruptDataException {
        throw e;
    }

    static class DeferredReadArray {
        private int objectId;
        private long addr;
        private JavaObject jo;

        public DeferredReadArray(int objectId, long addr, JavaObject jo) {
            this.setObjectId(objectId);
            this.setAddr(addr);
            this.setJo(jo);
        }

        private void setObjectId(int objectId) {
            this.objectId = objectId;
        }

        int getObjectId() {
            return this.objectId;
        }

        private void setAddr(long addr) {
            this.addr = addr;
        }

        long getAddr() {
            return this.addr;
        }

        private void setJo(JavaObject jo) {
            this.jo = jo;
        }

        JavaObject getJo() {
            return this.jo;
        }
    }
}

