/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.dtfj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.mat.dtfj.DTFJHeapObjectReader;
import org.eclipse.mat.dtfj.DTFJIndexBuilder;
import org.eclipse.mat.dtfj.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class InitDTFJ
extends Plugin {
    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.registerFileExtensions();
    }

    void registerFileExtensions() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        String cp = "UTF-8";
        try {
            IExtension es = reg.getExtension("org.eclipse.ui.startup", "org.eclipse.mat.dtfj.dtfj");
            if (es == null) {
                es = reg.getExtension("org.eclipse.core.contenttype.contentTypes", "com.ibm.dtfj.base");
            }
            IContributor cont = es != null ? es.getContributor() : ContributorFactoryOSGi.createContributor((Bundle)this.getBundle());
            IExtensionPoint dtfjPoint = reg.getExtensionPoint("com.ibm.dtfj.api", "imagefactory");
            IExtensionPoint contentPoint = reg.getExtensionPoint("org.eclipse.core.contenttype", "contentTypes");
            HashSet<String> done = new HashSet<String>();
            if (dtfjPoint != null) {
                IExtension[] iExtensionArray = dtfjPoint.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension ex = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = ex.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement el = iConfigurationElementArray[n4];
                        if (el.getName().equals("factory")) {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            OutputStreamWriter oo = new OutputStreamWriter((OutputStream)bos, cp);
                            PrintWriter ow = new PrintWriter(oo);
                            String id = el.getAttribute("id");
                            String name = el.getAttribute("label");
                            ow.println("<?xml version=\"1.0\" encoding=\"" + cp + "\"?>");
                            ow.println("<?eclipse version=\"3.2\"?>");
                            ow.println("<plugin>");
                            ow.println("<extension");
                            ow.println("id=\"" + id + "\"");
                            ow.println("name=\"" + name + "\"");
                            ow.println("point=\"org.eclipse.mat.parser.parser\">");
                            IConfigurationElement[] iConfigurationElementArray2 = el.getChildren();
                            int n5 = iConfigurationElementArray2.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IConfigurationElement el2 = iConfigurationElementArray2[n6];
                                String ref = el2.getAttribute("dump-type");
                                if (ref != null && done.add(ref)) {
                                    InitDTFJ.genParser(ref, contentPoint, ow);
                                }
                                if ((ref = el2.getAttribute("meta-type")) != null && done.add(ref)) {
                                    InitDTFJ.genParser(ref, contentPoint, ow);
                                }
                                ++n6;
                            }
                            ow.println("</extension>");
                            ow.println("</plugin>");
                            ow.flush();
                            ow.close();
                            ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());
                            Object token = ((ExtensionRegistry)reg).getTemporaryUserToken();
                            reg.addContribution((InputStream)is, cont, false, Messages.InitDTFJ_DynamicDtfj, null, token);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private static void genParser(String ref, IExtensionPoint point2, PrintWriter ow) {
        IContentType ct = Platform.getContentTypeManager().getContentType(ref);
        if (ct == null) {
            return;
        }
        IContentType[] iContentTypeArray = Platform.getContentTypeManager().getAllContentTypes();
        int n = iContentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType ct1 = iContentTypeArray[n2];
            if (ct1.isKindOf(ct)) {
                InitDTFJ.genParser(ct1, ow);
            }
            ++n2;
        }
    }

    private static void genParser(IContentType ct, PrintWriter ow) {
        String[] s;
        String label = ct.getName();
        if (label != null && (s = ct.getFileSpecs(8)).length > 0) {
            String exts = null;
            String[] stringArray = s;
            int n = s.length;
            int n2 = 0;
            while (n2 < n) {
                String s1 = stringArray[n2];
                exts = exts == null ? s1 : String.valueOf(exts) + "," + s1;
                ++n2;
            }
            ow.println("<parser");
            ow.println("name=\"" + label + "\"");
            ow.println("fileExtension=\"" + exts + "\"");
            ow.println("indexBuilder=\"" + DTFJIndexBuilder.class.getName() + "\"");
            ow.println("objectReader=\"" + DTFJHeapObjectReader.class.getName() + "\">");
            ow.println("</parser>");
        }
    }
}

