/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.util.EventListener;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RetryRequest;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.jetty.servlet.HashSessionManager;
import org.mortbay.log.Log;

public class SessionHandler
extends HandlerWrapper {
    private SessionManager _sessionManager;

    public SessionHandler() {
        this(new HashSessionManager());
    }

    public SessionHandler(SessionManager manager) {
        this.setSessionManager(manager);
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        SessionManager old_session_manager = this._sessionManager;
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object)old_session_manager, (Object)sessionManager, "sessionManager", true);
        }
        if (sessionManager != null) {
            sessionManager.setSessionHandler(this);
        }
        this._sessionManager = sessionManager;
        if (old_session_manager != null) {
            old_session_manager.setSessionHandler(null);
        }
    }

    public void setServer(Server server) {
        Server old_server = this.getServer();
        if (old_server != null && old_server != server) {
            old_server.getContainer().update((Object)this, (Object)this._sessionManager, null, "sessionManager", true);
        }
        super.setServer(server);
        if (server != null && server != old_server) {
            server.getContainer().update((Object)this, null, (Object)this._sessionManager, "sessionManager", true);
        }
    }

    protected void doStart() throws Exception {
        this._sessionManager.start();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._sessionManager.stop();
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        this.setRequestedId(request, dispatch);
        Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        SessionManager old_session_manager = null;
        HttpSession old_session = null;
        try {
            old_session_manager = base_request.getSessionManager();
            old_session = base_request.getSession(false);
            if (old_session_manager != this._sessionManager) {
                base_request.setSessionManager(this._sessionManager);
                base_request.setSession(null);
            }
            HttpSession session = null;
            if (this._sessionManager != null) {
                session = base_request.getSession(false);
                if (session != null) {
                    Cookie cookie;
                    if (session != old_session && (cookie = this._sessionManager.access(session, request.isSecure())) != null) {
                        response.addCookie(cookie);
                    }
                } else {
                    session = base_request.recoverNewSession(this._sessionManager);
                    if (session != null) {
                        base_request.setSession(session);
                    }
                }
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)("sessionManager=" + this._sessionManager));
                Log.debug((String)("session=" + session));
            }
            this.getHandler().handle(target, request, response, dispatch);
        }
        catch (RetryRequest r) {
            HttpSession session = base_request.getSession(false);
            if (session != null && session.isNew()) {
                base_request.saveNewSession(this._sessionManager, session);
            }
            throw r;
        }
        finally {
            HttpSession session = request.getSession(false);
            if (old_session_manager != this._sessionManager) {
                if (session != null) {
                    this._sessionManager.complete(session);
                }
                base_request.setSessionManager(old_session_manager);
                base_request.setSession(old_session);
            }
        }
    }

    protected void setRequestedId(HttpServletRequest request, int dispatch) {
        String uri;
        int semi;
        Cookie[] cookies;
        Request base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
        String requested_session_id = request.getRequestedSessionId();
        if (dispatch != 1 || requested_session_id != null) {
            return;
        }
        SessionManager sessionManager = this.getSessionManager();
        boolean requested_session_id_from_cookie = false;
        if (this._sessionManager.isUsingCookies() && (cookies = request.getCookies()) != null && cookies.length > 0) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!sessionManager.getSessionCookie().equalsIgnoreCase(cookies[i].getName())) continue;
                if (requested_session_id != null && sessionManager.getHttpSession(requested_session_id) != null) break;
                requested_session_id = cookies[i].getValue();
                requested_session_id_from_cookie = true;
                if (!Log.isDebugEnabled()) continue;
                Log.debug((String)("Got Session ID " + requested_session_id + " from cookie"));
            }
        }
        if (requested_session_id == null && (semi = (uri = request.getRequestURI()).lastIndexOf(59)) >= 0) {
            String path_params = uri.substring(semi + 1);
            String param = sessionManager.getSessionURL();
            if (param != null && path_params != null && path_params.startsWith(param)) {
                requested_session_id = path_params.substring(sessionManager.getSessionURL().length() + 1);
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Got Session ID " + requested_session_id + " from URL"));
                }
            }
        }
        base_request.setRequestedSessionId(requested_session_id);
        base_request.setRequestedSessionIdFromCookie(requested_session_id != null && requested_session_id_from_cookie);
    }

    public void addEventListener(EventListener listener) {
        if (this._sessionManager != null) {
            this._sessionManager.addEventListener(listener);
        }
    }

    public void clearEventListeners() {
        if (this._sessionManager != null) {
            this._sessionManager.clearEventListeners();
        }
    }
}

