/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.script;

import com.ibm.icu.util.ULocale;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.LegendEntryRenderingHints;
import org.eclipse.birt.chart.computation.PlotComputation;
import org.eclipse.birt.chart.datafeed.IDataSetProcessor;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.CurveFitting;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.render.ISeriesRenderer;
import org.eclipse.birt.chart.script.IChartEventHandler;
import org.eclipse.birt.chart.script.IChartScriptContext;
import org.eclipse.birt.chart.script.IScriptClassLoader;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptHandler
extends ScriptableObject {
    private static final long serialVersionUID = 1L;
    private static final Map<String, Method> JAVA_FUNTION_MAP = ChartUtil.newHashMap();
    public static final String START_GENERATION = "startGeneration";
    public static final String FINISH_GENERATION = "finishGeneration";
    public static final String BEFORE_LAYOUT = "beforeLayout";
    public static final String AFTER_LAYOUT = "afterLayout";
    public static final String BEFORE_COMPUTATIONS = "beforeComputations";
    public static final String AFTER_COMPUTATIONS = "afterComputations";
    public static final String START_RENDERING = "startRendering";
    public static final String FINISH_RENDERING = "finishRendering";
    public static final String START_COMPUTE_SERIES = "startComputeSeries";
    public static final String FINISH_COMPUTE_SERIES = "finishComputeSeries";
    public static final String BEFORE_DRAW_ELEMENT = "beforeDrawElement";
    public static final String AFTER_DRAW_ELEMENT = "afterDrawElement";
    public static final String BEFORE_DATA_SET_FILLED = "beforeDataSetFilled";
    public static final String AFTER_DATA_SET_FILLED = "afterDataSetFilled";
    public static final String BEFORE_GENERATION = "beforeGeneration";
    public static final String AFTER_GENERATION = "afterGeneration";
    public static final String BEFORE_RENDERING = "beforeRendering";
    public static final String AFTER_RENDERING = "afterRendering";
    public static final String BEFORE_DRAW_BLOCK = "beforeDrawBlock";
    public static final String AFTER_DRAW_BLOCK = "afterDrawBlock";
    public static final String BEFORE_DRAW_LEGEND_ENTRY = "beforeDrawLegendEntry";
    public static final String AFTER_DRAW_LEGEND_ENTRY = "afterDrawLegendEntry";
    public static final String BEFORE_DRAW_LEGEND_ITEM = "beforeDrawLegendItem";
    public static final String AFTER_DRAW_LEGEND_ITEM = "afterDrawLegendItem";
    public static final String BEFORE_DRAW_SERIES = "beforeDrawSeries";
    public static final String AFTER_DRAW_SERIES = "afterDrawSeries";
    public static final String BEFORE_DRAW_SERIES_TITLE = "beforeDrawSeriesTitle";
    public static final String AFTER_DRAW_SERIES_TITLE = "afterDrawSeriesTitle";
    public static final String BEFORE_DRAW_MARKER = "beforeDrawMarker";
    public static final String AFTER_DRAW_MARKER = "afterDrawMarker";
    public static final String BEFORE_DRAW_MARKER_LINE = "beforeDrawMarkerLine";
    public static final String AFTER_DRAW_MARKER_LINE = "afterDrawMarkerLine";
    public static final String BEFORE_DRAW_MARKER_RANGE = "beforeDrawMarkerRange";
    public static final String AFTER_DRAW_MARKER_RANGE = "afterDrawMarkerRange";
    public static final String BEFORE_DRAW_DATA_POINT = "beforeDrawDataPoint";
    public static final String AFTER_DRAW_DATA_POINT = "afterDrawDataPoint";
    public static final String BEFORE_DRAW_DATA_POINT_LABEL = "beforeDrawDataPointLabel";
    public static final String AFTER_DRAW_DATA_POINT_LABEL = "afterDrawDataPointLabel";
    public static final String BEFORE_DRAW_FITTING_CURVE = "beforeDrawFittingCurve";
    public static final String AFTER_DRAW_FITTING_CURVE = "afterDrawFittingCurve";
    public static final String BEFORE_DRAW_AXIS_LABEL = "beforeDrawAxisLabel";
    public static final String AFTER_DRAW_AXIS_LABEL = "afterDrawAxisLabel";
    public static final String BEFORE_DRAW_AXIS_TITLE = "beforeDrawAxisTitle";
    public static final String AFTER_DRAW_AXIS_TITLE = "afterDrawAxisTitle";
    public static final String BASE_VALUE = "categoryData";
    public static final String ORTHOGONAL_VALUE = "valueData";
    public static final String SERIES_VALUE = "valueSeriesName";
    private final transient Object[] ONE_ELEMENT_ARRAY = new Object[1];
    private final transient Object[] TWO_ELEMENT_ARRAY = new Object[2];
    private final transient Object[] THREE_ELEMENT_ARRAY = new Object[3];
    private transient Scriptable scope = null;
    private transient IChartEventHandler javahandler = null;
    private transient Chart cmDesignTime = null;
    private transient Chart cmRunTime = null;
    private transient GeneratedChartState gcs = null;
    private transient ULocale lcl = null;
    private transient IScriptClassLoader iscl = null;
    private transient List<String> javaScriptFunctionNamesCache = null;
    private IChartScriptContext csc;
    private static ILogger logger;

    static {
        Method[] ms = SecurityUtil.getMethods(IChartEventHandler.class);
        int i = 0;
        while (i < ms.length) {
            JAVA_FUNTION_MAP.put(ms[i].getName(), ms[i]);
            ++i;
        }
        logger = Logger.getLogger("org.eclipse.birt.chart.engine/model");
    }

    public ScriptHandler() {
        Context cx = Context.enter();
        try {
            this.scope = new ImporterTopLevel(cx);
        }
        finally {
            Context.exit();
        }
    }

    public final String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final Scriptable getScope() {
        return this.scope;
    }

    public Object jsFunction_getDesignTimeModel() {
        return this.cmDesignTime;
    }

    public Object jsFunction_getRunTimeModel() {
        return this.cmRunTime;
    }

    public Object jsFunction_getGeneratedChartState() {
        return this.gcs;
    }

    public final Object jsFunction_getLocale() {
        return this.lcl;
    }

    public final Object jsFunction_clone(Object eo) {
        if (!(eo instanceof EObject)) {
            return null;
        }
        return EcoreUtil.copy((EObject)((EObject)eo));
    }

    public final void setDesignTimeModel(Chart cmDesignTime) {
        this.cmDesignTime = cmDesignTime;
    }

    public final void setRunTimeModel(Chart cmRunTime) {
        this.cmRunTime = cmRunTime;
    }

    public final void setGeneratedChartState(GeneratedChartState gcs) {
        this.gcs = gcs;
    }

    public final void setLocale(ULocale lcl) {
        this.lcl = lcl;
    }

    public final void setScriptClassLoader(IScriptClassLoader value) {
        this.iscl = value;
    }

    public final void init(Scriptable scPrototype) throws ChartException {
        Context cx = Context.enter();
        try {
            try {
                if (scPrototype == null) {
                    this.scope = new ImporterTopLevel(cx);
                } else {
                    this.scope = cx.newObject(scPrototype);
                    this.scope.setPrototype(scPrototype);
                }
                Object oConsole = Context.javaToJS((Object)logger, (Scriptable)this.scope);
                this.scope.put("logger", this.scope, oConsole);
            }
            catch (RhinoException jsx) {
                throw this.convertException((Exception)((Object)jsx));
            }
        }
        finally {
            Context.exit();
        }
    }

    public final void registerExistingScriptableObject(ScriptableObject so, String sVarName) throws ChartException {
        try {
            ScriptableObject.defineClass((Scriptable)this.scope, so.getClass());
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
        Context cx = Context.enter();
        Scriptable soNew = null;
        try {
            try {
                soNew = cx.newObject(this.scope, so.getClassName(), null);
            }
            catch (RhinoException ex) {
                throw this.convertException((Exception)((Object)ex));
            }
        }
        finally {
            Context.exit();
        }
        so.setPrototype(soNew.getPrototype());
        so.setParentScope(soNew.getParentScope());
        this.scope.put(sVarName, this.scope, (Object)so);
    }

    public final void registerNewScriptableObject(Class<? extends Scriptable> clsScriptable, String sVarName) throws ChartException {
        try {
            ScriptableObject.defineClass((Scriptable)this.scope, clsScriptable);
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
        Context cx = Context.enter();
        Scriptable soNew = null;
        try {
            try {
                soNew = cx.newObject(this.scope, clsScriptable.getName(), null);
            }
            catch (RuntimeException ex) {
                throw this.convertException(ex);
            }
        }
        finally {
            Context.exit();
        }
        this.scope.put(sVarName, this.scope, (Object)soNew);
    }

    public final void registerVariable(String sVarName, Object var) throws ChartException {
        Context.enter();
        try {
            Object oConsole = Context.javaToJS((Object)var, (Scriptable)this.scope);
            this.scope.put(sVarName, this.scope, oConsole);
        }
        finally {
            Context.exit();
        }
    }

    public final void unregisterVariable(String sVarName) throws ChartException {
        this.scope.delete(sVarName);
    }

    private final Function getJavascriptFunction(String sFunctionName) {
        if (this.javaScriptFunctionNamesCache == null || this.javaScriptFunctionNamesCache.indexOf(sFunctionName) < 0) {
            return null;
        }
        Context.enter();
        try {
            Object oFunction = this.scope.get(sFunctionName, this.scope);
            if (oFunction != Scriptable.NOT_FOUND && oFunction instanceof Function) {
                Function function = (Function)oFunction;
                return function;
            }
            return null;
        }
        finally {
            Context.exit();
        }
    }

    private final Object callJavaScriptFunction(Function f, Object[] oaArgs) throws ChartException {
        Context cx = Context.enter();
        Object oReturnValue = null;
        ClassLoader oldLoader = cx.getApplicationClassLoader();
        ClassLoader appLader = SecurityUtil.getClassLoader(ScriptHandler.class);
        cx.setApplicationClassLoader(appLader);
        new CoreJavaScriptInitializer().initialize(cx, this.scope);
        try {
            try {
                oReturnValue = f.call(cx, this.scope, this.scope, oaArgs);
            }
            catch (RhinoException ex) {
                throw this.convertException((Exception)((Object)ex));
            }
        }
        finally {
            cx.setApplicationClassLoader(oldLoader);
            Context.exit();
        }
        return oReturnValue;
    }

    private final boolean isJavaFuntion(String name) {
        return JAVA_FUNTION_MAP.get(name) != null;
    }

    private final Object callJavaFunction(String name, Object[] oaArgs) {
        if (this.javahandler == null) {
            return null;
        }
        Object[] tmpArgs = new Object[3];
        if (oaArgs.length > 0) {
            tmpArgs[0] = oaArgs[0];
        }
        if (oaArgs.length > 1) {
            tmpArgs[1] = oaArgs[1];
        }
        if (oaArgs.length > 2) {
            tmpArgs[2] = oaArgs[2];
        }
        if (BEFORE_DATA_SET_FILLED.equals(name)) {
            this.javahandler.beforeDataSetFilled((Series)tmpArgs[0], (IDataSetProcessor)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (AFTER_DATA_SET_FILLED.equals(name)) {
            this.javahandler.afterDataSetFilled((Series)tmpArgs[0], (DataSet)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (BEFORE_GENERATION.equals(name)) {
            this.javahandler.beforeGeneration((Chart)tmpArgs[0], (IChartScriptContext)tmpArgs[1]);
        } else if (AFTER_GENERATION.equals(name)) {
            this.javahandler.afterGeneration((GeneratedChartState)tmpArgs[0], (IChartScriptContext)tmpArgs[1]);
        } else if (BEFORE_COMPUTATIONS.equals(name)) {
            this.javahandler.beforeComputations((Chart)tmpArgs[0], (PlotComputation)tmpArgs[1]);
        } else if (AFTER_COMPUTATIONS.equals(name)) {
            this.javahandler.afterComputations((Chart)tmpArgs[0], (PlotComputation)tmpArgs[1]);
        } else if (BEFORE_RENDERING.equals(name)) {
            this.javahandler.beforeRendering((GeneratedChartState)tmpArgs[0], (IChartScriptContext)tmpArgs[1]);
        } else if (AFTER_RENDERING.equals(name)) {
            this.javahandler.afterRendering((GeneratedChartState)tmpArgs[0], (IChartScriptContext)tmpArgs[1]);
        } else if (BEFORE_DRAW_BLOCK.equals(name)) {
            this.javahandler.beforeDrawBlock((Block)tmpArgs[0], (IChartScriptContext)tmpArgs[1]);
        } else if (AFTER_DRAW_BLOCK.equals(name)) {
            this.javahandler.afterDrawBlock((Block)tmpArgs[0], (IChartScriptContext)tmpArgs[1]);
        } else if (BEFORE_DRAW_LEGEND_ENTRY.equals(name)) {
            this.javahandler.beforeDrawLegendEntry((Label)tmpArgs[0], (IChartScriptContext)tmpArgs[1]);
        } else if (AFTER_DRAW_LEGEND_ENTRY.equals(name)) {
            this.javahandler.afterDrawLegendEntry((Label)tmpArgs[0], (IChartScriptContext)tmpArgs[1]);
        } else if (BEFORE_DRAW_LEGEND_ITEM.equals(name)) {
            this.javahandler.beforeDrawLegendItem((LegendEntryRenderingHints)tmpArgs[0], (Bounds)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (AFTER_DRAW_LEGEND_ITEM.equals(name)) {
            this.javahandler.afterDrawLegendItem((LegendEntryRenderingHints)tmpArgs[0], (Bounds)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (BEFORE_DRAW_SERIES.equals(name)) {
            this.javahandler.beforeDrawSeries((Series)tmpArgs[0], (ISeriesRenderer)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (AFTER_DRAW_SERIES.equals(name)) {
            this.javahandler.afterDrawSeries((Series)tmpArgs[0], (ISeriesRenderer)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (BEFORE_DRAW_SERIES_TITLE.equals(name)) {
            this.javahandler.beforeDrawSeriesTitle((Series)tmpArgs[0], (Label)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (AFTER_DRAW_SERIES_TITLE.equals(name)) {
            this.javahandler.afterDrawSeriesTitle((Series)tmpArgs[0], (Label)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (BEFORE_DRAW_MARKER_LINE.equals(name)) {
            this.javahandler.beforeDrawMarkerLine((Axis)tmpArgs[0], (MarkerLine)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (AFTER_DRAW_MARKER_LINE.equals(name)) {
            this.javahandler.afterDrawMarkerLine((Axis)tmpArgs[0], (MarkerLine)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (BEFORE_DRAW_MARKER_RANGE.equals(name)) {
            this.javahandler.beforeDrawMarkerRange((Axis)tmpArgs[0], (MarkerRange)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (AFTER_DRAW_MARKER_RANGE.equals(name)) {
            this.javahandler.afterDrawMarkerRange((Axis)tmpArgs[0], (MarkerRange)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (BEFORE_DRAW_DATA_POINT.equals(name)) {
            this.javahandler.beforeDrawDataPoint((DataPointHints)tmpArgs[0], (Fill)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (AFTER_DRAW_DATA_POINT.equals(name)) {
            this.javahandler.afterDrawDataPoint((DataPointHints)tmpArgs[0], (Fill)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (BEFORE_DRAW_DATA_POINT_LABEL.equals(name)) {
            this.javahandler.beforeDrawDataPointLabel((DataPointHints)tmpArgs[0], (Label)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (AFTER_DRAW_DATA_POINT_LABEL.equals(name)) {
            this.javahandler.afterDrawDataPointLabel((DataPointHints)tmpArgs[0], (Label)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (BEFORE_DRAW_FITTING_CURVE.equals(name)) {
            this.javahandler.beforeDrawFittingCurve((CurveFitting)tmpArgs[0], (IChartScriptContext)tmpArgs[1]);
        } else if (AFTER_DRAW_FITTING_CURVE.equals(name)) {
            this.javahandler.afterDrawFittingCurve((CurveFitting)tmpArgs[0], (IChartScriptContext)tmpArgs[1]);
        } else if (BEFORE_DRAW_AXIS_LABEL.equals(name)) {
            this.javahandler.beforeDrawAxisLabel((Axis)tmpArgs[0], (Label)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (AFTER_DRAW_AXIS_LABEL.equals(name)) {
            this.javahandler.afterDrawAxisLabel((Axis)tmpArgs[0], (Label)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (BEFORE_DRAW_AXIS_TITLE.equals(name)) {
            this.javahandler.beforeDrawAxisTitle((Axis)tmpArgs[0], (Label)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else if (AFTER_DRAW_AXIS_TITLE.equals(name)) {
            this.javahandler.afterDrawAxisTitle((Axis)tmpArgs[0], (Label)tmpArgs[1], (IChartScriptContext)tmpArgs[2]);
        } else {
            Method mtd = JAVA_FUNTION_MAP.get(name);
            try {
                return SecurityUtil.invokeMethod(mtd, this.javahandler, oaArgs);
            }
            catch (Exception e) {
                logger.log(e);
            }
        }
        return null;
    }

    public static final Object callFunction(ScriptHandler sh, String sFunction, Object oArg1) throws ChartException {
        if (sh == null) {
            return null;
        }
        if (sh.javahandler != null && sh.isJavaFuntion(sFunction)) {
            sh.ONE_ELEMENT_ARRAY[0] = oArg1;
            return sh.callJavaFunction(sFunction, sh.ONE_ELEMENT_ARRAY);
        }
        Function f = sh.getJavascriptFunction(sFunction);
        if (f != null) {
            sh.ONE_ELEMENT_ARRAY[0] = oArg1;
            Object oReturnValue = null;
            oReturnValue = sh.callJavaScriptFunction(f, sh.ONE_ELEMENT_ARRAY);
            return oReturnValue;
        }
        return null;
    }

    public static final Object callFunction(ScriptHandler sh, String sFunction, Object oArg1, Object oArg2) throws ChartException {
        if (sh == null) {
            return null;
        }
        if (sh.javahandler != null && sh.isJavaFuntion(sFunction)) {
            sh.TWO_ELEMENT_ARRAY[0] = oArg1;
            sh.TWO_ELEMENT_ARRAY[1] = oArg2;
            return sh.callJavaFunction(sFunction, sh.TWO_ELEMENT_ARRAY);
        }
        Function f = sh.getJavascriptFunction(sFunction);
        if (f != null) {
            sh.TWO_ELEMENT_ARRAY[0] = oArg1;
            sh.TWO_ELEMENT_ARRAY[1] = oArg2;
            Object oReturnValue = null;
            oReturnValue = sh.callJavaScriptFunction(f, sh.TWO_ELEMENT_ARRAY);
            return oReturnValue;
        }
        return null;
    }

    public static final Object callFunction(ScriptHandler sh, String sFunction, Object oArg1, Object oArg2, Object oArg3) throws ChartException {
        if (sh == null) {
            return null;
        }
        if (sh.javahandler != null && sh.isJavaFuntion(sFunction)) {
            sh.THREE_ELEMENT_ARRAY[0] = oArg1;
            sh.THREE_ELEMENT_ARRAY[1] = oArg2;
            sh.THREE_ELEMENT_ARRAY[2] = oArg3;
            return sh.callJavaFunction(sFunction, sh.THREE_ELEMENT_ARRAY);
        }
        Function f = sh.getJavascriptFunction(sFunction);
        if (f != null) {
            sh.THREE_ELEMENT_ARRAY[0] = oArg1;
            sh.THREE_ELEMENT_ARRAY[1] = oArg2;
            sh.THREE_ELEMENT_ARRAY[2] = oArg3;
            Object oReturnValue = null;
            oReturnValue = sh.callJavaScriptFunction(f, sh.THREE_ELEMENT_ARRAY);
            return oReturnValue;
        }
        return null;
    }

    public final Object evaluate(String sScriptContent) throws ChartException {
        Context cx = Context.enter();
        try {
            Object object = cx.evaluateString(this.scope, sScriptContent, "<cmd>", 1, null);
            return object;
        }
        catch (RhinoException jsx) {
            throw this.convertException((Exception)((Object)jsx));
        }
        finally {
            Context.exit();
        }
    }

    public final void register(String sScriptName, String sScriptContent) throws ChartException {
        block17: {
            try {
                logger.log(1, Messages.getString("Info.try.load.java.handler"));
                Class handlerClass = null;
                try {
                    handlerClass = Class.forName(sScriptContent);
                }
                catch (ClassNotFoundException ex) {
                    if (this.iscl != null) {
                        handlerClass = this.iscl.loadClass(sScriptContent, SecurityUtil.getClassLoader(ScriptHandler.class));
                    }
                    throw ex;
                }
                if (IChartEventHandler.class.isAssignableFrom(handlerClass)) {
                    try {
                        this.javahandler = (IChartEventHandler)SecurityUtil.newClassInstance(handlerClass);
                    }
                    catch (InstantiationException e) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 4, e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 4, e);
                    }
                    logger.log(1, Messages.getString("Info.java.handler.loaded", handlerClass, ULocale.getDefault()));
                    break block17;
                }
                logger.log(2, Messages.getString("Info.invalid.java.handler", handlerClass, ULocale.getDefault()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.javahandler = null;
                logger.log(1, Messages.getString("Info.try.register.javascript.content"));
                Context cx = Context.enter();
                try {
                    try {
                        cx.evaluateString(this.scope, sScriptContent, sScriptName == null ? "<cmd>" : sScriptName, 1, null);
                        logger.log(1, Messages.getString("Info.javascript.content.registered"));
                        Object[] objs = this.scope.getIds();
                        if (objs != null) {
                            this.javaScriptFunctionNamesCache = new ArrayList<String>();
                            int i = 0;
                            while (i < objs.length) {
                                this.javaScriptFunctionNamesCache.add(String.valueOf(objs[i]));
                                ++i;
                            }
                        } else {
                            this.javaScriptFunctionNamesCache = null;
                        }
                    }
                    catch (RhinoException jsx) {
                        throw this.convertException((Exception)((Object)jsx));
                    }
                }
                finally {
                    Context.exit();
                }
            }
        }
    }

    public void setScriptContext(IChartScriptContext csc) {
        this.csc = csc;
    }

    protected ChartException convertException(Exception ex) {
        if (ex instanceof RhinoException) {
            RhinoException e = (RhinoException)((Object)ex);
            String lineSource = e.lineSource();
            String details = e.details();
            String lineNumber = String.valueOf(e.lineNumber());
            if (lineSource == null) {
                lineSource = "";
            }
            return new ChartException("org.eclipse.birt.chart.engine", 12, "exception.javascript.error", new Object[]{details, lineNumber, lineSource}, Messages.getResourceBundle(this.csc.getULocale()), e);
        }
        return new ChartException("org.eclipse.birt.chart.engine", 12, ex);
    }
}

