/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.CGRect;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageRep;
import org.eclipse.swt.internal.cocoa.NSOpenGLContext;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;
    NSOpenGLContext context;

    Canvas() {
    }

    long attributedSubstringFromRange(long id2, long sel, long range) {
        if (this.ime != null) {
            return this.ime.attributedSubstringFromRange(id2, sel, range);
        }
        return super.attributedSubstringFromRange(id2, sel, range);
    }

    void sendFocusEvent(int type) {
        if (this.caret != null) {
            if (type == 15) {
                this.caret.setFocus();
            } else {
                this.caret.killFocus();
            }
        }
        super.sendFocusEvent(type);
    }

    public Canvas(Composite parent, int style) {
        super(parent, style);
    }

    long characterIndexForPoint(long id2, long sel, long point) {
        if (this.ime != null) {
            return this.ime.characterIndexForPoint(id2, sel, point);
        }
        return super.characterIndexForPoint(id2, sel, point);
    }

    public void drawBackground(GC gc, int x, int y, int width, int height) {
        Control control;
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        if ((control = this.findBackgroundControl()) != null) {
            NSRect rect = new NSRect();
            rect.x = x;
            rect.y = y;
            rect.width = width;
            rect.height = height;
            int imgHeight = -1;
            GCData data = gc.getGCData();
            if (data.image != null) {
                imgHeight = data.image.getBounds().height;
            }
            NSGraphicsContext context = gc.handle;
            if (data.flippedContext != null) {
                NSGraphicsContext.static_saveGraphicsState();
                NSGraphicsContext.setCurrentContext(context);
            }
            control.fillBackground(this.view, context, rect, imgHeight);
            if (data.flippedContext != null) {
                NSGraphicsContext.static_restoreGraphicsState();
            }
        } else {
            gc.fillRectangle(x, y, width, height);
        }
    }

    void drawRect(long id2, long sel, NSRect rect) {
        if (this.context != null && this.context.view() == null) {
            this.context.setView(this.view);
        }
        super.drawRect(id2, sel, rect);
    }

    void drawWidget(long id2, NSGraphicsContext context, NSRect rect) {
        if (id2 != this.view.id) {
            return;
        }
        super.drawWidget(id2, context, rect);
        if (this.caret == null) {
            return;
        }
        if (this.caret.isShowing) {
            Image image = this.caret.image;
            if (image != null) {
                NSImage imageHandle = image.handle;
                NSImageRep imageRep = imageHandle.bestRepresentationForDevice(null);
                if (!imageRep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                    return;
                }
                NSBitmapImageRep rep = new NSBitmapImageRep(imageRep);
                CGRect destRect = new CGRect();
                destRect.origin.x = this.caret.x;
                destRect.origin.y = this.caret.y;
                NSSize size = imageHandle.size();
                destRect.size.width = size.width;
                destRect.size.height = size.height;
                long data = rep.bitmapData();
                long bpr = rep.bytesPerRow();
                int alphaInfo = rep.hasAlpha() ? 4 : 6;
                long provider = OS.CGDataProviderCreateWithData(0L, data, bpr * (long)((int)size.height), 0L);
                long colorspace = OS.CGColorSpaceCreateDeviceRGB();
                long cgImage = OS.CGImageCreate((int)size.width, (int)size.height, rep.bitsPerSample(), rep.bitsPerPixel(), bpr, colorspace, alphaInfo, provider, 0L, true, 0);
                OS.CGColorSpaceRelease(colorspace);
                OS.CGDataProviderRelease(provider);
                long ctx = context.graphicsPort();
                OS.CGContextSaveGState(ctx);
                OS.CGContextScaleCTM(ctx, 1.0, -1.0);
                OS.CGContextTranslateCTM(ctx, 0.0, -(size.height + 2.0 * destRect.origin.y));
                OS.CGContextSetBlendMode(ctx, 10);
                OS.CGContextDrawImage(ctx, destRect, cgImage);
                OS.CGContextRestoreGState(ctx);
                OS.CGImageRelease(cgImage);
            } else {
                context.saveGraphicsState();
                context.setCompositingOperation(10L);
                NSRect drawRect = new NSRect();
                drawRect.x = this.caret.x;
                drawRect.y = this.caret.y;
                drawRect.width = this.caret.width != 0 ? this.caret.width : 1;
                drawRect.height = this.caret.height;
                context.setShouldAntialias(false);
                NSColor color = NSColor.colorWithDeviceRed(1.0, 1.0, 1.0, 1.0);
                color.set();
                NSBezierPath.fillRect(drawRect);
                context.restoreGraphicsState();
            }
        }
    }

    NSRect firstRectForCharacterRange(long id2, long sel, long range) {
        if (this.ime != null) {
            return this.ime.firstRectForCharacterRange(id2, sel, range);
        }
        return super.firstRectForCharacterRange(id2, sel, range);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    boolean hasMarkedText(long id2, long sel) {
        if (this.ime != null) {
            return this.ime.hasMarkedText(id2, sel);
        }
        return super.hasMarkedText(id2, sel);
    }

    boolean imeInComposition() {
        return this.ime != null && this.ime.isInlineEnabled() && this.ime.startOffset != -1;
    }

    boolean insertText(long id2, long sel, long string) {
        if (this.ime != null && !this.ime.insertText(id2, sel, string)) {
            return false;
        }
        return super.insertText(id2, sel, string);
    }

    boolean isOpaque(long id2, long sel) {
        if (this.context != null) {
            return true;
        }
        return super.isOpaque(id2, sel);
    }

    NSRange markedRange(long id2, long sel) {
        if (this.ime != null) {
            return this.ime.markedRange(id2, sel);
        }
        return super.markedRange(id2, sel);
    }

    void releaseChildren(boolean destroy) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(destroy);
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        Control control;
        boolean redraw;
        Rectangle clientRect;
        Rectangle sourceRect;
        boolean isFocus;
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - x;
        int deltaY = destY - y;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        if (!this.isDrawing()) {
            return;
        }
        NSRect visibleRect = this.view.visibleRect();
        if (visibleRect.width <= 0.0 || visibleRect.height <= 0.0) {
            return;
        }
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        if ((sourceRect = new Rectangle(x, y, width, height)).intersects(clientRect = this.getClientArea())) {
            this.update(all);
        }
        boolean bl2 = redraw = (control = this.findBackgroundControl()) != null && control.backgroundImage != null;
        if (!redraw) {
            redraw = this.isObscured();
        }
        if (redraw) {
            this.redrawWidget(this.view, x, y, width, height, false);
            this.redrawWidget(this.view, destX, destY, width, height, false);
        } else {
            boolean disjoint;
            NSRect damage = new NSRect();
            damage.x = x;
            damage.y = y;
            damage.width = width;
            damage.height = height;
            NSPoint dest = new NSPoint();
            dest.x = destX;
            dest.y = destY;
            this.view.lockFocus();
            OS.NSCopyBits(0L, damage, dest);
            this.view.unlockFocus();
            boolean bl3 = disjoint = destX + width < x || x + width < destX || destY + height < y || y + height < destY;
            if (disjoint) {
                this.view.setNeedsDisplayInRect(damage);
            } else {
                if (deltaX != 0) {
                    int newX = destX - deltaX;
                    if (deltaX < 0) {
                        newX = destX + width;
                    }
                    damage.x = newX;
                    damage.width = Math.abs(deltaX);
                    this.view.setNeedsDisplayInRect(damage);
                }
                if (deltaY != 0) {
                    int newY = destY - deltaY;
                    if (deltaY < 0) {
                        newY = destY + height;
                    }
                    damage.x = x;
                    damage.y = newY;
                    damage.width = width;
                    damage.height = Math.abs(deltaY);
                    this.view.setNeedsDisplayInRect(damage);
                }
            }
            NSRect srcRect = new NSRect();
            srcRect.x = sourceRect.x;
            srcRect.y = sourceRect.y;
            srcRect.width = sourceRect.width;
            srcRect.height = sourceRect.height;
            OS.NSIntersectionRect(visibleRect, visibleRect, srcRect);
            if (!OS.NSEqualRects(visibleRect, srcRect)) {
                if (srcRect.x != visibleRect.x) {
                    damage.x = srcRect.x + (double)deltaX;
                    damage.y = srcRect.y + (double)deltaY;
                    damage.width = visibleRect.x - srcRect.x;
                    damage.height = srcRect.height;
                    this.view.setNeedsDisplayInRect(damage);
                }
                if (visibleRect.x + visibleRect.width != srcRect.x + srcRect.width) {
                    damage.x = srcRect.x + visibleRect.width + (double)deltaX;
                    damage.y = srcRect.y + (double)deltaY;
                    damage.width = srcRect.width - visibleRect.width;
                    damage.height = srcRect.height;
                    this.view.setNeedsDisplayInRect(damage);
                }
                if (visibleRect.y != srcRect.y) {
                    damage.x = visibleRect.x + (double)deltaX;
                    damage.y = srcRect.y + (double)deltaY;
                    damage.width = visibleRect.width;
                    damage.height = visibleRect.y - srcRect.y;
                    this.view.setNeedsDisplayInRect(damage);
                }
                if (visibleRect.y + visibleRect.height != srcRect.y + srcRect.height) {
                    damage.x = visibleRect.x + (double)deltaX;
                    damage.y = visibleRect.y + visibleRect.height + (double)deltaY;
                    damage.width = visibleRect.width;
                    damage.height = srcRect.y + srcRect.height - (visibleRect.y + visibleRect.height);
                    this.view.setNeedsDisplayInRect(damage);
                }
            }
        }
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                Rectangle rect = child.getBounds();
                if (Math.min(x + width, rect.x + rect.width) >= Math.max(x, rect.x) && Math.min(y + height, rect.y + rect.height) >= Math.max(y, rect.y)) {
                    child.setLocation(rect.x + deltaX, rect.y + deltaY);
                }
                ++i;
            }
        }
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    NSRange selectedRange(long id2, long sel) {
        if (this.ime != null) {
            return this.ime.selectedRange(id2, sel);
        }
        return super.selectedRange(id2, sel);
    }

    boolean sendKeyEvent(NSEvent nsEvent, int type) {
        if (this.caret != null) {
            NSCursor.setHiddenUntilMouseMoves(true);
        }
        return super.sendKeyEvent(nsEvent, type);
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret newCaret = caret;
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        if (this.hasFocus()) {
            if (oldCaret != null) {
                oldCaret.killFocus();
            }
            if (newCaret != null) {
                if (newCaret.isDisposed()) {
                    this.error(5);
                }
                newCaret.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    void setOpenGLContext(Object value) {
        this.context = (NSOpenGLContext)value;
    }

    public void setIME(IME ime) {
        this.checkWidget();
        if (ime != null && ime.isDisposed()) {
            this.error(5);
        }
        this.ime = ime;
    }

    boolean setMarkedText_selectedRange(long id2, long sel, long string, long range) {
        if (this.ime != null && !this.ime.setMarkedText_selectedRange(id2, sel, string, range)) {
            return false;
        }
        return super.setMarkedText_selectedRange(id2, sel, string, range);
    }

    long validAttributesForMarkedText(long id2, long sel) {
        if (this.ime != null) {
            return this.ime.validAttributesForMarkedText(id2, sel);
        }
        return super.validAttributesForMarkedText(id2, sel);
    }

    void updateOpenGLContext(long id2, long sel, long notification) {
        if (this.context != null) {
            this.context.update();
        }
    }
}

