/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.ErrorLogHandler;
import org.eclipse.mat.ui.snapshot.ImageHelper;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class MemoryAnalyserPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.mat.ui";
    public static final String EDITOR_ID = "org.eclipse.mat.ui.editors.HeapEditor";
    private static MemoryAnalyserPlugin plugin;
    private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>(20);
    private Map<URL, ImageDescriptor> imagePathCache = new HashMap<URL, ImageDescriptor>(20);
    private IExtensionTracker tracker;

    public MemoryAnalyserPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.tracker = new ExtensionTracker(Platform.getExtensionRegistry());
        Logger logger = Logger.getLogger("org.eclipse.mat");
        logger.setUseParentHandlers(false);
        logger.addHandler(new ErrorLogHandler());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.tracker.close();
        for (Image image : this.imageCache.values()) {
            image.dispose();
        }
        this.imageCache.clear();
        super.stop(context);
    }

    public static MemoryAnalyserPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Image getImage(String name) {
        return MemoryAnalyserPlugin.getDefault().getImage(MemoryAnalyserPlugin.getImageDescriptor(name));
    }

    public Image getImage(ImageDescriptor descriptor) {
        Image image = this.imageCache.get(descriptor);
        if (image == null && descriptor != null) {
            image = descriptor.createImage();
            this.imageCache.put(descriptor, image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(URL path) {
        Object descriptor = this.imagePathCache.get(path);
        if (descriptor == null) {
            Image image = this.loadImage(path);
            descriptor = image == null ? MemoryAnalyserPlugin.getImageDescriptor("icons/missing_image.gif") : new ImageHelper.ImageImageDescriptor(image);
            this.imagePathCache.put(path, (ImageDescriptor)descriptor);
        }
        return descriptor;
    }

    public Image getImage(URL path) {
        return this.getImage(this.getImageDescriptor(path));
    }

    /*
     * Loose catch block
     */
    private Image loadImage(URL path) {
        InputStream stream = null;
        stream = path.openStream();
        Image image = new Image((Device)PlatformUI.getWorkbench().getDisplay(), stream);
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return image;
        catch (SWTException e) {
            MemoryAnalyserPlugin.log(e);
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
            return null;
        }
        catch (IOException e2) {
            MemoryAnalyserPlugin.log(e2);
            {
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    public ImageDescriptor getImageDescriptor(QueryDescriptor query) {
        URL url = query != null ? query.getIcon() : null;
        return url != null ? this.getImageDescriptor(url) : null;
    }

    public Image getImage(QueryDescriptor query) {
        ImageDescriptor imageDescriptor = this.getImageDescriptor(query);
        return imageDescriptor == null ? null : this.getImage(imageDescriptor);
    }

    public IExtensionTracker getExtensionTracker() {
        return this.tracker;
    }

    public static void log(IStatus status) {
        MemoryAnalyserPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        MemoryAnalyserPlugin.log(e, Messages.MemoryAnalyserPlugin_InternalError);
    }

    public static void log(Throwable e, String message) {
        MemoryAnalyserPlugin.log((IStatus)new Status(4, PLUGIN_ID, message, e));
    }

    public static interface ISharedImages {
        public static final String HEAP = "icons/heapobjects/heapdump16.gif";
        public static final String OPEN_SNAPSHOT = "icons/open_snapshot.gif";
        public static final String CONSOLE = "icons/console.gif";
        public static final String CONSOLE_PLUS = "icons/console_plus.gif";
        public static final String CONSOLE_REMOVE = "icons/remove_console.gif";
        public static final String COPY = "icons/copy.gif";
        public static final String PLUS = "icons/plus.gif";
        public static final String EXPERT_SYSTEM = "icons/expert.gif";
        public static final String REFRESH = "icons/refresh.gif";
        public static final String THREAD = "icons/thread.gif";
        public static final String RETAINED_SET = "icons/retainedSet.gif";
        public static final String PACKAGE = "icons/package.gif";
        public static final String SYNCED = "icons/synced.gif";
        public static final String SYNCED_DISABLED = "icons/synced_disabled.gif";
        public static final String ID = "icons/id.gif";
        public static final String SIZE = "icons/size.gif";
        public static final String CLASS = "icons/heapobjects/class.gif";
        public static final String SUPERCLASS = "icons/heapobjects/superclass.gif";
        public static final String NOTEPAD = "icons/notepad.gif";
        public static final String ARGUMENTS_WIZARD = "icons/fill_arguments_wiz.gif";
        public static final String QUERY = "icons/query_browser.gif";
        public static final String QUERY_DISABLED = "icons/query_disabled.gif";
        public static final String MISSING_IMAGE = "icons/missing_image.gif";
        public static final String OQL = "icons/oql.gif";
        public static final String IMPORT_REPORT = "icons/import_report.gif";
        public static final String EXPORT_MENU = "icons/export.gif";
        public static final String EXPORT_HTML = "icons/export_html.gif";
        public static final String EXPORT_CSV = "icons/export_csv.gif";
        public static final String EXPORT_TXT = "icons/export_txt.gif";
        public static final String REFRESHING = "icons/refreshing.gif";
        public static final String CALCULATOR = "icons/calculator.gif";
        public static final String FILTER = "icons/filter.gif";
        public static final String GROUPING = "icons/grouping.gif";
        public static final String COMPARE = "icons/compare.gif";
        public static final String PERCENTAGE = "icons/percentage.gif";
        public static final String INFO = "icons/info.gif";
        public static final String HELP = "icons/help.png";
        public static final String FIND = "icons/find.gif";
        public static final String EXECUTE_QUERY = "icons/execute_query.gif";
        public static final String SHOW_AS_HISTOGRAM = "icons/as_histogram.gif";
        public static final String EXPLORE = "icons/explore.gif";
        public static final String SHOW_PANE = "icons/show_pane.gif";
        public static final String CLOSE_PANE = "icons/close_pane.gif";
        public static final String CLOSE_BRANCH = "icons/close_branch.gif";
        public static final String PINNED = "icons/pinned.gif";
    }
}

