/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.viewer;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.query.ContextDerivedData;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.refined.RefinedStructuredResult;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.viewer.RefinedResultViewer;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DerivedDataJob
extends Job
implements RefinedStructuredResult.ICalculationProgress {
    protected RefinedResultViewer viewer;
    protected ContextProvider provider;
    protected ContextDerivedData.DerivedOperation operation;
    protected List<?> subjectItems;

    protected DerivedDataJob(RefinedResultViewer viewer, ContextProvider provider, ContextDerivedData.DerivedOperation operation, List<?> subjectItems) {
        super(Messages.DerivedDataJob_CalculatingRetainedSizes);
        this.viewer = viewer;
        this.provider = provider;
        this.operation = operation;
        this.subjectItems = subjectItems;
        this.setUser(true);
        this.setPriority(30);
    }

    protected final IStatus run(IProgressMonitor monitor) {
        try {
            this.viewer.result.calculate(this.provider, this.operation, this.subjectItems, (RefinedStructuredResult.ICalculationProgress)this, (IProgressListener)new ProgressMonitorWrapper(monitor));
            this.publish();
            return Status.OK_STATUS;
        }
        catch (IProgressListener.OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (SnapshotException e) {
            return ErrorHelper.createErrorStatus(e);
        }
    }

    protected abstract void publish();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class OnFullList
    extends DerivedDataJob {
        Item parent;
        RefinedResultViewer.ControlItem ctrl;
        ArrayInt computed = new ArrayInt();

        public OnFullList(RefinedResultViewer viewer, ContextProvider provider, ContextDerivedData.DerivedOperation operation, List<?> subjectItems, Item parent, RefinedResultViewer.ControlItem ctrl) {
            super(viewer, provider, operation, subjectItems);
            this.parent = parent;
            this.ctrl = ctrl;
        }

        public void done(int index, Object row) {
            if (index < this.ctrl.totals.getVisibleItems()) {
                this.computed.add(index);
            }
            if (this.computed.size() > 5) {
                this.publish();
            }
        }

        @Override
        protected void publish() {
            if (this.computed.isEmpty()) {
                return;
            }
            final int[] done = this.computed.toArray();
            this.computed.clear();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    int ii = 0;
                    while (ii < done.length) {
                        int index = OnFullList.this.parent == null ? done[ii] + 1 : done[ii];
                        Item item = OnFullList.this.viewer.adapter.getItem(OnFullList.this.parent, index);
                        OnFullList.this.viewer.applyTextAndImage(item, item.getData());
                        ++ii;
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class OnSelection
    extends DerivedDataJob {
        List<Item> widgetItems;
        ArrayInt computed = new ArrayInt();

        public OnSelection(RefinedResultViewer viewer, ContextProvider provider, ContextDerivedData.DerivedOperation operation, List<?> subjectItems, List<Item> widgetItems) {
            super(viewer, provider, operation, subjectItems);
            this.widgetItems = widgetItems;
        }

        public void done(int index, Object row) {
            this.computed.add(index);
            if (this.computed.size() > 5) {
                this.publish();
            }
        }

        @Override
        protected void publish() {
            final int[] done = this.computed.toArray();
            this.computed.clear();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    int[] nArray = done;
                    int n = done.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int index = nArray[n2];
                        Item item = OnSelection.this.widgetItems.get(index);
                        if (!item.isDisposed()) {
                            OnSelection.this.viewer.applyTextAndImage(item, item.getData());
                        }
                        ++n2;
                    }
                }
            });
        }
    }
}

